/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.TaskCountEstimator;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ConnectorPlanOptimizerManager;
import com.facebook.presto.sql.planner.OptimizerStatsRecorder;
import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.AddIntermediateAggregations;
import com.facebook.presto.sql.planner.iterative.rule.CanonicalizeExpressions;
import com.facebook.presto.sql.planner.iterative.rule.CreatePartialTopN;
import com.facebook.presto.sql.planner.iterative.rule.DesugarAtTimeZone;
import com.facebook.presto.sql.planner.iterative.rule.DesugarCurrentUser;
import com.facebook.presto.sql.planner.iterative.rule.DesugarLambdaExpression;
import com.facebook.presto.sql.planner.iterative.rule.DesugarRowSubscript;
import com.facebook.presto.sql.planner.iterative.rule.DesugarTryExpression;
import com.facebook.presto.sql.planner.iterative.rule.DetermineJoinDistributionType;
import com.facebook.presto.sql.planner.iterative.rule.DetermineSemiJoinDistributionType;
import com.facebook.presto.sql.planner.iterative.rule.EliminateCrossJoins;
import com.facebook.presto.sql.planner.iterative.rule.EvaluateZeroLimit;
import com.facebook.presto.sql.planner.iterative.rule.EvaluateZeroSample;
import com.facebook.presto.sql.planner.iterative.rule.ExtractSpatialJoins;
import com.facebook.presto.sql.planner.iterative.rule.GatherAndMergeWindows;
import com.facebook.presto.sql.planner.iterative.rule.ImplementBernoulliSampleAsFilter;
import com.facebook.presto.sql.planner.iterative.rule.ImplementFilteredAggregations;
import com.facebook.presto.sql.planner.iterative.rule.InlineProjections;
import com.facebook.presto.sql.planner.iterative.rule.MergeFilters;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimitWithDistinct;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimitWithSort;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimitWithTopN;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimits;
import com.facebook.presto.sql.planner.iterative.rule.MultipleDistinctAggregationToMarkDistinct;
import com.facebook.presto.sql.planner.iterative.rule.PickTableLayout;
import com.facebook.presto.sql.planner.iterative.rule.PruneAggregationColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneAggregationSourceColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneCountAggregationOverScalar;
import com.facebook.presto.sql.planner.iterative.rule.PruneCrossJoinColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneFilterColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneIndexSourceColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneJoinChildrenColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneJoinColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneLimitColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneMarkDistinctColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneOrderByInAggregation;
import com.facebook.presto.sql.planner.iterative.rule.PruneOutputColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneProjectColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneSemiJoinColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneSemiJoinFilteringSourceColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneTableScanColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneTopNColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneValuesColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneWindowColumns;
import com.facebook.presto.sql.planner.iterative.rule.PushAggregationThroughOuterJoin;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughMarkDistinct;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughOuterJoin;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughProject;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughSemiJoin;
import com.facebook.presto.sql.planner.iterative.rule.PushPartialAggregationThroughExchange;
import com.facebook.presto.sql.planner.iterative.rule.PushPartialAggregationThroughJoin;
import com.facebook.presto.sql.planner.iterative.rule.PushProjectionThroughExchange;
import com.facebook.presto.sql.planner.iterative.rule.PushProjectionThroughUnion;
import com.facebook.presto.sql.planner.iterative.rule.PushRemoteExchangeThroughAssignUniqueId;
import com.facebook.presto.sql.planner.iterative.rule.PushTableWriteThroughUnion;
import com.facebook.presto.sql.planner.iterative.rule.PushTopNThroughUnion;
import com.facebook.presto.sql.planner.iterative.rule.RemoveEmptyDelete;
import com.facebook.presto.sql.planner.iterative.rule.RemoveFullSample;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import com.facebook.presto.sql.planner.iterative.rule.RemoveTrivialFilters;
import com.facebook.presto.sql.planner.iterative.rule.RemoveUnreferencedScalarApplyNodes;
import com.facebook.presto.sql.planner.iterative.rule.RemoveUnreferencedScalarLateralNodes;
import com.facebook.presto.sql.planner.iterative.rule.ReorderJoins;
import com.facebook.presto.sql.planner.iterative.rule.RewriteSpatialPartitioningAggregation;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyCountOverConstant;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyExpressions;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyRowExpressions;
import com.facebook.presto.sql.planner.iterative.rule.SingleDistinctAggregationToGroupBy;
import com.facebook.presto.sql.planner.iterative.rule.TransformCorrelatedInPredicateToJoin;
import com.facebook.presto.sql.planner.iterative.rule.TransformCorrelatedLateralJoinToJoin;
import com.facebook.presto.sql.planner.iterative.rule.TransformCorrelatedScalarAggregationToJoin;
import com.facebook.presto.sql.planner.iterative.rule.TransformCorrelatedScalarSubquery;
import com.facebook.presto.sql.planner.iterative.rule.TransformCorrelatedSingleRowSubqueryToProject;
import com.facebook.presto.sql.planner.iterative.rule.TransformExistsApplyToLateralNode;
import com.facebook.presto.sql.planner.iterative.rule.TransformUncorrelatedInPredicateSubqueryToSemiJoin;
import com.facebook.presto.sql.planner.iterative.rule.TransformUncorrelatedLateralToJoin;
import com.facebook.presto.sql.planner.iterative.rule.TranslateExpressions;
import com.facebook.presto.sql.planner.optimizations.AddExchanges;
import com.facebook.presto.sql.planner.optimizations.AddLocalExchanges;
import com.facebook.presto.sql.planner.optimizations.ApplyConnectorOptimization;
import com.facebook.presto.sql.planner.optimizations.CheckSubqueryNodesAreRewritten;
import com.facebook.presto.sql.planner.optimizations.HashGenerationOptimizer;
import com.facebook.presto.sql.planner.optimizations.ImplementIntersectAndExceptAsUnion;
import com.facebook.presto.sql.planner.optimizations.IndexJoinOptimizer;
import com.facebook.presto.sql.planner.optimizations.LimitPushDown;
import com.facebook.presto.sql.planner.optimizations.MetadataDeleteOptimizer;
import com.facebook.presto.sql.planner.optimizations.MetadataQueryOptimizer;
import com.facebook.presto.sql.planner.optimizations.OptimizeMixedDistinctAggregations;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PredicatePushDown;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.PushdownSubfields;
import com.facebook.presto.sql.planner.optimizations.ReplicateSemiJoinInDelete;
import com.facebook.presto.sql.planner.optimizations.RowExpressionPredicatePushDown;
import com.facebook.presto.sql.planner.optimizations.SetFlatteningOptimizer;
import com.facebook.presto.sql.planner.optimizations.StatsRecordingPlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.TransformQuantifiedComparisonApplyToLateralJoin;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.facebook.presto.sql.planner.optimizations.WindowFilterPushDown;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.MBeanExporter;

public class PlanOptimizers {
    private final List<PlanOptimizer> optimizers;
    private final RuleStatsRecorder ruleStats = new RuleStatsRecorder();
    private final OptimizerStatsRecorder optimizerStats = new OptimizerStatsRecorder();
    private final MBeanExporter exporter;

    @Inject
    public PlanOptimizers(Metadata metadata, SqlParser sqlParser, MBeanExporter exporter, SplitManager splitManager, ConnectorPlanOptimizerManager planOptimizerManager, PageSourceManager pageSourceManager, StatsCalculator statsCalculator, CostCalculator costCalculator, @CostCalculator.EstimatedExchanges CostCalculator estimatedExchangesCostCalculator, CostComparator costComparator, TaskCountEstimator taskCountEstimator) {
        this(metadata, sqlParser, false, exporter, splitManager, planOptimizerManager, pageSourceManager, statsCalculator, costCalculator, estimatedExchangesCostCalculator, costComparator, taskCountEstimator);
    }

    @PostConstruct
    public void initialize() {
        this.ruleStats.export(this.exporter);
        this.optimizerStats.export(this.exporter);
    }

    @PreDestroy
    public void destroy() {
        this.ruleStats.unexport(this.exporter);
        this.optimizerStats.unexport(this.exporter);
    }

    public PlanOptimizers(Metadata metadata, SqlParser sqlParser, boolean forceSingleNode, MBeanExporter exporter, SplitManager splitManager, ConnectorPlanOptimizerManager planOptimizerManager, PageSourceManager pageSourceManager, StatsCalculator statsCalculator, CostCalculator costCalculator, CostCalculator estimatedExchangesCostCalculator, CostComparator costComparator, TaskCountEstimator taskCountEstimator) {
        this.exporter = exporter;
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSet predicatePushDownRules = ImmutableSet.of((Object)new MergeFilters());
        ImmutableSet columnPruningRules = ImmutableSet.of((Object)new PruneAggregationColumns(), (Object)new PruneAggregationSourceColumns(), (Object)new PruneCrossJoinColumns(), (Object)new PruneFilterColumns(), (Object)new PruneIndexSourceColumns(), (Object)new PruneJoinChildrenColumns(), (Object[])new Rule[]{new PruneJoinColumns(), new PruneMarkDistinctColumns(), new PruneOutputColumns(), new PruneProjectColumns(), new PruneSemiJoinColumns(), new PruneSemiJoinFilteringSourceColumns(), new PruneTopNColumns(), new PruneValuesColumns(), new PruneWindowColumns(), new PruneLimitColumns(), new PruneTableScanColumns()});
        IterativeOptimizer inlineProjections = new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new InlineProjections(metadata.getFunctionManager()), (Object)new RemoveRedundantIdentityProjections()));
        IterativeOptimizer projectionPushDown = new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushProjectionThroughUnion(), (Object)new PushProjectionThroughExchange()));
        IterativeOptimizer simplifyOptimizer = new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, new SimplifyExpressions(metadata, sqlParser).rules());
        IterativeOptimizer simplifyRowExpressionOptimizer = new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, new SimplifyRowExpressions(metadata).rules());
        StatsRecordingPlanOptimizer predicatePushDown = new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(metadata, sqlParser));
        StatsRecordingPlanOptimizer rowExpressionPredicatePushDown = new StatsRecordingPlanOptimizer(this.optimizerStats, new RowExpressionPredicatePushDown(metadata, sqlParser));
        builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(new DesugarLambdaExpression().rules()).addAll(new DesugarAtTimeZone(metadata, sqlParser).rules()).addAll(new DesugarCurrentUser().rules()).addAll(new DesugarTryExpression().rules()).addAll(new DesugarRowSubscript(metadata, sqlParser).rules()).build()), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, new CanonicalizeExpressions().rules()), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new EvaluateZeroLimit())), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)predicatePushDownRules).addAll((Iterable)columnPruningRules).addAll((Iterable)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections(), (Object)new RemoveFullSample(), (Object)new EvaluateZeroSample(), (Object)new PushLimitThroughProject(), (Object)new MergeLimits(), (Object)new MergeLimitWithSort(), (Object[])new Rule[]{new MergeLimitWithTopN(), new PushLimitThroughMarkDistinct(), new PushLimitThroughOuterJoin(), new PushLimitThroughSemiJoin(), new RemoveTrivialFilters(), new ImplementFilteredAggregations(), new SingleDistinctAggregationToGroupBy(), new MultipleDistinctAggregationToMarkDistinct(), new ImplementBernoulliSampleAsFilter(), new MergeLimitWithDistinct(), new PruneCountAggregationOverScalar(metadata.getFunctionManager()), new PruneOrderByInAggregation(metadata.getFunctionManager()), new RewriteSpatialPartitioningAggregation(metadata)})).build()), simplifyOptimizer, new UnaliasSymbolReferences(metadata.getFunctionManager()), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new SetFlatteningOptimizer(), new ImplementIntersectAndExceptAsUnion(metadata.getFunctionManager()), new LimitPushDown(), new PruneUnreferencedOutputs(), inlineProjections, new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)columnPruningRules), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new TransformExistsApplyToLateralNode(metadata.getFunctionManager()))), new TransformQuantifiedComparisonApplyToLateralJoin(metadata.getFunctionManager()), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveUnreferencedScalarLateralNodes(), (Object)new TransformUncorrelatedLateralToJoin(), (Object)new TransformUncorrelatedInPredicateSubqueryToSemiJoin(), (Object)new TransformCorrelatedScalarAggregationToJoin(metadata.getFunctionManager()), (Object)new TransformCorrelatedLateralJoinToJoin())), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveUnreferencedScalarApplyNodes(), (Object)new TransformCorrelatedInPredicateToJoin(metadata.getFunctionManager()), (Object)new TransformCorrelatedScalarSubquery(), (Object)new TransformCorrelatedLateralJoinToJoin(), (Object)new ImplementFilteredAggregations())), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new InlineProjections(metadata.getFunctionManager()), (Object)new RemoveRedundantIdentityProjections(), (Object)new TransformCorrelatedSingleRowSubqueryToProject())), new CheckSubqueryNodesAreRewritten(), predicatePushDown, new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, new PickTableLayout(metadata, sqlParser).rules()), new PruneUnreferencedOutputs(), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections(), (Object)new PushAggregationThroughOuterJoin(metadata.getFunctionManager()))), inlineProjections, simplifyOptimizer, projectionPushDown, new UnaliasSymbolReferences(metadata.getFunctionManager()), new PruneUnreferencedOutputs(), new IndexJoinOptimizer(metadata), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new SimplifyCountOverConstant(metadata.getFunctionManager()))), new LimitPushDown(), new WindowFilterPushDown(metadata), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).addAll(GatherAndMergeWindows.rules()).build()), inlineProjections, new PruneUnreferencedOutputs(), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new MetadataQueryOptimizer(metadata), new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new EliminateCrossJoins())), predicatePushDown, simplifyOptimizer, new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, new PickTableLayout(metadata, sqlParser).rules())});
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, costCalculator, new TranslateExpressions(metadata, sqlParser).rules()));
        builder.add((Object[])new PlanOptimizer[]{new ApplyConnectorOptimization((Supplier<Map<ConnectorId, Set<ConnectorPlanOptimizer>>>)((Supplier)() -> planOptimizerManager.getOptimizers(ConnectorPlanOptimizerManager.PlanPhase.LOGICAL))), projectionPushDown, new PruneUnreferencedOutputs()});
        builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new PushdownSubfields(metadata)});
        builder.add((Object)rowExpressionPredicatePushDown);
        builder.add((Object)simplifyRowExpressionOptimizer);
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ReorderJoins(costComparator, metadata))));
        builder.add((Object)new OptimizeMixedDistinctAggregations(metadata));
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new CreatePartialTopN(), (Object)new PushTopNThroughUnion())));
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).addAll(new ExtractSpatialJoins(metadata, splitManager, pageSourceManager).rules()).add((Object)new InlineProjections(metadata.getFunctionManager())).build()));
        if (!forceSingleNode) {
            builder.add((Object)new ReplicateSemiJoinInDelete());
            builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new DetermineJoinDistributionType(costComparator, taskCountEstimator), (Object)new DetermineSemiJoinDistributionType(costComparator, taskCountEstimator))));
            builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, estimatedExchangesCostCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushTableWriteThroughUnion())));
            builder.add((Object)new StatsRecordingPlanOptimizer(this.optimizerStats, new AddExchanges(metadata, sqlParser)));
        }
        estimatedExchangesCostCalculator = null;
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveEmptyDelete())));
        builder.add((Object)rowExpressionPredicatePushDown);
        builder.add((Object)simplifyRowExpressionOptimizer);
        builder.add((Object)projectionPushDown);
        builder.add((Object)inlineProjections);
        builder.add((Object)new UnaliasSymbolReferences(metadata.getFunctionManager()));
        builder.add((Object)new PruneUnreferencedOutputs());
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).add((Object)new PushRemoteExchangeThroughAssignUniqueId()).add((Object)new InlineProjections(metadata.getFunctionManager())).build()));
        builder.add((Object)new AddLocalExchanges(metadata, sqlParser));
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushPartialAggregationThroughJoin(), (Object)new PushPartialAggregationThroughExchange(metadata.getFunctionManager()), (Object)new PruneJoinColumns())));
        builder.add((Object)new IterativeOptimizer(this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new AddIntermediateAggregations(), (Object)new RemoveRedundantIdentityProjections())));
        builder.add((Object[])new PlanOptimizer[]{new ApplyConnectorOptimization((Supplier<Map<ConnectorId, Set<ConnectorPlanOptimizer>>>)((Supplier)() -> planOptimizerManager.getOptimizers(ConnectorPlanOptimizerManager.PlanPhase.PHYSICAL))), new IterativeOptimizer(this.ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections()))});
        builder.add((Object)new HashGenerationOptimizer(metadata.getFunctionManager()));
        builder.add((Object)new MetadataDeleteOptimizer(metadata));
        this.optimizers = builder.build();
    }

    public List<PlanOptimizer> get() {
        return this.optimizers;
    }
}

