/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.EqualityInference;
import com.facebook.presto.sql.planner.ExpressionDeterminismEvaluator;
import com.facebook.presto.sql.planner.ExpressionDomainTranslator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.optimizations.JoinNodeUtils;
import com.facebook.presto.sql.planner.optimizations.SetOperationNodeUtils;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

@Deprecated
public class EffectivePredicateExtractor {
    private static final Predicate<Map.Entry<VariableReferenceExpression, ? extends Expression>> VARIABLE_MATCHES_EXPRESSION = entry -> ((Expression)entry.getValue()).equals((Object)new SymbolReference(((VariableReferenceExpression)entry.getKey()).getName()));
    private static final Function<Map.Entry<VariableReferenceExpression, ? extends Expression>, Expression> VARIABLE_ENTRY_TO_EQUALITY = entry -> {
        SymbolReference reference = new SymbolReference(((VariableReferenceExpression)entry.getKey()).getName());
        Expression expression = (Expression)entry.getValue();
        return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)reference, expression);
    };
    private final ExpressionDomainTranslator domainTranslator;

    public EffectivePredicateExtractor(ExpressionDomainTranslator domainTranslator) {
        this.domainTranslator = Objects.requireNonNull(domainTranslator, "domainTranslator is null");
    }

    public Expression extract(PlanNode node, TypeProvider types) {
        return (Expression)node.accept((PlanVisitor)new Visitor(this.domainTranslator, types), null);
    }

    private static class Visitor
    extends InternalPlanVisitor<Expression, Void> {
        private final ExpressionDomainTranslator domainTranslator;
        private final TypeProvider types;

        public Visitor(ExpressionDomainTranslator domainTranslator, TypeProvider types) {
            this.domainTranslator = Objects.requireNonNull(domainTranslator, "domainTranslator is null");
            this.types = Objects.requireNonNull(types, "types is null");
        }

        public Expression visitPlan(PlanNode node, Void context) {
            return BooleanLiteral.TRUE_LITERAL;
        }

        public Expression visitAggregation(AggregationNode node, Void context) {
            if (node.getGroupingKeys().isEmpty()) {
                return BooleanLiteral.TRUE_LITERAL;
            }
            Expression underlyingPredicate = (Expression)node.getSource().accept((PlanVisitor)this, (Object)context);
            return this.pullExpressionThroughVariables(underlyingPredicate, node.getGroupingKeys());
        }

        public Expression visitFilter(FilterNode node, Void context) {
            Expression underlyingPredicate = (Expression)node.getSource().accept((PlanVisitor)this, (Object)context);
            Expression predicate = OriginalExpressionUtils.castToExpression(node.getPredicate());
            predicate = ExpressionUtils.filterDeterministicConjuncts(predicate);
            return ExpressionUtils.combineConjuncts(predicate, underlyingPredicate);
        }

        @Override
        public Expression visitExchange(ExchangeNode node, Void context) {
            return this.deriveCommonPredicates(node, source -> {
                HashMap<VariableReferenceExpression, SymbolReference> mappings = new HashMap<VariableReferenceExpression, SymbolReference>();
                for (int i = 0; i < node.getInputs().get((int)source).size(); ++i) {
                    mappings.put(node.getOutputVariables().get(i), new SymbolReference(node.getInputs().get((int)source).get(i).getName()));
                }
                return mappings.entrySet();
            });
        }

        public Expression visitProject(ProjectNode node, Void context) {
            Expression underlyingPredicate = (Expression)node.getSource().accept((PlanVisitor)this, (Object)context);
            List projectionEqualities = (List)Maps.transformValues((Map)node.getAssignments().getMap(), OriginalExpressionUtils::castToExpression).entrySet().stream().filter(VARIABLE_MATCHES_EXPRESSION.negate()).map(VARIABLE_ENTRY_TO_EQUALITY).collect(ImmutableList.toImmutableList());
            return this.pullExpressionThroughVariables(ExpressionUtils.combineConjuncts((Collection<Expression>)ImmutableList.builder().addAll((Iterable)projectionEqualities).add((Object)underlyingPredicate).build()), node.getOutputVariables());
        }

        public Expression visitTopN(TopNNode node, Void context) {
            return (Expression)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Expression visitLimit(LimitNode node, Void context) {
            return (Expression)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Expression visitAssignUniqueId(AssignUniqueId node, Void context) {
            return (Expression)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Expression visitDistinctLimit(DistinctLimitNode node, Void context) {
            return (Expression)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Expression visitTableScan(TableScanNode node, Void context) {
            ImmutableBiMap assignments = ImmutableBiMap.copyOf((Map)node.getAssignments()).inverse();
            return this.domainTranslator.toPredicate((TupleDomain<String>)node.getCurrentConstraint().simplify().transform(arg_0 -> Visitor.lambda$visitTableScan$1((Map)assignments, arg_0)));
        }

        @Override
        public Expression visitSort(SortNode node, Void context) {
            return (Expression)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Expression visitWindow(WindowNode node, Void context) {
            return (Expression)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Expression visitUnion(UnionNode node, Void context) {
            return this.deriveCommonPredicates((PlanNode)node, source -> Multimaps.transformValues(SetOperationNodeUtils.outputMap(node, source), variable -> new SymbolReference(variable.getName())).entries());
        }

        @Override
        public Expression visitJoin(JoinNode node, Void context) {
            Expression leftPredicate = (Expression)node.getLeft().accept((PlanVisitor)this, (Object)context);
            Expression rightPredicate = (Expression)node.getRight().accept((PlanVisitor)this, (Object)context);
            List joinConjuncts = (List)node.getCriteria().stream().map(JoinNodeUtils::toExpression).collect(ImmutableList.toImmutableList());
            switch (node.getType()) {
                case INNER: {
                    return this.pullExpressionThroughVariables(ExpressionUtils.combineConjuncts((Collection<Expression>)ImmutableList.builder().add((Object)leftPredicate).add((Object)rightPredicate).add((Object)ExpressionUtils.combineConjuncts(joinConjuncts)).add((Object)node.getFilter().map(OriginalExpressionUtils::castToExpression).orElse((Expression)BooleanLiteral.TRUE_LITERAL)).build()), node.getOutputVariables());
                }
                case LEFT: {
                    Predicate[] predicateArray = new Predicate[1];
                    predicateArray[0] = node.getRight().getOutputVariables()::contains;
                    Predicate[] predicateArray2 = new Predicate[1];
                    predicateArray2[0] = node.getRight().getOutputVariables()::contains;
                    return ExpressionUtils.combineConjuncts((Collection<Expression>)ImmutableList.builder().add((Object)this.pullExpressionThroughVariables(leftPredicate, node.getOutputVariables())).addAll(this.pullNullableConjunctsThroughOuterJoin(ExpressionUtils.extractConjuncts(rightPredicate), node.getOutputVariables(), predicateArray)).addAll(this.pullNullableConjunctsThroughOuterJoin(joinConjuncts, node.getOutputVariables(), predicateArray2)).build());
                }
                case RIGHT: {
                    Predicate[] predicateArray = new Predicate[1];
                    predicateArray[0] = node.getLeft().getOutputVariables()::contains;
                    Predicate[] predicateArray3 = new Predicate[1];
                    predicateArray3[0] = node.getLeft().getOutputVariables()::contains;
                    return ExpressionUtils.combineConjuncts((Collection<Expression>)ImmutableList.builder().add((Object)this.pullExpressionThroughVariables(rightPredicate, node.getOutputVariables())).addAll(this.pullNullableConjunctsThroughOuterJoin(ExpressionUtils.extractConjuncts(leftPredicate), node.getOutputVariables(), predicateArray)).addAll(this.pullNullableConjunctsThroughOuterJoin(joinConjuncts, node.getOutputVariables(), predicateArray3)).build());
                }
                case FULL: {
                    Predicate[] predicateArray = new Predicate[1];
                    predicateArray[0] = node.getLeft().getOutputVariables()::contains;
                    Predicate[] predicateArray4 = new Predicate[1];
                    predicateArray4[0] = node.getRight().getOutputVariables()::contains;
                    Predicate[] predicateArray5 = new Predicate[2];
                    predicateArray5[0] = node.getLeft().getOutputVariables()::contains;
                    predicateArray5[1] = node.getRight().getOutputVariables()::contains;
                    return ExpressionUtils.combineConjuncts((Collection<Expression>)ImmutableList.builder().addAll(this.pullNullableConjunctsThroughOuterJoin(ExpressionUtils.extractConjuncts(leftPredicate), node.getOutputVariables(), predicateArray)).addAll(this.pullNullableConjunctsThroughOuterJoin(ExpressionUtils.extractConjuncts(rightPredicate), node.getOutputVariables(), predicateArray4)).addAll(this.pullNullableConjunctsThroughOuterJoin(joinConjuncts, node.getOutputVariables(), predicateArray5)).build());
                }
            }
            throw new UnsupportedOperationException("Unknown join type: " + (Object)((Object)node.getType()));
        }

        private Iterable<Expression> pullNullableConjunctsThroughOuterJoin(List<Expression> conjuncts, Collection<VariableReferenceExpression> outputVariables, Predicate<VariableReferenceExpression> ... nullVariableScopes) {
            return (Iterable)conjuncts.stream().map(expression -> this.pullExpressionThroughVariables((Expression)expression, outputVariables)).map(expression -> VariablesExtractor.extractAll(expression, this.types).isEmpty() ? BooleanLiteral.TRUE_LITERAL : expression).map(ExpressionUtils.expressionOrNullVariables(this.types, nullVariableScopes)).collect(ImmutableList.toImmutableList());
        }

        @Override
        public Expression visitSemiJoin(SemiJoinNode node, Void context) {
            return (Expression)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Expression visitSpatialJoin(SpatialJoinNode node, Void context) {
            Expression leftPredicate = (Expression)node.getLeft().accept((PlanVisitor)this, (Object)context);
            Expression rightPredicate = (Expression)node.getRight().accept((PlanVisitor)this, (Object)context);
            switch (node.getType()) {
                case INNER: {
                    return ExpressionUtils.combineConjuncts((Collection<Expression>)ImmutableList.builder().add((Object)this.pullExpressionThroughVariables(leftPredicate, node.getOutputVariables())).add((Object)this.pullExpressionThroughVariables(rightPredicate, node.getOutputVariables())).build());
                }
                case LEFT: {
                    Predicate[] predicateArray = new Predicate[1];
                    predicateArray[0] = node.getRight().getOutputVariables()::contains;
                    return ExpressionUtils.combineConjuncts((Collection<Expression>)ImmutableList.builder().add((Object)this.pullExpressionThroughVariables(leftPredicate, node.getOutputVariables())).addAll(this.pullNullableConjunctsThroughOuterJoin(ExpressionUtils.extractConjuncts(rightPredicate), node.getOutputVariables(), predicateArray)).build());
                }
            }
            throw new IllegalArgumentException("Unsupported spatial join type: " + (Object)((Object)node.getType()));
        }

        private Expression deriveCommonPredicates(PlanNode node, Function<Integer, Collection<Map.Entry<VariableReferenceExpression, SymbolReference>>> mapping) {
            ArrayList<ImmutableSet> sourceOutputConjuncts = new ArrayList<ImmutableSet>();
            for (int i = 0; i < node.getSources().size(); ++i) {
                Expression underlyingPredicate = (Expression)((PlanNode)node.getSources().get(i)).accept((PlanVisitor)this, null);
                List equalities = (List)mapping.apply(i).stream().filter(VARIABLE_MATCHES_EXPRESSION.negate()).map(VARIABLE_ENTRY_TO_EQUALITY).collect(ImmutableList.toImmutableList());
                sourceOutputConjuncts.add(ImmutableSet.copyOf(ExpressionUtils.extractConjuncts(this.pullExpressionThroughVariables(ExpressionUtils.combineConjuncts((Collection<Expression>)ImmutableList.builder().addAll((Iterable)equalities).add((Object)underlyingPredicate).build()), node.getOutputVariables()))));
            }
            Iterator iterator = sourceOutputConjuncts.iterator();
            Set potentialOutputConjuncts = (Set)iterator.next();
            while (iterator.hasNext()) {
                potentialOutputConjuncts = Sets.intersection((Set)potentialOutputConjuncts, (Set)((Set)iterator.next()));
            }
            return ExpressionUtils.combineConjuncts(potentialOutputConjuncts);
        }

        private Expression pullExpressionThroughVariables(Expression expression, Collection<VariableReferenceExpression> variables) {
            EqualityInference equalityInference = EqualityInference.createEqualityInference(expression);
            ImmutableList.Builder effectiveConjuncts = ImmutableList.builder();
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(expression)) {
                Expression rewritten;
                if (!ExpressionDeterminismEvaluator.isDeterministic(conjunct) || (rewritten = equalityInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(variables), this.types)) == null) continue;
                effectiveConjuncts.add((Object)rewritten);
            }
            effectiveConjuncts.addAll(equalityInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(variables), this.types).getScopeEqualities());
            return ExpressionUtils.combineConjuncts((Collection<Expression>)effectiveConjuncts.build());
        }

        private static /* synthetic */ String lambda$visitTableScan$1(Map assignments, ColumnHandle column) {
            return assignments.containsKey(column) ? ((VariableReferenceExpression)assignments.get(column)).getName() : null;
        }
    }
}

