/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.dispatcher.DispatchManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.memory.ClusterMemoryManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.NodeState;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/v1/cluster")
public class ClusterStatsResource {
    private final InternalNodeManager nodeManager;
    private final DispatchManager dispatchManager;
    private final boolean isIncludeCoordinator;
    private final ClusterMemoryManager clusterMemoryManager;

    @Inject
    public ClusterStatsResource(NodeSchedulerConfig nodeSchedulerConfig, InternalNodeManager nodeManager, DispatchManager dispatchManager, ClusterMemoryManager clusterMemoryManager) {
        this.isIncludeCoordinator = Objects.requireNonNull(nodeSchedulerConfig, "nodeSchedulerConfig is null").isIncludeCoordinator();
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.clusterMemoryManager = Objects.requireNonNull(clusterMemoryManager, "clusterMemoryManager is null");
    }

    @GET
    @Produces(value={"application/json"})
    public ClusterStats getClusterStats() {
        long runningQueries = 0L;
        long blockedQueries = 0L;
        long queuedQueries = 0L;
        long activeNodes = this.nodeManager.getNodes(NodeState.ACTIVE).size();
        if (!this.isIncludeCoordinator) {
            --activeNodes;
        }
        long runningDrivers = 0L;
        double memoryReservation = 0.0;
        long totalInputRows = this.dispatchManager.getStats().getConsumedInputRows().getTotalCount();
        long totalInputBytes = this.dispatchManager.getStats().getConsumedInputBytes().getTotalCount();
        long totalCpuTimeSecs = this.dispatchManager.getStats().getConsumedCpuTimeSecs().getTotalCount();
        for (BasicQueryInfo query : this.dispatchManager.getQueries()) {
            if (query.getState() == QueryState.QUEUED) {
                ++queuedQueries;
            } else if (query.getState() == QueryState.RUNNING) {
                if (query.getQueryStats().isFullyBlocked()) {
                    ++blockedQueries;
                } else {
                    ++runningQueries;
                }
            }
            if (query.getState().isDone()) continue;
            totalInputBytes += query.getQueryStats().getRawInputDataSize().toBytes();
            totalInputRows += query.getQueryStats().getRawInputPositions();
            totalCpuTimeSecs = (long)((double)totalCpuTimeSecs + query.getQueryStats().getTotalCpuTime().getValue(TimeUnit.SECONDS));
            memoryReservation += (double)query.getQueryStats().getUserMemoryReservation().toBytes();
            runningDrivers += (long)query.getQueryStats().getRunningDrivers();
        }
        return new ClusterStats(runningQueries, blockedQueries, queuedQueries, activeNodes, runningDrivers, memoryReservation, totalInputRows, totalInputBytes, totalCpuTimeSecs);
    }

    @GET
    @Path(value="memory")
    public Response getClusterMemoryPoolInfo() {
        return Response.ok().entity(this.clusterMemoryManager.getMemoryPoolInfo()).build();
    }

    @GET
    @Path(value="workerMemory")
    public Response getWorkerMemoryInfo() {
        return Response.ok().entity(this.clusterMemoryManager.getWorkerMemoryInfo()).build();
    }

    public static class ClusterStats {
        private final long runningQueries;
        private final long blockedQueries;
        private final long queuedQueries;
        private final long activeWorkers;
        private final long runningDrivers;
        private final double reservedMemory;
        private final long totalInputRows;
        private final long totalInputBytes;
        private final long totalCpuTimeSecs;

        @JsonCreator
        public ClusterStats(@JsonProperty(value="runningQueries") long runningQueries, @JsonProperty(value="blockedQueries") long blockedQueries, @JsonProperty(value="queuedQueries") long queuedQueries, @JsonProperty(value="activeWorkers") long activeWorkers, @JsonProperty(value="runningDrivers") long runningDrivers, @JsonProperty(value="reservedMemory") double reservedMemory, @JsonProperty(value="totalInputRows") long totalInputRows, @JsonProperty(value="totalInputBytes") long totalInputBytes, @JsonProperty(value="totalCpuTimeSecs") long totalCpuTimeSecs) {
            this.runningQueries = runningQueries;
            this.blockedQueries = blockedQueries;
            this.queuedQueries = queuedQueries;
            this.activeWorkers = activeWorkers;
            this.runningDrivers = runningDrivers;
            this.reservedMemory = reservedMemory;
            this.totalInputRows = totalInputRows;
            this.totalInputBytes = totalInputBytes;
            this.totalCpuTimeSecs = totalCpuTimeSecs;
        }

        @JsonProperty
        public long getRunningQueries() {
            return this.runningQueries;
        }

        @JsonProperty
        public long getBlockedQueries() {
            return this.blockedQueries;
        }

        @JsonProperty
        public long getQueuedQueries() {
            return this.queuedQueries;
        }

        @JsonProperty
        public long getActiveWorkers() {
            return this.activeWorkers;
        }

        @JsonProperty
        public long getRunningDrivers() {
            return this.runningDrivers;
        }

        @JsonProperty
        public double getReservedMemory() {
            return this.reservedMemory;
        }

        @JsonProperty
        public long getTotalInputRows() {
            return this.totalInputRows;
        }

        @JsonProperty
        public long getTotalInputBytes() {
            return this.totalInputBytes;
        }

        @JsonProperty
        public long getTotalCpuTimeSecs() {
            return this.totalCpuTimeSecs;
        }
    }
}

