/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.airlift.stats.QuantileDigest;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.operator.aggregation.FloatingPointBitsConverterUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.util.Failures;
import io.airlift.slice.Slice;

public final class QuantileDigestFunctions {
    public static final double DEFAULT_ACCURACY = 0.01;
    public static final long DEFAULT_WEIGHT = 1L;

    private QuantileDigestFunctions() {
    }

    @ScalarFunction(value="value_at_quantile")
    @Description(value="Given an input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="double")
    public static double valueAtQuantileDouble(@SqlType(value="qdigest(double)") Slice input, @SqlType(value="double") double quantile) {
        return FloatingPointBitsConverterUtil.sortableLongToDouble(QuantileDigestFunctions.valueAtQuantileBigint(input, quantile));
    }

    @ScalarFunction(value="value_at_quantile")
    @Description(value="Given an input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="real")
    public static long valueAtQuantileReal(@SqlType(value="qdigest(real)") Slice input, @SqlType(value="double") double quantile) {
        return Float.floatToRawIntBits(FloatingPointBitsConverterUtil.sortableIntToFloat((int)QuantileDigestFunctions.valueAtQuantileBigint(input, quantile)));
    }

    @ScalarFunction(value="value_at_quantile")
    @Description(value="Given an input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="bigint")
    public static long valueAtQuantileBigint(@SqlType(value="qdigest(bigint)") Slice input, @SqlType(value="double") double quantile) {
        Failures.checkCondition(quantile >= 0.0 && quantile <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Quantile should be within bounds [0, 1], was: " + quantile, new Object[0]);
        return new QuantileDigest(input).getQuantile(quantile);
    }

    @ScalarFunction(value="values_at_quantiles")
    @Description(value="For each input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="array(double)")
    public static Block valuesAtQuantilesDouble(@SqlType(value="qdigest(double)") Slice input, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        QuantileDigest digest = new QuantileDigest(input);
        BlockBuilder output = DoubleType.DOUBLE.createBlockBuilder(null, percentilesArrayBlock.getPositionCount());
        for (int i = 0; i < percentilesArrayBlock.getPositionCount(); ++i) {
            DoubleType.DOUBLE.writeDouble(output, FloatingPointBitsConverterUtil.sortableLongToDouble(digest.getQuantile(DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i))));
        }
        return output.build();
    }

    @ScalarFunction(value="values_at_quantiles")
    @Description(value="For each input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="array(real)")
    public static Block valuesAtQuantilesReal(@SqlType(value="qdigest(real)") Slice input, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        QuantileDigest digest = new QuantileDigest(input);
        BlockBuilder output = RealType.REAL.createBlockBuilder(null, percentilesArrayBlock.getPositionCount());
        for (int i = 0; i < percentilesArrayBlock.getPositionCount(); ++i) {
            RealType.REAL.writeLong(output, (long)Float.floatToRawIntBits(FloatingPointBitsConverterUtil.sortableIntToFloat((int)digest.getQuantile(DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i)))));
        }
        return output.build();
    }

    @ScalarFunction(value="values_at_quantiles")
    @Description(value="For each input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="array(bigint)")
    public static Block valuesAtQuantilesBigint(@SqlType(value="qdigest(bigint)") Slice input, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        QuantileDigest digest = new QuantileDigest(input);
        BlockBuilder output = BigintType.BIGINT.createBlockBuilder(null, percentilesArrayBlock.getPositionCount());
        for (int i = 0; i < percentilesArrayBlock.getPositionCount(); ++i) {
            BigintType.BIGINT.writeLong(output, digest.getQuantile(DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i)));
        }
        return output.build();
    }

    @ScalarFunction(value="scale_qdigest")
    @Description(value="Scale a quantile digest according to a new weight")
    @SqlType(value="qdigest(double)")
    public static Slice scaleQuantileDigestDouble(@SqlType(value="qdigest(double)") Slice input, @SqlType(value="double") double scale) {
        return QuantileDigestFunctions.scaleQuantileDigest(input, scale);
    }

    @ScalarFunction(value="scale_qdigest")
    @Description(value="Scale a quantile digest according to a new weight")
    @SqlType(value="qdigest(real)")
    public static Slice scaleQuantileDigestReal(@SqlType(value="qdigest(real)") Slice input, @SqlType(value="double") double scale) {
        return QuantileDigestFunctions.scaleQuantileDigest(input, scale);
    }

    @ScalarFunction(value="scale_qdigest")
    @Description(value="Scale a quantile digest according to a new weight")
    @SqlType(value="qdigest(bigint)")
    public static Slice scaleQuantileDigestBigint(@SqlType(value="qdigest(bigint)") Slice input, @SqlType(value="double") double scale) {
        return QuantileDigestFunctions.scaleQuantileDigest(input, scale);
    }

    private static Slice scaleQuantileDigest(Slice input, double scale) {
        Failures.checkCondition(scale > 0.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Scale factor should be positive.", new Object[0]);
        QuantileDigest digest = new QuantileDigest(input);
        digest.scale(scale);
        return digest.serialize();
    }

    public static double verifyAccuracy(double accuracy) {
        Failures.checkCondition(accuracy > 0.0 && accuracy < 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile accuracy must be exclusively between 0 and 1, was %s", accuracy);
        return accuracy;
    }

    public static long verifyWeight(long weight) {
        Failures.checkCondition(weight > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile weight must be > 0, was %s", weight);
        return weight;
    }
}

