/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.JsonCastException;
import com.facebook.presto.util.JsonUtil;
import com.facebook.presto.util.Reflection;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class JsonToArrayCast
extends SqlOperator {
    public static final JsonToArrayCast JSON_TO_ARRAY = new JsonToArrayCast();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(JsonToArrayCast.class, "toArray", ArrayType.class, JsonUtil.BlockBuilderAppender.class, SqlFunctionProperties.class, Slice.class);

    private JsonToArrayCast() {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"array(T)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"json")));
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionManager functionManager) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type type = boundVariables.getTypeVariable("T");
        ArrayType arrayType = (ArrayType)typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)type.getTypeSignature())));
        Failures.checkCondition(JsonUtil.canCastFromJson((Type)arrayType), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast JSON to %s", arrayType);
        JsonUtil.BlockBuilderAppender elementAppender = JsonUtil.BlockBuilderAppender.createBlockBuilderAppender(arrayType.getElementType());
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(arrayType).bindTo(elementAppender);
        return new BuiltInScalarFunctionImplementation(true, (List<BuiltInScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @UsedByGeneratedCode
    public static Block toArray(ArrayType arrayType, JsonUtil.BlockBuilderAppender elementAppender, SqlFunctionProperties properties, Slice json) {
        try (JsonParser jsonParser = JsonUtil.createJsonParser(JsonUtil.JSON_FACTORY, json);){
            jsonParser.nextToken();
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_NULL) {
                Block block = null;
                return block;
            }
            if (jsonParser.getCurrentToken() != JsonToken.START_ARRAY) {
                throw new JsonCastException(String.format("Expected a json array, but got %s", jsonParser.getText()));
            }
            BlockBuilder blockBuilder = arrayType.getElementType().createBlockBuilder(null, 20);
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                elementAppender.append(jsonParser, blockBuilder);
            }
            if (jsonParser.nextToken() != null) {
                throw new JsonCastException(String.format("Unexpected trailing token: %s", jsonParser.getText()));
            }
            Block block = blockBuilder.build();
            return block;
        }
        catch (PrestoException | JsonCastException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast to %s. %s\n%s", arrayType, e.getMessage(), JsonUtil.truncateIfNecessaryForErrorMessage(json)), e);
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast to %s.\n%s", arrayType, JsonUtil.truncateIfNecessaryForErrorMessage(json)), (Throwable)e);
        }
    }
}

