/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ColumnarArray;
import com.facebook.presto.common.block.ColumnarMap;
import com.facebook.presto.common.block.ColumnarRow;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

class DecodedBlockNode {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DecodedBlockNode.class).instanceSize();
    private final Object decodedBlock;
    private final List<DecodedBlockNode> children;
    private final long retainedSizeInBytes;
    private final long estimatedSerializedSizeInBytes;
    private final long childrenEstimatedSerializedSizeInBytes;

    public DecodedBlockNode(Object decodedBlock, List<DecodedBlockNode> children) {
        this.decodedBlock = Objects.requireNonNull(decodedBlock, "decodedBlock is null");
        this.children = Objects.requireNonNull(children, "children is null");
        long retainedSize = INSTANCE_SIZE;
        long estimatedSerializedSize = 0L;
        if (decodedBlock instanceof Block) {
            retainedSize += ((Block)decodedBlock).getRetainedSizeInBytes();
            estimatedSerializedSize += ((Block)decodedBlock).getLogicalSizeInBytes();
        } else if (decodedBlock instanceof ColumnarArray) {
            retainedSize += ((ColumnarArray)decodedBlock).getRetainedSizeInBytes();
            estimatedSerializedSize += ((ColumnarArray)decodedBlock).getEstimatedSerializedSizeInBytes();
        } else if (decodedBlock instanceof ColumnarMap) {
            retainedSize += ((ColumnarMap)decodedBlock).getRetainedSizeInBytes();
            estimatedSerializedSize += ((ColumnarMap)decodedBlock).getEstimatedSerializedSizeInBytes();
        } else if (decodedBlock instanceof ColumnarRow) {
            retainedSize += ((ColumnarRow)decodedBlock).getRetainedSizeInBytes();
            estimatedSerializedSize += ((ColumnarRow)decodedBlock).getEstimatedSerializedSizeInBytes();
        }
        this.retainedSizeInBytes = retainedSize;
        this.estimatedSerializedSizeInBytes = estimatedSerializedSize;
        long childrenEstimatedSerializedSize = 0L;
        for (int i = 0; i < children.size(); ++i) {
            childrenEstimatedSerializedSize += children.get(i).getEstimatedSerializedSizeInBytes();
        }
        this.childrenEstimatedSerializedSizeInBytes = childrenEstimatedSerializedSize;
    }

    public Object getDecodedBlock() {
        return this.decodedBlock;
    }

    public List<DecodedBlockNode> getChildren() {
        return this.children;
    }

    public long getChildrenEstimatedSerializedSizeInBytes() {
        return this.childrenEstimatedSerializedSizeInBytes;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public long getEstimatedSerializedSizeInBytes() {
        return this.estimatedSerializedSizeInBytes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DecodedBlockNode{");
        sb.append("decodedBlock=").append(this.decodedBlock.toString()).append(",");
        sb.append("childrenCount=").append(this.children.size()).append(",");
        for (int i = 0; i < this.children.size(); ++i) {
            sb.append("fieldBuffer_").append(i).append("=").append(this.children.get(i).toString()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

