/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.common.block.ArrayAllocator;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ByteArrayBlock;
import com.facebook.presto.common.block.ColumnarArray;
import com.facebook.presto.common.block.ColumnarMap;
import com.facebook.presto.common.block.ColumnarRow;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.Int128ArrayBlock;
import com.facebook.presto.common.block.IntArrayBlock;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.block.ShortArrayBlock;
import com.facebook.presto.common.block.VariableWidthBlock;
import com.facebook.presto.operator.MoreByteArrays;
import com.facebook.presto.operator.UncheckedByteArrays;
import com.facebook.presto.operator.repartition.ArrayBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.BlockEncodingBuffer;
import com.facebook.presto.operator.repartition.ByteArrayBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.DecodedBlockNode;
import com.facebook.presto.operator.repartition.Int128ArrayBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.IntArrayBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.LongArrayBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.MapBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.RowBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.ShortArrayBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.VariableWidthBlockEncodingBuffer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import io.airlift.slice.SliceOutput;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class AbstractBlockEncodingBuffer
implements BlockEncodingBuffer {
    protected final ArrayAllocator bufferAllocator;
    protected final boolean isNested;
    protected Block decodedBlock;
    protected int positionCount;
    protected int batchSize;
    protected int positionsOffset;
    protected int bufferedPositionCount;
    protected boolean positionsMapped;
    protected boolean flushed;
    private int[] positions;
    @Nullable
    private int[] mappedPositions;
    @Nullable
    private byte[] nullsBuffer;
    private int nullsBufferIndex;
    private int estimatedNullsBufferMaxCapacity;
    private final boolean[] remainingNulls = new boolean[8];
    private int remainingNullsCount;
    private boolean hasEncodedNulls;

    protected abstract void setupDecodedBlockAndMapPositions(DecodedBlockNode var1, int var2, double var3);

    protected AbstractBlockEncodingBuffer(ArrayAllocator bufferAllocator, boolean isNested) {
        this.bufferAllocator = Objects.requireNonNull(bufferAllocator, "bufferAllocator is null");
        this.isNested = isNested;
    }

    public static BlockEncodingBuffer createBlockEncodingBuffers(DecodedBlockNode decodedBlockNode, ArrayAllocator bufferAllocator, boolean isNested) {
        Objects.requireNonNull(decodedBlockNode, "decodedBlockNode is null");
        Objects.requireNonNull(bufferAllocator, "bufferAllocator is null");
        Object decodedBlock = decodedBlockNode.getDecodedBlock();
        if (decodedBlock instanceof DictionaryBlock) {
            decodedBlockNode = decodedBlockNode.getChildren().get(0);
            decodedBlock = decodedBlockNode.getDecodedBlock();
        } else if (decodedBlock instanceof RunLengthEncodedBlock) {
            decodedBlockNode = decodedBlockNode.getChildren().get(0);
            decodedBlock = decodedBlockNode.getDecodedBlock();
        }
        Verify.verify((!(decodedBlock instanceof DictionaryBlock) ? 1 : 0) != 0, (String)"Nested RLEs and dictionaries are not supported", (Object[])new Object[0]);
        Verify.verify((!(decodedBlock instanceof RunLengthEncodedBlock) ? 1 : 0) != 0, (String)"Nested RLEs and dictionaries are not supported", (Object[])new Object[0]);
        if (decodedBlock instanceof LongArrayBlock) {
            return new LongArrayBlockEncodingBuffer(bufferAllocator, isNested);
        }
        if (decodedBlock instanceof Int128ArrayBlock) {
            return new Int128ArrayBlockEncodingBuffer(bufferAllocator, isNested);
        }
        if (decodedBlock instanceof IntArrayBlock) {
            return new IntArrayBlockEncodingBuffer(bufferAllocator, isNested);
        }
        if (decodedBlock instanceof ShortArrayBlock) {
            return new ShortArrayBlockEncodingBuffer(bufferAllocator, isNested);
        }
        if (decodedBlock instanceof ByteArrayBlock) {
            return new ByteArrayBlockEncodingBuffer(bufferAllocator, isNested);
        }
        if (decodedBlock instanceof VariableWidthBlock) {
            return new VariableWidthBlockEncodingBuffer(bufferAllocator, isNested);
        }
        if (decodedBlock instanceof ColumnarArray) {
            return new ArrayBlockEncodingBuffer(decodedBlockNode, bufferAllocator, isNested);
        }
        if (decodedBlock instanceof ColumnarMap) {
            return new MapBlockEncodingBuffer(decodedBlockNode, bufferAllocator, isNested);
        }
        if (decodedBlock instanceof ColumnarRow) {
            return new RowBlockEncodingBuffer(decodedBlockNode, bufferAllocator, isNested);
        }
        throw new IllegalArgumentException("Unsupported encoding: " + decodedBlock.getClass().getSimpleName());
    }

    @Override
    public void setupDecodedBlocksAndPositions(DecodedBlockNode decodedBlockNode, int[] positions, int positionCount, int partitionBufferCapacity, long estimatedSerializedPageSize) {
        Objects.requireNonNull(decodedBlockNode, "decodedBlockNode is null");
        Objects.requireNonNull(positions, "positions is null");
        this.positions = positions;
        this.positionCount = positionCount;
        this.positionsOffset = 0;
        this.positionsMapped = false;
        double decodedBlockPageSizeFraction = (double)(decodedBlockNode.getEstimatedSerializedSizeInBytes() - decodedBlockNode.getChildrenEstimatedSerializedSizeInBytes()) / (double)estimatedSerializedPageSize;
        this.setupDecodedBlockAndMapPositions(decodedBlockNode, partitionBufferCapacity, decodedBlockPageSizeFraction);
    }

    @Override
    public void setNextBatch(int positionsOffset, int batchSize) {
        this.positionsOffset = positionsOffset;
        this.batchSize = batchSize;
        this.flushed = false;
    }

    protected void setEstimatedNullsBufferMaxCapacity(int estimatedNullsBufferMaxCapacity) {
        this.estimatedNullsBufferMaxCapacity = estimatedNullsBufferMaxCapacity;
    }

    protected DecodedBlockNode mapPositionsToNestedBlock(DecodedBlockNode decodedBlockNode) {
        Object decodedObject = decodedBlockNode.getDecodedBlock();
        if (decodedObject instanceof DictionaryBlock) {
            DictionaryBlock dictionaryBlock = (DictionaryBlock)decodedObject;
            this.mappedPositions = Arrays.ensureCapacity((int[])this.mappedPositions, (int)this.positionCount, (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.NONE, (ArrayAllocator)this.bufferAllocator);
            for (int i = 0; i < this.positionCount; ++i) {
                this.mappedPositions[i] = dictionaryBlock.getId(this.positions[i]);
            }
            this.positionsMapped = true;
            return decodedBlockNode.getChildren().get(0);
        }
        if (decodedObject instanceof RunLengthEncodedBlock) {
            this.mappedPositions = Arrays.ensureCapacity((int[])this.mappedPositions, (int)this.positionCount, (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.INITIALIZE, (ArrayAllocator)this.bufferAllocator);
            this.positionsMapped = true;
            return decodedBlockNode.getChildren().get(0);
        }
        this.positionsMapped = false;
        return decodedBlockNode;
    }

    protected void ensurePositionsCapacity(int capacity) {
        this.positions = Arrays.ensureCapacity((int[])this.positions, (int)capacity, (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.NONE, (ArrayAllocator)this.bufferAllocator);
    }

    protected void appendPositionRange(int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.positions[this.positionCount++] = offset + i;
        }
    }

    protected abstract void accumulateSerializedRowSizes(int[] var1, int var2, int[] var3);

    protected void resetPositions() {
        this.positionsOffset = 0;
        this.positionCount = 0;
        this.positionsMapped = false;
    }

    protected int[] getPositions() {
        if (this.positionsMapped) {
            Verify.verify((this.mappedPositions != null ? 1 : 0) != 0);
            return this.mappedPositions;
        }
        return this.positions;
    }

    protected void appendNulls() {
        if (this.decodedBlock.mayHaveNull()) {
            this.nullsBuffer = Arrays.ensureCapacity((byte[])this.nullsBuffer, (int)((this.bufferedPositionCount + this.batchSize) / 8 + 1), (int)this.estimatedNullsBufferMaxCapacity, (Arrays.ExpansionFactor)Arrays.ExpansionFactor.LARGE, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE, (ArrayAllocator)this.bufferAllocator);
            int bufferedNullsCount = this.nullsBufferIndex * 8 + this.remainingNullsCount;
            if (this.bufferedPositionCount > bufferedNullsCount) {
                this.encodeNonNullsAsBits(this.bufferedPositionCount - bufferedNullsCount);
            }
            this.encodeNullsAsBits(this.decodedBlock);
        } else if (this.containsNull()) {
            this.nullsBuffer = Arrays.ensureCapacity((byte[])this.nullsBuffer, (int)((this.bufferedPositionCount + this.batchSize) / 8 + 1), (int)this.estimatedNullsBufferMaxCapacity, (Arrays.ExpansionFactor)Arrays.ExpansionFactor.LARGE, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE, (ArrayAllocator)this.bufferAllocator);
            this.encodeNonNullsAsBits(this.batchSize);
        }
    }

    @Override
    public void noMoreBatches() {
        if (this.isNested && this.positions != null) {
            this.bufferAllocator.returnArray(this.positions);
            this.positions = null;
        }
        if (this.mappedPositions != null) {
            this.bufferAllocator.returnArray(this.mappedPositions);
            this.mappedPositions = null;
        }
        if (this.flushed && this.nullsBuffer != null) {
            this.bufferAllocator.returnArray(this.nullsBuffer);
            this.nullsBuffer = null;
        }
    }

    protected void serializeNullsTo(SliceOutput output) {
        this.encodeRemainingNullsAsBits();
        if (this.hasEncodedNulls) {
            output.writeBoolean(true);
            output.appendBytes(this.nullsBuffer, 0, this.nullsBufferIndex);
        } else {
            output.writeBoolean(false);
        }
    }

    protected static void writeLengthPrefixedString(SliceOutput output, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        output.writeInt(bytes.length);
        output.writeBytes(bytes);
    }

    protected void resetNullsBuffer() {
        this.nullsBufferIndex = 0;
        this.remainingNullsCount = 0;
        this.hasEncodedNulls = false;
    }

    protected long getNullsBufferSerializedSizeInBytes() {
        long size = 1L;
        if (this.containsNull()) {
            size += (long)(this.nullsBufferIndex + (this.remainingNullsCount > 0 ? 1 : 0));
        }
        return size;
    }

    private void encodeNullsAsBits(Block block) {
        int i;
        int[] positions = this.getPositions();
        if (this.remainingNullsCount + this.batchSize < 8) {
            for (int i2 = 0; i2 < this.batchSize; ++i2) {
                this.remainingNulls[this.remainingNullsCount++] = block.isNull(positions[this.positionsOffset + i2]);
            }
            return;
        }
        int offset = this.positionsOffset;
        if (this.remainingNullsCount > 0) {
            int i3;
            byte value = 0;
            for (i3 = 0; i3 < this.remainingNullsCount; ++i3) {
                value = (byte)(value | (this.remainingNulls[i3] ? 128 >>> i3 : 0));
            }
            for (i3 = this.remainingNullsCount; i3 < 8; ++i3) {
                value = (byte)(value | (block.isNull(positions[offset++]) ? 128 >>> i3 : 0));
            }
            this.hasEncodedNulls |= value != 0;
            this.nullsBufferIndex = UncheckedByteArrays.setByteUnchecked(this.nullsBuffer, this.nullsBufferIndex, value);
            this.remainingNullsCount = 0;
        }
        int remainingPositions = this.batchSize - (offset - this.positionsOffset);
        int positionsToEncode = remainingPositions & 0xFFFFFFF8;
        for (i = 0; i < positionsToEncode; i += 8) {
            byte value = 0;
            value = (byte)(value | (block.isNull(positions[offset]) ? 128 : 0));
            value = (byte)(value | (block.isNull(positions[offset + 1]) ? 64 : 0));
            value = (byte)(value | (block.isNull(positions[offset + 2]) ? 32 : 0));
            value = (byte)(value | (block.isNull(positions[offset + 3]) ? 16 : 0));
            value = (byte)(value | (block.isNull(positions[offset + 4]) ? 8 : 0));
            value = (byte)(value | (block.isNull(positions[offset + 5]) ? 4 : 0));
            value = (byte)(value | (block.isNull(positions[offset + 6]) ? 2 : 0));
            value = (byte)(value | (block.isNull(positions[offset + 7]) ? 1 : 0));
            this.hasEncodedNulls |= value != 0;
            this.nullsBufferIndex = UncheckedByteArrays.setByteUnchecked(this.nullsBuffer, this.nullsBufferIndex, value);
            offset += 8;
        }
        this.remainingNullsCount = remainingPositions & 7;
        for (i = 0; i < this.remainingNullsCount; ++i) {
            this.remainingNulls[i] = block.isNull(positions[offset++]);
        }
    }

    private void encodeNonNullsAsBits(int count) {
        if (this.remainingNullsCount + count < 8) {
            for (int i = 0; i < count; ++i) {
                this.remainingNulls[this.remainingNullsCount++] = false;
            }
            return;
        }
        int remainingPositions = count - this.encodeRemainingNullsAsBits();
        this.nullsBufferIndex = MoreByteArrays.fill(this.nullsBuffer, this.nullsBufferIndex, remainingPositions >>> 3, (byte)0);
        this.remainingNullsCount = remainingPositions & 7;
        java.util.Arrays.fill(this.remainingNulls, false);
    }

    private int encodeRemainingNullsAsBits() {
        if (this.remainingNullsCount == 0) {
            return 0;
        }
        byte value = 0;
        for (int i = 0; i < this.remainingNullsCount; ++i) {
            value = (byte)(value | (this.remainingNulls[i] ? 128 >>> i : 0));
        }
        this.hasEncodedNulls |= value != 0;
        this.nullsBufferIndex = UncheckedByteArrays.setByteUnchecked(this.nullsBuffer, this.nullsBufferIndex, value);
        int padding = 8 - this.remainingNullsCount;
        this.remainingNullsCount = 0;
        return padding;
    }

    private boolean containsNull() {
        if (this.hasEncodedNulls) {
            return true;
        }
        for (int i = 0; i < this.remainingNullsCount; ++i) {
            if (!this.remainingNulls[i]) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void checkValidPositions() {
        Verify.verify((this.decodedBlock != null ? 1 : 0) != 0, (String)"decodedBlock should have been set up", (Object[])new Object[0]);
        int positionCount = this.decodedBlock.getPositionCount();
        int[] positions = this.getPositions();
        for (int i = 0; i < this.positionCount; ++i) {
            if (positions[i] >= 0 && positions[i] < positionCount) continue;
            throw new IndexOutOfBoundsException(String.format("Invalid position %d for decodedBlock with %d positions", positions[i], positionCount));
        }
    }
}

