/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.array.ReferenceCountMap;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.DictionaryId;
import com.facebook.presto.common.block.LazyBlock;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.WorkProcessor;
import com.facebook.presto.operator.project.DictionaryAwarePageFilter;
import com.facebook.presto.operator.project.DictionaryAwarePageProjection;
import com.facebook.presto.operator.project.InputPageProjection;
import com.facebook.presto.operator.project.PageFilter;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.PageProjectionWithOutputs;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.sql.gen.ExpressionProfiler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PageProcessor {
    public static final int MAX_BATCH_SIZE = 8192;
    static final int MAX_PAGE_SIZE_IN_BYTES = 0x400000;
    static final int MIN_PAGE_SIZE_IN_BYTES = 0x100000;
    private final ExpressionProfiler expressionProfiler;
    private final DictionarySourceIdFunction dictionarySourceIdFunction = new DictionarySourceIdFunction();
    private final Optional<PageFilter> filter;
    private final List<PageProjectionWithOutputs> projections;
    private final int outputCount;
    private int projectBatchSize;

    @VisibleForTesting
    public PageProcessor(Optional<PageFilter> filter, List<PageProjectionWithOutputs> projections, OptionalInt initialBatchSize) {
        this(filter, projections, initialBatchSize, new ExpressionProfiler());
    }

    @VisibleForTesting
    public PageProcessor(Optional<PageFilter> filter, List<PageProjectionWithOutputs> projections, OptionalInt initialBatchSize, ExpressionProfiler expressionProfiler) {
        List outputChannels = (List)projections.stream().map(PageProjectionWithOutputs::getOutputChannels).map(Arrays::stream).map(IntStream::boxed).flatMap(Function.identity()).distinct().collect(ImmutableList.toImmutableList());
        int outputCount = projections.stream().map(PageProjectionWithOutputs::getOutputCount).reduce(Integer::sum).orElse(0);
        Verify.verify((outputChannels.size() == outputCount && (outputCount == 0 || outputChannels.stream().max(Integer::compareTo).orElse(0) == outputChannels.size() - 1) ? 1 : 0) != 0, (String)String.format("Invalid outputChannels: outputCount: %d, outputChannels: %s", outputCount, outputChannels), (Object[])new Object[0]);
        this.filter = Objects.requireNonNull(filter, "filter is null").map(pageFilter -> {
            if (pageFilter.getInputChannels().size() == 1 && pageFilter.isDeterministic()) {
                return new DictionaryAwarePageFilter((PageFilter)pageFilter);
            }
            return pageFilter;
        });
        this.outputCount = outputCount;
        this.projections = (List)Objects.requireNonNull(projections, "projections is null").stream().map(projectionWithOutputs -> {
            PageProjection projection = projectionWithOutputs.getPageProjection();
            if (projection.getInputChannels().size() == 1 && projection.isDeterministic() && !(projection instanceof InputPageProjection)) {
                return new PageProjectionWithOutputs(new DictionaryAwarePageProjection(projection, this.dictionarySourceIdFunction), projectionWithOutputs.getOutputChannels());
            }
            return projectionWithOutputs;
        }).collect(ImmutableList.toImmutableList());
        this.projectBatchSize = initialBatchSize.orElse(1);
        this.expressionProfiler = Objects.requireNonNull(expressionProfiler, "expressionProfiler is null");
    }

    public PageProcessor(Optional<PageFilter> filter, List<PageProjectionWithOutputs> projections) {
        this(filter, projections, OptionalInt.of(1));
    }

    public Iterator<Optional<Page>> process(SqlFunctionProperties properties, DriverYieldSignal yieldSignal, LocalMemoryContext memoryContext, Page page) {
        WorkProcessor<Page> processor = this.createWorkProcessor(properties, yieldSignal, memoryContext, page);
        return processor.yieldingIterator();
    }

    private WorkProcessor<Page> createWorkProcessor(SqlFunctionProperties properties, DriverYieldSignal yieldSignal, LocalMemoryContext memoryContext, Page page) {
        this.dictionarySourceIdFunction.reset();
        if (page.getPositionCount() == 0) {
            return WorkProcessor.of(new Page[0]);
        }
        if (this.filter.isPresent()) {
            SelectedPositions selectedPositions = this.filter.get().filter(properties, this.filter.get().getInputChannels().getInputChannels(page));
            if (selectedPositions.isEmpty()) {
                return WorkProcessor.of(new Page[0]);
            }
            if (this.projections.isEmpty()) {
                return WorkProcessor.of(new Page(selectedPositions.size(), new Block[0]));
            }
            if (selectedPositions.size() != page.getPositionCount()) {
                return WorkProcessor.create(new ProjectSelectedPositions(properties, yieldSignal, memoryContext, page, selectedPositions));
            }
        }
        return WorkProcessor.create(new ProjectSelectedPositions(properties, yieldSignal, memoryContext, page, SelectedPositions.positionsRange(0, page.getPositionCount())));
    }

    @VisibleForTesting
    public List<PageProjectionWithOutputs> getProjections() {
        return this.projections;
    }

    private static boolean isNotLoadedLazyBlock(Block block) {
        return block instanceof LazyBlock && !((LazyBlock)block).isLoaded();
    }

    private static class ProcessBatchResult {
        private final ProcessBatchState state;
        private final Page page;

        private ProcessBatchResult(ProcessBatchState state, Page page) {
            this.state = state;
            this.page = page;
        }

        public static ProcessBatchResult processBatchYield() {
            return new ProcessBatchResult(ProcessBatchState.YIELD, null);
        }

        public static ProcessBatchResult processBatchTooLarge() {
            return new ProcessBatchResult(ProcessBatchState.PAGE_TOO_LARGE, null);
        }

        public static ProcessBatchResult processBatchSuccess(Page page) {
            return new ProcessBatchResult(ProcessBatchState.SUCCESS, Objects.requireNonNull(page));
        }

        public boolean isYieldFinish() {
            return this.state == ProcessBatchState.YIELD;
        }

        public boolean isPageTooLarge() {
            return this.state == ProcessBatchState.PAGE_TOO_LARGE;
        }

        public boolean isSuccess() {
            return this.state == ProcessBatchState.SUCCESS;
        }

        public Page getPage() {
            Verify.verify((this.page != null ? 1 : 0) != 0);
            Verify.verify((this.state == ProcessBatchState.SUCCESS ? 1 : 0) != 0);
            return this.page;
        }

        private static enum ProcessBatchState {
            YIELD,
            PAGE_TOO_LARGE,
            SUCCESS;

        }
    }

    @NotThreadSafe
    private static class DictionarySourceIdFunction
    implements Function<DictionaryBlock, DictionaryId> {
        private final Map<DictionaryId, DictionaryId> dictionarySourceIds = new HashMap<DictionaryId, DictionaryId>();

        private DictionarySourceIdFunction() {
        }

        @Override
        public DictionaryId apply(DictionaryBlock block) {
            return this.dictionarySourceIds.computeIfAbsent(block.getDictionarySourceId(), ignored -> DictionaryId.randomDictionaryId());
        }

        public void reset() {
            this.dictionarySourceIds.clear();
        }
    }

    private class ProjectSelectedPositions
    implements WorkProcessor.Process<Page> {
        private final SqlFunctionProperties properties;
        private final DriverYieldSignal yieldSignal;
        private final LocalMemoryContext memoryContext;
        private Page page;
        private Block[] previouslyComputedResults;
        private SelectedPositions selectedPositions;
        private long retainedSizeInBytes;
        private boolean lastComputeYielded;
        private int lastComputeBatchSize;
        private Work<List<Block>> pageProjectWork;

        private ProjectSelectedPositions(SqlFunctionProperties properties, DriverYieldSignal yieldSignal, LocalMemoryContext memoryContext, Page page, SelectedPositions selectedPositions) {
            Preconditions.checkArgument((!selectedPositions.isEmpty() ? 1 : 0) != 0, (Object)"selectedPositions is empty");
            this.properties = properties;
            this.yieldSignal = yieldSignal;
            this.page = page;
            this.memoryContext = memoryContext;
            this.selectedPositions = selectedPositions;
            this.previouslyComputedResults = new Block[PageProcessor.this.outputCount];
        }

        @Override
        public WorkProcessor.ProcessState<Page> process() {
            int i;
            ProcessBatchResult result;
            int batchSize;
            while (true) {
                if (this.selectedPositions.isEmpty()) {
                    Verify.verify((!this.lastComputeYielded ? 1 : 0) != 0);
                    return WorkProcessor.ProcessState.finished();
                }
                if (this.lastComputeYielded) {
                    Verify.verify((this.lastComputeBatchSize > 0 ? 1 : 0) != 0);
                    batchSize = this.lastComputeBatchSize;
                    this.lastComputeYielded = false;
                    this.lastComputeBatchSize = 0;
                } else {
                    batchSize = Math.min(this.selectedPositions.size(), PageProcessor.this.projectBatchSize);
                }
                result = this.processBatch(batchSize);
                if (result.isYieldFinish()) {
                    this.lastComputeYielded = true;
                    this.lastComputeBatchSize = batchSize;
                    this.updateRetainedSize();
                    return WorkProcessor.ProcessState.yield();
                }
                if (!result.isPageTooLarge()) break;
                Verify.verify((batchSize > 1 ? 1 : 0) != 0);
                PageProcessor.this.projectBatchSize = PageProcessor.this.projectBatchSize / 2;
            }
            Verify.verify((boolean)result.isSuccess());
            Page resultPage = result.getPage();
            long pageSize = resultPage.getSizeInBytes();
            if (resultPage.getPositionCount() > 1 && (pageSize > 0x400000L || PageProcessor.this.expressionProfiler.isExpressionExpensive())) {
                PageProcessor.this.projectBatchSize = PageProcessor.this.projectBatchSize / 2;
            }
            if (pageSize < 0x100000L && PageProcessor.this.projectBatchSize < 8192 && !PageProcessor.this.expressionProfiler.isExpressionExpensive()) {
                PageProcessor.this.projectBatchSize = PageProcessor.this.projectBatchSize * 2;
            }
            this.selectedPositions = this.selectedPositions.subRange(batchSize, this.selectedPositions.size());
            for (i = 0; i < this.previouslyComputedResults.length; ++i) {
                this.previouslyComputedResults[i] = this.previouslyComputedResults[i] != null && this.previouslyComputedResults[i].getPositionCount() > batchSize ? this.previouslyComputedResults[i].getRegion(batchSize, this.previouslyComputedResults[i].getPositionCount() - batchSize) : null;
            }
            if (!this.selectedPositions.isEmpty()) {
                this.updateRetainedSize();
            } else {
                this.page = null;
                for (i = 0; i < this.previouslyComputedResults.length; ++i) {
                    this.previouslyComputedResults[i] = null;
                }
                this.memoryContext.setBytes(0L);
            }
            return WorkProcessor.ProcessState.ofResult(resultPage);
        }

        private void updateRetainedSize() {
            this.retainedSizeInBytes = (long)Page.INSTANCE_SIZE + SizeOf.sizeOfObjectArray((int)this.page.getChannelCount());
            ReferenceCountMap referenceCountMap = new ReferenceCountMap();
            for (int channel = 0; channel < this.page.getChannelCount(); ++channel) {
                Block block = this.page.getBlock(channel);
                if (PageProcessor.isNotLoadedLazyBlock(block)) continue;
                block.retainedBytesForEachPart((object, size) -> {
                    if (referenceCountMap.incrementAndGet(object) == 1) {
                        this.retainedSizeInBytes += size.longValue();
                    }
                });
            }
            for (Block previouslyComputedResult : this.previouslyComputedResults) {
                if (previouslyComputedResult == null) continue;
                previouslyComputedResult.retainedBytesForEachPart((object, size) -> {
                    if (referenceCountMap.incrementAndGet(object) == 1) {
                        this.retainedSizeInBytes += size.longValue();
                    }
                });
            }
            this.memoryContext.setBytes(this.retainedSizeInBytes);
        }

        private ProcessBatchResult processBatch(int batchSize) {
            Block[] blocks = new Block[PageProcessor.this.outputCount];
            int pageSize = 0;
            SelectedPositions positionsBatch = this.selectedPositions.subRange(0, batchSize);
            for (PageProjectionWithOutputs projection : PageProcessor.this.projections) {
                if (this.yieldSignal.isSet()) {
                    return ProcessBatchResult.processBatchYield();
                }
                if (positionsBatch.size() > 1 && pageSize > 0x400000) {
                    return ProcessBatchResult.processBatchTooLarge();
                }
                int[] outputChannels = projection.getOutputChannels();
                if (this.previouslyComputedResults[outputChannels[0]] != null && this.previouslyComputedResults[outputChannels[0]].getPositionCount() >= batchSize) {
                    for (int channel : outputChannels) {
                        blocks[channel] = this.previouslyComputedResults[channel].getRegion(0, batchSize);
                        pageSize = (int)((long)pageSize + blocks[channel].getSizeInBytes());
                    }
                    continue;
                }
                if (this.pageProjectWork == null) {
                    PageProcessor.this.expressionProfiler.start();
                    this.pageProjectWork = projection.project(this.properties, this.yieldSignal, projection.getPageProjection().getInputChannels().getInputChannels(this.page), positionsBatch);
                    PageProcessor.this.expressionProfiler.stop(positionsBatch.size());
                }
                if (!this.pageProjectWork.process()) {
                    return ProcessBatchResult.processBatchYield();
                }
                List<Block> projectionOutputs = this.pageProjectWork.getResult();
                for (int j = 0; j < outputChannels.length; ++j) {
                    int channel = outputChannels[j];
                    this.previouslyComputedResults[channel] = projectionOutputs.get(j);
                    blocks[channel] = this.previouslyComputedResults[channel];
                    pageSize = (int)((long)pageSize + blocks[channel].getSizeInBytes());
                }
                this.pageProjectWork = null;
            }
            return ProcessBatchResult.processBatchSuccess(new Page(positionsBatch.size(), blocks));
        }
    }
}

