/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.operator.CompletedWork;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.SelectedPositions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class InputPageProjection
implements PageProjection {
    private final InputChannels inputChannels;

    public InputPageProjection(int inputChannel) {
        this.inputChannels = new InputChannels(inputChannel);
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public InputChannels getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public Work<List<Block>> project(SqlFunctionProperties properties, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
        Block block = Objects.requireNonNull(page, "page is null").getBlock(0);
        Objects.requireNonNull(selectedPositions, "selectedPositions is null");
        Block result = selectedPositions.isList() ? block.copyPositions(selectedPositions.getPositions(), selectedPositions.getOffset(), selectedPositions.size()) : (selectedPositions.getOffset() == 0 && selectedPositions.size() == page.getPositionCount() ? block.getLoadedBlock() : block.getRegion(selectedPositions.getOffset(), selectedPositions.size()));
        return new CompletedWork<ImmutableList>(ImmutableList.of((Object)result));
    }
}

