/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.relation.RowExpression;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class GeneratedPageProjection
implements PageProjection {
    private final List<RowExpression> projections;
    private final boolean isDeterministic;
    private final InputChannels inputChannels;
    private final MethodHandle pageProjectionWorkFactory;
    private List<BlockBuilder> blockBuilders;

    public GeneratedPageProjection(List<RowExpression> projections, boolean isDeterministic, InputChannels inputChannels, MethodHandle pageProjectionWorkFactory) {
        this.projections = ImmutableList.copyOf((Collection)Objects.requireNonNull(projections, "projections is null"));
        this.isDeterministic = isDeterministic;
        this.inputChannels = Objects.requireNonNull(inputChannels, "inputChannels is null");
        this.pageProjectionWorkFactory = Objects.requireNonNull(pageProjectionWorkFactory, "pageProjectionWorkFactory is null");
        this.blockBuilders = (List)projections.stream().map(RowExpression::getType).map(type -> type.createBlockBuilder(null, 1)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    @Override
    public InputChannels getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public Work<List<Block>> project(SqlFunctionProperties properties, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
        this.blockBuilders = (List)this.blockBuilders.stream().map(blockBuilder -> blockBuilder.newBlockBuilderLike(null)).collect(ImmutableList.toImmutableList());
        try {
            return this.pageProjectionWorkFactory.invoke(this.blockBuilders, properties, page, selectedPositions);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projections", this.projections).toString();
    }
}

