/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.state.CorrelationState;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;

@AggregationFunction(value="corr")
public class DoubleCorrelationAggregation {
    private DoubleCorrelationAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState CorrelationState state, @SqlType(value="double") double dependentValue, @SqlType(value="double") double independentValue) {
        AggregationUtils.updateCorrelationState(state, independentValue, dependentValue);
    }

    @CombineFunction
    public static void combine(@AggregationState CorrelationState state, @AggregationState CorrelationState otherState) {
        AggregationUtils.mergeCorrelationState(state, otherState);
    }

    @OutputFunction(value="double")
    public static void corr(@AggregationState CorrelationState state, BlockBuilder out) {
        double result = AggregationUtils.getCorrelation(state);
        if (Double.isFinite(result)) {
            DoubleType.DOUBLE.writeDouble(out, result);
        } else {
            out.appendNull();
        }
    }
}

