/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.common.Page;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashCollisionsCounter;
import com.facebook.presto.operator.JoinBridgeManager;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PartitionedLookupSourceFactory;
import com.facebook.presto.operator.SpilledLookupSourceHandle;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spiller.SingleStreamSpiller;
import com.facebook.presto.spiller.SingleStreamSpillerFactory;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class HashBuilderOperator
implements Operator {
    private static final double INDEX_COMPACTION_ON_REVOCATION_TARGET = 0.8;
    private final OperatorContext operatorContext;
    private final LocalMemoryContext localUserMemoryContext;
    private final LocalMemoryContext localRevocableMemoryContext;
    private final PartitionedLookupSourceFactory lookupSourceFactory;
    private final ListenableFuture<?> lookupSourceFactoryDestroyed;
    private final int partitionIndex;
    private final List<Integer> outputChannels;
    private final List<Integer> hashChannels;
    private final OptionalInt preComputedHashChannel;
    private final Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory;
    private final Optional<Integer> sortChannel;
    private final List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories;
    private final PagesIndex index;
    private final boolean spillEnabled;
    private final SingleStreamSpillerFactory singleStreamSpillerFactory;
    private final HashCollisionsCounter hashCollisionsCounter;
    private State state = State.CONSUMING_INPUT;
    private Optional<ListenableFuture<?>> lookupSourceNotNeeded = Optional.empty();
    private final SpilledLookupSourceHandle spilledLookupSourceHandle = new SpilledLookupSourceHandle();
    private Optional<SingleStreamSpiller> spiller = Optional.empty();
    private ListenableFuture<?> spillInProgress = NOT_BLOCKED;
    private Optional<ListenableFuture<List<Page>>> unspillInProgress = Optional.empty();
    @Nullable
    private LookupSourceSupplier lookupSourceSupplier;
    private OptionalLong lookupSourceChecksum = OptionalLong.empty();
    private Optional<Runnable> finishMemoryRevoke = Optional.empty();

    public HashBuilderOperator(OperatorContext operatorContext, PartitionedLookupSourceFactory lookupSourceFactory, int partitionIndex, List<Integer> outputChannels, List<Integer> hashChannels, OptionalInt preComputedHashChannel, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Optional<Integer> sortChannel, List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories, int expectedPositions, PagesIndex.Factory pagesIndexFactory, boolean spillEnabled, SingleStreamSpillerFactory singleStreamSpillerFactory) {
        Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
        this.operatorContext = operatorContext;
        this.partitionIndex = partitionIndex;
        this.filterFunctionFactory = filterFunctionFactory;
        this.sortChannel = sortChannel;
        this.searchFunctionFactories = searchFunctionFactories;
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
        this.localRevocableMemoryContext = operatorContext.localRevocableMemoryContext();
        this.index = pagesIndexFactory.newPagesIndex(lookupSourceFactory.getTypes(), expectedPositions);
        this.lookupSourceFactory = lookupSourceFactory;
        this.lookupSourceFactoryDestroyed = lookupSourceFactory.isDestroyed();
        this.outputChannels = outputChannels;
        this.hashChannels = hashChannels;
        this.preComputedHashChannel = preComputedHashChannel;
        this.hashCollisionsCounter = new HashCollisionsCounter(operatorContext);
        operatorContext.setInfoSupplier(this.hashCollisionsCounter);
        this.spillEnabled = spillEnabled;
        this.singleStreamSpillerFactory = Objects.requireNonNull(singleStreamSpillerFactory, "singleStreamSpillerFactory is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @VisibleForTesting
    public State getState() {
        return this.state;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        switch (this.state) {
            case CONSUMING_INPUT: {
                return NOT_BLOCKED;
            }
            case SPILLING_INPUT: {
                return this.spillInProgress;
            }
            case LOOKUP_SOURCE_BUILT: {
                return this.lookupSourceNotNeeded.orElseThrow(() -> new IllegalStateException("Lookup source built, but disposal future not set"));
            }
            case INPUT_SPILLED: {
                return this.spilledLookupSourceHandle.getUnspillingOrDisposeRequested();
            }
            case INPUT_UNSPILLING: {
                return this.unspillInProgress.orElseThrow(() -> new IllegalStateException("Unspilling in progress, but unspilling future not set"));
            }
            case INPUT_UNSPILLED_AND_BUILT: {
                return this.spilledLookupSourceHandle.getDisposeRequested();
            }
            case CLOSED: {
                return NOT_BLOCKED;
            }
        }
        throw new IllegalStateException("Unhandled state: " + (Object)((Object)this.state));
    }

    @Override
    public boolean needsInput() {
        boolean stateNeedsInput = this.state == State.CONSUMING_INPUT || this.state == State.SPILLING_INPUT && this.spillInProgress.isDone();
        return stateNeedsInput && !this.lookupSourceFactoryDestroyed.isDone();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        if (this.lookupSourceFactoryDestroyed.isDone()) {
            this.close();
            return;
        }
        if (this.state == State.SPILLING_INPUT) {
            this.spillInput(page);
            return;
        }
        Preconditions.checkState((this.state == State.CONSUMING_INPUT ? 1 : 0) != 0);
        this.updateIndex(page);
    }

    private void updateIndex(Page page) {
        this.index.addPage(page);
        if (this.spillEnabled) {
            this.localRevocableMemoryContext.setBytes(this.index.getEstimatedSize().toBytes());
        } else if (!this.localUserMemoryContext.trySetBytes(this.index.getEstimatedSize().toBytes())) {
            this.index.compact();
            this.localUserMemoryContext.setBytes(this.index.getEstimatedSize().toBytes());
        }
        this.operatorContext.recordOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    private void spillInput(Page page) {
        Preconditions.checkState((boolean)this.spillInProgress.isDone(), (Object)"Previous spill still in progress");
        MoreFutures.checkSuccess(this.spillInProgress, (String)"spilling failed");
        this.spillInProgress = this.getSpiller().spill(page);
    }

    @Override
    public ListenableFuture<?> startMemoryRevoke() {
        Preconditions.checkState((boolean)this.spillEnabled, (Object)"Spill not enabled, no revokable memory should be reserved");
        if (this.state == State.CONSUMING_INPUT) {
            long indexSizeBeforeCompaction = this.index.getEstimatedSize().toBytes();
            this.index.compact();
            long indexSizeAfterCompaction = this.index.getEstimatedSize().toBytes();
            if ((double)indexSizeAfterCompaction < (double)indexSizeBeforeCompaction * 0.8) {
                this.finishMemoryRevoke = Optional.of(() -> {});
                return Futures.immediateFuture(null);
            }
            this.finishMemoryRevoke = Optional.of(() -> {
                this.index.clear();
                this.localUserMemoryContext.setBytes(this.index.getEstimatedSize().toBytes());
                this.localRevocableMemoryContext.setBytes(0L);
                this.lookupSourceFactory.setPartitionSpilledLookupSourceHandle(this.partitionIndex, this.spilledLookupSourceHandle);
                this.state = State.SPILLING_INPUT;
            });
            return this.spillIndex();
        }
        if (this.state == State.LOOKUP_SOURCE_BUILT) {
            this.finishMemoryRevoke = Optional.of(() -> {
                this.lookupSourceFactory.setPartitionSpilledLookupSourceHandle(this.partitionIndex, this.spilledLookupSourceHandle);
                this.lookupSourceNotNeeded = Optional.empty();
                this.index.clear();
                this.localUserMemoryContext.setBytes(this.index.getEstimatedSize().toBytes());
                this.localRevocableMemoryContext.setBytes(0L);
                this.lookupSourceChecksum = OptionalLong.of(this.lookupSourceSupplier.checksum());
                this.lookupSourceSupplier = null;
                this.state = State.INPUT_SPILLED;
            });
            return this.spillIndex();
        }
        if (this.operatorContext.getReservedRevocableBytes() == 0L) {
            this.finishMemoryRevoke = Optional.of(() -> {});
            return Futures.immediateFuture(null);
        }
        throw new IllegalStateException(String.format("State %s can not have revocable memory, but has %s revocable bytes", new Object[]{this.state, this.operatorContext.getReservedRevocableBytes()}));
    }

    private ListenableFuture<?> spillIndex() {
        Preconditions.checkState((!this.spiller.isPresent() ? 1 : 0) != 0, (Object)"Spiller already created");
        this.spiller = Optional.of(this.singleStreamSpillerFactory.create(this.index.getTypes(), this.operatorContext.getSpillContext().newLocalSpillContext(), this.operatorContext.newLocalSystemMemoryContext(HashBuilderOperator.class.getSimpleName())));
        return this.getSpiller().spill(this.index.getPages());
    }

    @Override
    public void finishMemoryRevoke() {
        Preconditions.checkState((boolean)this.finishMemoryRevoke.isPresent(), (Object)"Cannot finish unknown revoking");
        this.finishMemoryRevoke.get().run();
        this.finishMemoryRevoke = Optional.empty();
    }

    @Override
    public Page getOutput() {
        return null;
    }

    @Override
    public void finish() {
        if (this.lookupSourceFactoryDestroyed.isDone()) {
            this.close();
            return;
        }
        if (this.finishMemoryRevoke.isPresent()) {
            return;
        }
        switch (this.state) {
            case CONSUMING_INPUT: {
                this.finishInput();
                return;
            }
            case LOOKUP_SOURCE_BUILT: {
                this.disposeLookupSourceIfRequested();
                return;
            }
            case SPILLING_INPUT: {
                this.finishSpilledInput();
                return;
            }
            case INPUT_SPILLED: {
                if (this.spilledLookupSourceHandle.getDisposeRequested().isDone()) {
                    this.close();
                } else {
                    this.unspillLookupSourceIfRequested();
                }
                return;
            }
            case INPUT_UNSPILLING: {
                this.finishLookupSourceUnspilling();
                return;
            }
            case INPUT_UNSPILLED_AND_BUILT: {
                this.disposeUnspilledLookupSourceIfRequested();
                return;
            }
            case CLOSED: {
                return;
            }
        }
        throw new IllegalStateException("Unhandled state: " + (Object)((Object)this.state));
    }

    private void finishInput() {
        Preconditions.checkState((this.state == State.CONSUMING_INPUT ? 1 : 0) != 0);
        if (this.lookupSourceFactoryDestroyed.isDone()) {
            this.close();
            return;
        }
        LookupSourceSupplier partition = this.buildLookupSource();
        if (this.spillEnabled) {
            this.localRevocableMemoryContext.setBytes(((LookupSource)partition.get()).getInMemorySizeInBytes());
        } else {
            this.localUserMemoryContext.setBytes(((LookupSource)partition.get()).getInMemorySizeInBytes());
        }
        this.lookupSourceNotNeeded = Optional.of(this.lookupSourceFactory.lendPartitionLookupSource(this.partitionIndex, partition));
        this.state = State.LOOKUP_SOURCE_BUILT;
    }

    private void disposeLookupSourceIfRequested() {
        Preconditions.checkState((this.state == State.LOOKUP_SOURCE_BUILT ? 1 : 0) != 0);
        Verify.verify((boolean)this.lookupSourceNotNeeded.isPresent());
        if (!this.lookupSourceNotNeeded.get().isDone()) {
            return;
        }
        this.index.clear();
        this.localRevocableMemoryContext.setBytes(0L);
        this.localUserMemoryContext.setBytes(this.index.getEstimatedSize().toBytes());
        this.lookupSourceSupplier = null;
        this.close();
    }

    private void finishSpilledInput() {
        Preconditions.checkState((this.state == State.SPILLING_INPUT ? 1 : 0) != 0);
        if (!this.spillInProgress.isDone()) {
            return;
        }
        MoreFutures.checkSuccess(this.spillInProgress, (String)"spilling failed");
        this.state = State.INPUT_SPILLED;
    }

    private void unspillLookupSourceIfRequested() {
        Preconditions.checkState((this.state == State.INPUT_SPILLED ? 1 : 0) != 0);
        if (!this.spilledLookupSourceHandle.getUnspillingRequested().isDone()) {
            return;
        }
        Verify.verify((boolean)this.spiller.isPresent());
        Verify.verify((!this.unspillInProgress.isPresent() ? 1 : 0) != 0);
        this.localUserMemoryContext.setBytes(this.getSpiller().getSpilledPagesInMemorySize() + this.index.getEstimatedSize().toBytes());
        this.unspillInProgress = Optional.of(this.getSpiller().getAllSpilledPages());
        this.state = State.INPUT_UNSPILLING;
    }

    private void finishLookupSourceUnspilling() {
        Preconditions.checkState((this.state == State.INPUT_UNSPILLING ? 1 : 0) != 0);
        if (!this.unspillInProgress.get().isDone()) {
            return;
        }
        ArrayDeque pages = new ArrayDeque((Collection)MoreFutures.getDone((Future)((Future)this.unspillInProgress.get())));
        long memoryRetainedByRemainingPages = pages.stream().mapToLong(Page::getRetainedSizeInBytes).sum();
        this.localUserMemoryContext.setBytes(memoryRetainedByRemainingPages + this.index.getEstimatedSize().toBytes());
        while (!pages.isEmpty()) {
            Page next = (Page)pages.remove();
            this.index.addPage(next);
            this.localUserMemoryContext.setBytes((memoryRetainedByRemainingPages -= next.getRetainedSizeInBytes()) + this.index.getEstimatedSize().toBytes());
        }
        LookupSourceSupplier partition = this.buildLookupSource();
        this.lookupSourceChecksum.ifPresent(checksum -> Preconditions.checkState((partition.checksum() == checksum ? 1 : 0) != 0, (Object)"Unspilled lookupSource checksum does not match original one"));
        this.localUserMemoryContext.setBytes(((LookupSource)partition.get()).getInMemorySizeInBytes());
        this.spilledLookupSourceHandle.setLookupSource(partition);
        this.state = State.INPUT_UNSPILLED_AND_BUILT;
    }

    private void disposeUnspilledLookupSourceIfRequested() {
        Preconditions.checkState((this.state == State.INPUT_UNSPILLED_AND_BUILT ? 1 : 0) != 0);
        if (!this.spilledLookupSourceHandle.getDisposeRequested().isDone()) {
            return;
        }
        this.index.clear();
        this.localUserMemoryContext.setBytes(this.index.getEstimatedSize().toBytes());
        this.close();
    }

    private LookupSourceSupplier buildLookupSource() {
        LookupSourceSupplier partition = this.index.createLookupSourceSupplier(this.operatorContext.getSession(), this.hashChannels, this.preComputedHashChannel, this.filterFunctionFactory, this.sortChannel, this.searchFunctionFactories, Optional.of(this.outputChannels));
        this.hashCollisionsCounter.recordHashCollision(partition.getHashCollisions(), partition.getExpectedHashCollisions());
        Preconditions.checkState((this.lookupSourceSupplier == null ? 1 : 0) != 0, (Object)"lookupSourceSupplier is already set");
        this.lookupSourceSupplier = partition;
        return partition;
    }

    @Override
    public boolean isFinished() {
        if (this.lookupSourceFactoryDestroyed.isDone()) {
            this.close();
            return true;
        }
        return this.state == State.CLOSED;
    }

    private SingleStreamSpiller getSpiller() {
        return this.spiller.orElseThrow(() -> new IllegalStateException("Spiller not created"));
    }

    @Override
    public void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        this.lookupSourceSupplier = null;
        this.state = State.CLOSED;
        this.finishMemoryRevoke = this.finishMemoryRevoke.map(ifPresent -> () -> {});
        try (Closer closer = Closer.create();){
            closer.register(this.index::clear);
            this.spiller.ifPresent(arg_0 -> ((Closer)closer).register(arg_0));
            closer.register(() -> this.localUserMemoryContext.setBytes(0L));
            closer.register(() -> this.localRevocableMemoryContext.setBytes(0L));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public static enum State {
        CONSUMING_INPUT,
        SPILLING_INPUT,
        LOOKUP_SOURCE_BUILT,
        INPUT_SPILLED,
        INPUT_UNSPILLING,
        INPUT_UNSPILLED_AND_BUILT,
        CLOSED;

    }

    public static class HashBuilderOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager;
        private final List<Integer> outputChannels;
        private final List<Integer> hashChannels;
        private final OptionalInt preComputedHashChannel;
        private final Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory;
        private final Optional<Integer> sortChannel;
        private final List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories;
        private final PagesIndex.Factory pagesIndexFactory;
        private final int expectedPositions;
        private final boolean spillEnabled;
        private final SingleStreamSpillerFactory singleStreamSpillerFactory;
        private final Map<Lifespan, Integer> partitionIndexManager = new HashMap<Lifespan, Integer>();
        private boolean closed;

        public HashBuilderOperatorFactory(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager, List<Integer> outputChannels, List<Integer> hashChannels, OptionalInt preComputedHashChannel, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Optional<Integer> sortChannel, List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories, int expectedPositions, PagesIndex.Factory pagesIndexFactory, boolean spillEnabled, SingleStreamSpillerFactory singleStreamSpillerFactory) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            Objects.requireNonNull(sortChannel, "sortChannel can not be null");
            Objects.requireNonNull(searchFunctionFactories, "searchFunctionFactories is null");
            Preconditions.checkArgument((sortChannel.isPresent() != searchFunctionFactories.isEmpty() ? 1 : 0) != 0, (Object)"both or none sortChannel and searchFunctionFactories must be set");
            this.lookupSourceFactoryManager = Objects.requireNonNull(lookupSourceFactoryManager, "lookupSourceFactoryManager is null");
            this.outputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
            this.hashChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashChannels, "hashChannels is null"));
            this.preComputedHashChannel = Objects.requireNonNull(preComputedHashChannel, "preComputedHashChannel is null");
            this.filterFunctionFactory = Objects.requireNonNull(filterFunctionFactory, "filterFunctionFactory is null");
            this.sortChannel = sortChannel;
            this.searchFunctionFactories = ImmutableList.copyOf(searchFunctionFactories);
            this.pagesIndexFactory = Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
            this.spillEnabled = spillEnabled;
            this.singleStreamSpillerFactory = Objects.requireNonNull(singleStreamSpillerFactory, "singleStreamSpillerFactory is null");
            this.expectedPositions = expectedPositions;
        }

        @Override
        public HashBuilderOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, HashBuilderOperator.class.getSimpleName());
            PartitionedLookupSourceFactory lookupSourceFactory = this.lookupSourceFactoryManager.getJoinBridge(driverContext.getLifespan());
            int partitionIndex = this.getAndIncrementPartitionIndex(driverContext.getLifespan());
            Verify.verify((partitionIndex < lookupSourceFactory.partitions() ? 1 : 0) != 0);
            return new HashBuilderOperator(operatorContext, lookupSourceFactory, partitionIndex, this.outputChannels, this.hashChannels, this.preComputedHashChannel, this.filterFunctionFactory, this.sortChannel, this.searchFunctionFactories, this.expectedPositions, this.pagesIndexFactory, this.spillEnabled, this.singleStreamSpillerFactory);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException("Parallel hash build can not be duplicated");
        }

        private int getAndIncrementPartitionIndex(Lifespan lifespan) {
            return this.partitionIndexManager.compute(lifespan, (k, v) -> v == null ? 1 : v + 1) - 1;
        }
    }
}

