/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.StageExecutionState;
import com.facebook.presto.execution.StageExecutionStats;
import com.facebook.presto.execution.TaskInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class StageExecutionInfo {
    private final StageExecutionState state;
    private final StageExecutionStats stats;
    private final List<TaskInfo> tasks;
    private final Optional<ExecutionFailureInfo> failureCause;

    @JsonCreator
    public StageExecutionInfo(@JsonProperty(value="state") StageExecutionState state, @JsonProperty(value="stats") StageExecutionStats stats, @JsonProperty(value="tasks") List<TaskInfo> tasks, @JsonProperty(value="failureCause") Optional<ExecutionFailureInfo> failureCause) {
        this.state = Objects.requireNonNull(state, "state is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.tasks = ImmutableList.copyOf((Collection)Objects.requireNonNull(tasks, "tasks is null"));
        this.failureCause = Objects.requireNonNull(failureCause, "failureCause is null");
    }

    @JsonProperty
    public StageExecutionState getState() {
        return this.state;
    }

    @JsonProperty
    public StageExecutionStats getStats() {
        return this.stats;
    }

    @JsonProperty
    public List<TaskInfo> getTasks() {
        return this.tasks;
    }

    @JsonProperty
    public Optional<ExecutionFailureInfo> getFailureCause() {
        return this.failureCause;
    }

    public boolean isFinal() {
        return this.state.isDone() && this.tasks.stream().allMatch(taskInfo -> taskInfo.getTaskStatus().getState().isDone());
    }

    public static StageExecutionInfo unscheduledExecutionInfo(int stageId, boolean isQueryDone) {
        return new StageExecutionInfo(isQueryDone ? StageExecutionState.ABORTED : StageExecutionState.PLANNED, StageExecutionStats.zero(stageId), (List<TaskInfo>)ImmutableList.of(), Optional.empty());
    }
}

