/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.SetThreadName;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.presto.Session;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.SqlTaskExecution;
import com.facebook.presto.execution.SqlTaskExecutionFactory;
import com.facebook.presto.execution.SqlTaskIoStats;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.LazyOutputBuffer;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.PipelineStatus;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskExchangeClientManager;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.util.Failures;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class SqlTask {
    private static final Logger log = Logger.get(SqlTask.class);
    private final TaskId taskId;
    private final String taskInstanceId;
    private final URI location;
    private final String nodeId;
    private final TaskStateMachine taskStateMachine;
    private final OutputBuffer outputBuffer;
    private final QueryContext queryContext;
    private final SqlTaskExecutionFactory sqlTaskExecutionFactory;
    private final TaskExchangeClientManager taskExchangeClientManager;
    private final AtomicReference<DateTime> lastHeartbeat = new AtomicReference<DateTime>(DateTime.now());
    private final AtomicLong nextTaskInfoVersion = new AtomicLong(1L);
    private final AtomicReference<TaskHolder> taskHolderReference = new AtomicReference<TaskHolder>(new TaskHolder());
    private final AtomicBoolean needsPlan = new AtomicBoolean(true);

    public static SqlTask createSqlTask(TaskId taskId, URI location, String nodeId, QueryContext queryContext, SqlTaskExecutionFactory sqlTaskExecutionFactory, ExchangeClientSupplier exchangeClientSupplier, ExecutorService taskNotificationExecutor, Function<SqlTask, ?> onDone, DataSize maxBufferSize, CounterStat failedTasks) {
        SqlTask sqlTask = new SqlTask(taskId, location, nodeId, queryContext, sqlTaskExecutionFactory, exchangeClientSupplier, taskNotificationExecutor, maxBufferSize);
        sqlTask.initialize(onDone, failedTasks);
        return sqlTask;
    }

    private SqlTask(TaskId taskId, URI location, String nodeId, QueryContext queryContext, SqlTaskExecutionFactory sqlTaskExecutionFactory, ExchangeClientSupplier exchangeClientSupplier, ExecutorService taskNotificationExecutor, DataSize maxBufferSize) {
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.taskInstanceId = UUID.randomUUID().toString();
        this.location = Objects.requireNonNull(location, "location is null");
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
        this.queryContext = Objects.requireNonNull(queryContext, "queryContext is null");
        this.sqlTaskExecutionFactory = Objects.requireNonNull(sqlTaskExecutionFactory, "sqlTaskExecutionFactory is null");
        Objects.requireNonNull(exchangeClientSupplier, "exchangeClientSupplier is null");
        Objects.requireNonNull(taskNotificationExecutor, "taskNotificationExecutor is null");
        Objects.requireNonNull(maxBufferSize, "maxBufferSize is null");
        this.taskExchangeClientManager = new TaskExchangeClientManager(exchangeClientSupplier);
        this.outputBuffer = new LazyOutputBuffer(taskId, this.taskInstanceId, taskNotificationExecutor, maxBufferSize, () -> queryContext.getTaskContextByTaskId(taskId).localSystemMemoryContext());
        this.taskStateMachine = new TaskStateMachine(taskId, taskNotificationExecutor);
    }

    private void initialize(final Function<SqlTask, ?> onDone, final CounterStat failedTasks) {
        Objects.requireNonNull(onDone, "onDone is null");
        Objects.requireNonNull(failedTasks, "failedTasks is null");
        this.taskStateMachine.addStateChangeListener(new StateMachine.StateChangeListener<TaskState>(){

            @Override
            public void stateChanged(TaskState newState) {
                TaskHolder taskHolder;
                if (!newState.isDone()) {
                    return;
                }
                if (newState == TaskState.FAILED) {
                    failedTasks.update(1L);
                }
                do {
                    if (!(taskHolder = (TaskHolder)SqlTask.this.taskHolderReference.get()).isFinished()) continue;
                    return;
                } while (!SqlTask.this.taskHolderReference.compareAndSet(taskHolder, new TaskHolder(SqlTask.this.createTaskInfo(taskHolder), taskHolder.getIoStats())));
                if (newState == TaskState.FAILED || newState == TaskState.ABORTED) {
                    SqlTask.this.outputBuffer.fail();
                } else {
                    SqlTask.this.outputBuffer.destroy();
                }
                try {
                    onDone.apply((Object)SqlTask.this);
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "Error running task cleanup callback %s", new Object[]{SqlTask.this.taskId});
                }
            }
        });
    }

    public boolean isOutputBufferOverutilized() {
        return this.outputBuffer.isOverutilized();
    }

    public SqlTaskIoStats getIoStats() {
        return this.taskHolderReference.get().getIoStats();
    }

    public TaskId getTaskId() {
        return this.taskStateMachine.getTaskId();
    }

    public String getTaskInstanceId() {
        return this.taskInstanceId;
    }

    public void recordHeartbeat() {
        this.lastHeartbeat.set(DateTime.now());
    }

    public TaskInfo getTaskInfo() {
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            TaskInfo taskInfo = this.createTaskInfo(this.taskHolderReference.get());
            return taskInfo;
        }
    }

    public TaskStatus getTaskStatus() {
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            TaskStatus taskStatus = this.createTaskStatus(this.taskHolderReference.get());
            return taskStatus;
        }
    }

    private TaskStatus createTaskStatus(TaskHolder taskHolder) {
        long versionNumber = this.nextTaskInfoVersion.getAndIncrement();
        TaskState state = this.taskStateMachine.getState();
        Object failures = ImmutableList.of();
        if (state == TaskState.FAILED) {
            failures = Failures.toFailures(this.taskStateMachine.getFailureCauses());
        }
        int queuedPartitionedDrivers = 0;
        int runningPartitionedDrivers = 0;
        DataSize physicalWrittenDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
        DataSize userMemoryReservation = new DataSize(0.0, DataSize.Unit.BYTE);
        DataSize systemMemoryReservation = new DataSize(0.0, DataSize.Unit.BYTE);
        Object completedDriverGroups = ImmutableSet.of();
        long fullGcCount = 0L;
        Duration fullGcTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        if (taskHolder.getFinalTaskInfo() != null) {
            TaskStats taskStats = taskHolder.getFinalTaskInfo().getStats();
            queuedPartitionedDrivers = taskStats.getQueuedPartitionedDrivers();
            runningPartitionedDrivers = taskStats.getRunningPartitionedDrivers();
            physicalWrittenDataSize = taskStats.getPhysicalWrittenDataSize();
            userMemoryReservation = taskStats.getUserMemoryReservation();
            systemMemoryReservation = taskStats.getSystemMemoryReservation();
            fullGcCount = taskStats.getFullGcCount();
            fullGcTime = taskStats.getFullGcTime();
        } else if (taskHolder.getTaskExecution() != null) {
            long physicalWrittenBytes = 0L;
            TaskContext taskContext = taskHolder.getTaskExecution().getTaskContext();
            for (PipelineContext pipelineContext : taskContext.getPipelineContexts()) {
                PipelineStatus pipelineStatus = pipelineContext.getPipelineStatus();
                queuedPartitionedDrivers += pipelineStatus.getQueuedPartitionedDrivers();
                runningPartitionedDrivers += pipelineStatus.getRunningPartitionedDrivers();
                physicalWrittenBytes += pipelineContext.getPhysicalWrittenDataSize();
            }
            physicalWrittenDataSize = DataSize.succinctBytes((long)physicalWrittenBytes);
            userMemoryReservation = taskContext.getMemoryReservation();
            systemMemoryReservation = taskContext.getSystemMemoryReservation();
            completedDriverGroups = taskContext.getCompletedDriverGroups();
            fullGcCount = taskContext.getFullGcCount();
            fullGcTime = taskContext.getFullGcTime();
        }
        return new TaskStatus(this.taskStateMachine.getTaskId(), this.taskInstanceId, versionNumber, state, this.location, this.nodeId, (Set<Lifespan>)completedDriverGroups, (List<ExecutionFailureInfo>)failures, queuedPartitionedDrivers, runningPartitionedDrivers, this.outputBuffer.getUtilization(), this.isOutputBufferOverutilized(), physicalWrittenDataSize, userMemoryReservation, systemMemoryReservation, fullGcCount, fullGcTime);
    }

    private TaskStats getTaskStats(TaskHolder taskHolder) {
        TaskInfo finalTaskInfo = taskHolder.getFinalTaskInfo();
        if (finalTaskInfo != null) {
            return finalTaskInfo.getStats();
        }
        SqlTaskExecution taskExecution = taskHolder.getTaskExecution();
        if (taskExecution != null) {
            return taskExecution.getTaskContext().getTaskStats();
        }
        DateTime endTime = this.taskStateMachine.getState().isDone() ? DateTime.now() : null;
        return new TaskStats(this.taskStateMachine.getCreatedTime(), endTime);
    }

    private static Set<PlanNodeId> getNoMoreSplits(TaskHolder taskHolder) {
        TaskInfo finalTaskInfo = taskHolder.getFinalTaskInfo();
        if (finalTaskInfo != null) {
            return finalTaskInfo.getNoMoreSplits();
        }
        SqlTaskExecution taskExecution = taskHolder.getTaskExecution();
        if (taskExecution != null) {
            return taskExecution.getNoMoreSplits();
        }
        return ImmutableSet.of();
    }

    private TaskInfo createTaskInfo(TaskHolder taskHolder) {
        TaskStats taskStats = this.getTaskStats(taskHolder);
        Set<PlanNodeId> noMoreSplits = SqlTask.getNoMoreSplits(taskHolder);
        TaskStatus taskStatus = this.createTaskStatus(taskHolder);
        return new TaskInfo(taskStatus, this.lastHeartbeat.get(), this.outputBuffer.getInfo(), noMoreSplits, taskStats, this.needsPlan.get());
    }

    public ListenableFuture<TaskStatus> getTaskStatus(TaskState callersCurrentState) {
        Objects.requireNonNull(callersCurrentState, "callersCurrentState is null");
        if (callersCurrentState.isDone()) {
            return Futures.immediateFuture((Object)this.getTaskStatus());
        }
        ListenableFuture<TaskState> futureTaskState = this.taskStateMachine.getStateChange(callersCurrentState);
        return Futures.transform(futureTaskState, input -> this.getTaskStatus(), (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<TaskInfo> getTaskInfo(TaskState callersCurrentState) {
        Objects.requireNonNull(callersCurrentState, "callersCurrentState is null");
        if (callersCurrentState.isDone()) {
            return Futures.immediateFuture((Object)this.getTaskInfo());
        }
        ListenableFuture<TaskState> futureTaskState = this.taskStateMachine.getStateChange(callersCurrentState);
        return Futures.transform(futureTaskState, input -> this.getTaskInfo(), (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInfo updateTask(Session session, Optional<PlanFragment> fragment, List<TaskSource> sources, OutputBuffers outputBuffers, Optional<TableWriteInfo> tableWriteInfo) {
        try {
            SqlTaskExecution taskExecution;
            this.outputBuffer.setOutputBuffers(outputBuffers);
            SqlTask sqlTask = this;
            synchronized (sqlTask) {
                TaskHolder taskHolder = this.taskHolderReference.get();
                if (taskHolder.isFinished()) {
                    return taskHolder.getFinalTaskInfo();
                }
                taskExecution = taskHolder.getTaskExecution();
                if (taskExecution == null) {
                    Preconditions.checkState((boolean)fragment.isPresent(), (Object)"fragment must be present");
                    Preconditions.checkState((boolean)tableWriteInfo.isPresent(), (Object)"tableWriteInfo must be present");
                    taskExecution = this.sqlTaskExecutionFactory.create(session, this.queryContext, this.taskStateMachine, this.outputBuffer, this.taskExchangeClientManager, fragment.get(), sources, tableWriteInfo.get());
                    this.taskHolderReference.compareAndSet(taskHolder, new TaskHolder(taskExecution));
                    this.needsPlan.set(false);
                }
            }
            if (taskExecution != null) {
                taskExecution.addSources(sources);
            }
        }
        catch (Error e) {
            this.failed(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.failed(e);
        }
        return this.getTaskInfo();
    }

    public ListenableFuture<BufferResult> getTaskResults(OutputBuffers.OutputBufferId bufferId, long startingSequenceId, DataSize maxSize) {
        Objects.requireNonNull(bufferId, "bufferId is null");
        Preconditions.checkArgument((maxSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxSize must be at least 1 byte");
        return this.outputBuffer.get(bufferId, startingSequenceId, maxSize);
    }

    public void acknowledgeTaskResults(OutputBuffers.OutputBufferId bufferId, long sequenceId) {
        Objects.requireNonNull(bufferId, "bufferId is null");
        this.outputBuffer.acknowledge(bufferId, sequenceId);
    }

    public TaskInfo abortTaskResults(OutputBuffers.OutputBufferId bufferId) {
        Objects.requireNonNull(bufferId, "bufferId is null");
        log.debug("Aborting task %s output %s", new Object[]{this.taskId, bufferId});
        this.outputBuffer.abort(bufferId);
        return this.getTaskInfo();
    }

    public void removeRemoteSource(TaskId sourceTaskId) {
        Objects.requireNonNull(sourceTaskId, "sourceTaskId is null");
        log.debug("Removing remote source %s from task %s", new Object[]{sourceTaskId, this.taskId});
        this.taskExchangeClientManager.getExchangeClients().forEach(exchangeClient -> exchangeClient.removeRemoteSource(sourceTaskId));
    }

    public void failed(Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.taskStateMachine.failed(cause);
    }

    public TaskInfo cancel() {
        this.taskStateMachine.cancel();
        return this.getTaskInfo();
    }

    public TaskInfo abort() {
        this.taskStateMachine.abort();
        return this.getTaskInfo();
    }

    public String toString() {
        return this.taskId.toString();
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<TaskState> stateChangeListener) {
        this.taskStateMachine.addStateChangeListener(stateChangeListener);
    }

    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    private static final class TaskHolder {
        private final SqlTaskExecution taskExecution;
        private final TaskInfo finalTaskInfo;
        private final SqlTaskIoStats finalIoStats;

        private TaskHolder() {
            this.taskExecution = null;
            this.finalTaskInfo = null;
            this.finalIoStats = null;
        }

        private TaskHolder(SqlTaskExecution taskExecution) {
            this.taskExecution = Objects.requireNonNull(taskExecution, "taskExecution is null");
            this.finalTaskInfo = null;
            this.finalIoStats = null;
        }

        private TaskHolder(TaskInfo finalTaskInfo, SqlTaskIoStats finalIoStats) {
            this.taskExecution = null;
            this.finalTaskInfo = Objects.requireNonNull(finalTaskInfo, "finalTaskInfo is null");
            this.finalIoStats = Objects.requireNonNull(finalIoStats, "finalIoStats is null");
        }

        public boolean isFinished() {
            return this.finalTaskInfo != null;
        }

        @Nullable
        public SqlTaskExecution getTaskExecution() {
            return this.taskExecution;
        }

        @Nullable
        public TaskInfo getFinalTaskInfo() {
            return this.finalTaskInfo;
        }

        public SqlTaskIoStats getIoStats() {
            if (this.finalIoStats != null) {
                return this.finalIoStats;
            }
            if (this.taskExecution == null) {
                return new SqlTaskIoStats();
            }
            TaskContext taskContext = this.taskExecution.getTaskContext();
            return new SqlTaskIoStats(taskContext.getInputDataSize(), taskContext.getInputPositions(), taskContext.getOutputDataSize(), taskContext.getOutputPositions());
        }
    }
}

