/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.HyperLogLogType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.P4HyperLogLogType;
import com.facebook.presto.spi.type.ParametricType;
import com.facebook.presto.spi.type.QuantileDigestParametricType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeParameter;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.type.ArrayParametricType;
import com.facebook.presto.type.CharParametricType;
import com.facebook.presto.type.CodePointsType;
import com.facebook.presto.type.ColorType;
import com.facebook.presto.type.DecimalParametricType;
import com.facebook.presto.type.FunctionParametricType;
import com.facebook.presto.type.IntervalDayTimeType;
import com.facebook.presto.type.IntervalYearMonthType;
import com.facebook.presto.type.IpAddressType;
import com.facebook.presto.type.IpPrefixType;
import com.facebook.presto.type.JoniRegexpType;
import com.facebook.presto.type.JsonPathType;
import com.facebook.presto.type.JsonType;
import com.facebook.presto.type.LikePatternType;
import com.facebook.presto.type.MapParametricType;
import com.facebook.presto.type.Re2JRegexpType;
import com.facebook.presto.type.RowParametricType;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.type.VarcharParametricType;
import com.facebook.presto.type.setdigest.SetDigestType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public final class TypeRegistry
implements TypeManager {
    private final ConcurrentMap<TypeSignature, Type> types = new ConcurrentHashMap<TypeSignature, Type>();
    private final ConcurrentMap<String, ParametricType> parametricTypes = new ConcurrentHashMap<String, ParametricType>();
    private final FeaturesConfig featuresConfig;
    private FunctionManager functionManager;
    private final LoadingCache<TypeSignature, Type> parametricTypeCache;

    @VisibleForTesting
    public TypeRegistry() {
        this((Set<Type>)ImmutableSet.of(), new FeaturesConfig());
    }

    @Inject
    public TypeRegistry(Set<Type> types, FeaturesConfig featuresConfig) {
        Objects.requireNonNull(types, "types is null");
        this.featuresConfig = Objects.requireNonNull(featuresConfig, "featuresConfig is null");
        this.types.put(UnknownType.UNKNOWN.getTypeSignature(), (Type)UnknownType.UNKNOWN);
        this.addType((Type)BooleanType.BOOLEAN);
        this.addType((Type)BigintType.BIGINT);
        this.addType((Type)IntegerType.INTEGER);
        this.addType((Type)SmallintType.SMALLINT);
        this.addType((Type)TinyintType.TINYINT);
        this.addType((Type)DoubleType.DOUBLE);
        this.addType((Type)RealType.REAL);
        this.addType((Type)VarbinaryType.VARBINARY);
        this.addType((Type)DateType.DATE);
        this.addType((Type)TimeType.TIME);
        this.addType((Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE);
        this.addType((Type)TimestampType.TIMESTAMP);
        this.addType((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        this.addType((Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH);
        this.addType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME);
        this.addType((Type)HyperLogLogType.HYPER_LOG_LOG);
        this.addType((Type)SetDigestType.SET_DIGEST);
        this.addType((Type)P4HyperLogLogType.P4_HYPER_LOG_LOG);
        this.addType((Type)JoniRegexpType.JONI_REGEXP);
        this.addType((Type)Re2JRegexpType.RE2J_REGEXP);
        this.addType((Type)LikePatternType.LIKE_PATTERN);
        this.addType((Type)JsonPathType.JSON_PATH);
        this.addType((Type)ColorType.COLOR);
        this.addType((Type)JsonType.JSON);
        this.addType((Type)CodePointsType.CODE_POINTS);
        this.addType((Type)IpAddressType.IPADDRESS);
        this.addType((Type)IpPrefixType.IPPREFIX);
        this.addParametricType(VarcharParametricType.VARCHAR);
        this.addParametricType(CharParametricType.CHAR);
        this.addParametricType(DecimalParametricType.DECIMAL);
        this.addParametricType(RowParametricType.ROW);
        this.addParametricType(ArrayParametricType.ARRAY);
        this.addParametricType(MapParametricType.MAP);
        this.addParametricType(FunctionParametricType.FUNCTION);
        this.addParametricType((ParametricType)QuantileDigestParametricType.QDIGEST);
        for (Type type : types) {
            this.addType(type);
        }
        this.parametricTypeCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(this::instantiateParametricType));
    }

    public void setFunctionManager(FunctionManager functionManager) {
        Preconditions.checkState((this.functionManager == null ? 1 : 0) != 0, (Object)"TypeRegistry can only be associated with a single FunctionManager");
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
    }

    public Type getType(TypeSignature signature) {
        Type type = (Type)this.types.get(signature);
        if (type == null) {
            try {
                return (Type)this.parametricTypeCache.getUnchecked((Object)signature);
            }
            catch (UncheckedExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
        }
        return type;
    }

    public Type getParameterizedType(String baseTypeName, List<TypeSignatureParameter> typeParameters) {
        return this.getType(new TypeSignature(baseTypeName, typeParameters));
    }

    private Type instantiateParametricType(TypeSignature signature) {
        ArrayList<TypeParameter> parameters = new ArrayList<TypeParameter>();
        for (TypeSignatureParameter parameter : signature.getParameters()) {
            TypeParameter typeParameter = TypeParameter.of((TypeSignatureParameter)parameter, (TypeManager)this);
            parameters.add(typeParameter);
        }
        ParametricType parametricType = (ParametricType)this.parametricTypes.get(signature.getBase().toLowerCase(Locale.ENGLISH));
        if (parametricType == null) {
            throw new IllegalArgumentException("Unknown type " + signature);
        }
        Type instantiatedType = parametricType.createType((TypeManager)this, parameters);
        return instantiatedType;
    }

    public List<Type> getTypes() {
        return ImmutableList.copyOf(this.types.values());
    }

    public boolean isTypeOnlyCoercion(Type source, Type result) {
        String resultTypeBase;
        if (source.equals(result)) {
            return true;
        }
        if (!this.canCoerce(source, result)) {
            return false;
        }
        if (source instanceof VarcharType && result instanceof VarcharType) {
            return true;
        }
        if (source instanceof DecimalType && result instanceof DecimalType) {
            DecimalType sourceDecimal = (DecimalType)source;
            DecimalType resultDecimal = (DecimalType)result;
            boolean sameDecimalSubtype = sourceDecimal.isShort() && resultDecimal.isShort() || !sourceDecimal.isShort() && !resultDecimal.isShort();
            boolean sameScale = sourceDecimal.getScale() == resultDecimal.getScale();
            boolean sourcePrecisionIsLessOrEqualToResultPrecision = sourceDecimal.getPrecision() <= resultDecimal.getPrecision();
            return sameDecimalSubtype && sameScale && sourcePrecisionIsLessOrEqualToResultPrecision;
        }
        String sourceTypeBase = source.getTypeSignature().getBase();
        if (sourceTypeBase.equals(resultTypeBase = result.getTypeSignature().getBase()) && TypeRegistry.isCovariantParametrizedType(source)) {
            List sourceTypeParameters = source.getTypeParameters();
            List resultTypeParameters = result.getTypeParameters();
            Preconditions.checkState((sourceTypeParameters.size() == resultTypeParameters.size() ? 1 : 0) != 0);
            for (int i = 0; i < sourceTypeParameters.size(); ++i) {
                if (this.isTypeOnlyCoercion((Type)sourceTypeParameters.get(i), (Type)resultTypeParameters.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Optional<Type> getCommonSuperType(Type firstType, Type secondType) {
        TypeCompatibility compatibility = this.compatibility(firstType, secondType);
        if (!compatibility.isCompatible()) {
            return Optional.empty();
        }
        return Optional.of(compatibility.getCommonSuperType());
    }

    public boolean canCoerce(Type fromType, Type toType) {
        TypeCompatibility typeCompatibility = this.compatibility(fromType, toType);
        return typeCompatibility.isCoercible();
    }

    private TypeCompatibility compatibility(Type fromType, Type toType) {
        String toTypeBaseName;
        if (fromType.equals(toType)) {
            return TypeCompatibility.compatible(toType, true);
        }
        if (fromType.equals((Object)UnknownType.UNKNOWN)) {
            return TypeCompatibility.compatible(toType, true);
        }
        if (toType.equals((Object)UnknownType.UNKNOWN)) {
            return TypeCompatibility.compatible(fromType, false);
        }
        String fromTypeBaseName = fromType.getTypeSignature().getBase();
        if (fromTypeBaseName.equals(toTypeBaseName = toType.getTypeSignature().getBase())) {
            if (fromTypeBaseName.equals("decimal")) {
                Type commonSuperType = TypeRegistry.getCommonSuperTypeForDecimal((DecimalType)fromType, (DecimalType)toType);
                return TypeCompatibility.compatible(commonSuperType, commonSuperType.equals(toType));
            }
            if (fromTypeBaseName.equals("varchar")) {
                Type commonSuperType = TypeRegistry.getCommonSuperTypeForVarchar((VarcharType)fromType, (VarcharType)toType);
                return TypeCompatibility.compatible(commonSuperType, commonSuperType.equals(toType));
            }
            if (fromTypeBaseName.equals("char") && !this.featuresConfig.isLegacyCharToVarcharCoercion()) {
                Type commonSuperType = TypeRegistry.getCommonSuperTypeForChar((CharType)fromType, (CharType)toType);
                return TypeCompatibility.compatible(commonSuperType, commonSuperType.equals(toType));
            }
            if (fromTypeBaseName.equals("row")) {
                return this.typeCompatibilityForRow((RowType)fromType, (RowType)toType);
            }
            if (TypeRegistry.isCovariantParametrizedType(fromType)) {
                return this.typeCompatibilityForCovariantParametrizedType(fromType, toType);
            }
            return TypeCompatibility.incompatible();
        }
        Optional<Type> coercedType = this.coerceTypeBase(fromType, toType.getTypeSignature().getBase());
        if (coercedType.isPresent()) {
            return this.compatibility(coercedType.get(), toType);
        }
        coercedType = this.coerceTypeBase(toType, fromType.getTypeSignature().getBase());
        if (coercedType.isPresent()) {
            TypeCompatibility typeCompatibility = this.compatibility(fromType, coercedType.get());
            if (!typeCompatibility.isCompatible()) {
                return TypeCompatibility.incompatible();
            }
            return TypeCompatibility.compatible(typeCompatibility.getCommonSuperType(), false);
        }
        return TypeCompatibility.incompatible();
    }

    private static Type getCommonSuperTypeForDecimal(DecimalType firstType, DecimalType secondType) {
        int targetScale = Math.max(firstType.getScale(), secondType.getScale());
        int targetPrecision = Math.max(firstType.getPrecision() - firstType.getScale(), secondType.getPrecision() - secondType.getScale()) + targetScale;
        targetPrecision = Math.min(38, targetPrecision);
        return DecimalType.createDecimalType((int)targetPrecision, (int)targetScale);
    }

    private static Type getCommonSuperTypeForVarchar(VarcharType firstType, VarcharType secondType) {
        if (firstType.isUnbounded() || secondType.isUnbounded()) {
            return VarcharType.createUnboundedVarcharType();
        }
        return VarcharType.createVarcharType((int)Math.max(firstType.getLength(), secondType.getLength()));
    }

    private static Type getCommonSuperTypeForChar(CharType firstType, CharType secondType) {
        return CharType.createCharType((long)Math.max(firstType.getLength(), secondType.getLength()));
    }

    private TypeCompatibility typeCompatibilityForRow(RowType firstType, RowType secondType) {
        List firstFields = firstType.getFields();
        List secondFields = secondType.getFields();
        if (firstFields.size() != secondFields.size()) {
            return TypeCompatibility.incompatible();
        }
        ImmutableList.Builder fields = ImmutableList.builder();
        boolean coercible = true;
        for (int i = 0; i < firstFields.size(); ++i) {
            Optional secondParameterName;
            Type secondFieldType;
            Type firstFieldType = ((RowType.Field)firstFields.get(i)).getType();
            TypeCompatibility typeCompatibility = this.compatibility(firstFieldType, secondFieldType = ((RowType.Field)secondFields.get(i)).getType());
            if (!typeCompatibility.isCompatible()) {
                return TypeCompatibility.incompatible();
            }
            Type commonParameterType = typeCompatibility.getCommonSuperType();
            Optional firstParameterName = ((RowType.Field)firstFields.get(i)).getName();
            Optional commonName = firstParameterName.equals(secondParameterName = ((RowType.Field)secondFields.get(i)).getName()) ? firstParameterName : Optional.empty();
            coercible &= typeCompatibility.isCoercible();
            fields.add((Object)new RowType.Field(commonName, commonParameterType));
        }
        return TypeCompatibility.compatible((Type)RowType.from((List)fields.build()), coercible);
    }

    private TypeCompatibility typeCompatibilityForCovariantParametrizedType(Type fromType, Type toType) {
        Preconditions.checkState((boolean)fromType.getClass().equals(toType.getClass()));
        ImmutableList.Builder commonParameterTypes = ImmutableList.builder();
        List fromTypeParameters = fromType.getTypeParameters();
        List toTypeParameters = toType.getTypeParameters();
        if (fromTypeParameters.size() != toTypeParameters.size()) {
            return TypeCompatibility.incompatible();
        }
        boolean coercible = true;
        for (int i = 0; i < fromTypeParameters.size(); ++i) {
            TypeCompatibility compatibility = this.compatibility((Type)fromTypeParameters.get(i), (Type)toTypeParameters.get(i));
            if (!compatibility.isCompatible()) {
                return TypeCompatibility.incompatible();
            }
            coercible &= compatibility.isCoercible();
            commonParameterTypes.add((Object)TypeSignatureParameter.of((TypeSignature)compatibility.getCommonSuperType().getTypeSignature()));
        }
        String typeBase = fromType.getTypeSignature().getBase();
        return TypeCompatibility.compatible(this.getType(new TypeSignature(typeBase, (List)commonParameterTypes.build())), coercible);
    }

    public void addType(Type type) {
        Objects.requireNonNull(type, "type is null");
        Type existingType = this.types.putIfAbsent(type.getTypeSignature(), type);
        Preconditions.checkState((existingType == null || existingType.equals(type) ? 1 : 0) != 0, (String)"Type %s is already registered", (Object)type);
    }

    public void addParametricType(ParametricType parametricType) {
        String name = parametricType.getName().toLowerCase(Locale.ENGLISH);
        Preconditions.checkArgument((!this.parametricTypes.containsKey(name) ? 1 : 0) != 0, (String)"Parametric type already registered: %s", (Object)name);
        this.parametricTypes.putIfAbsent(name, parametricType);
    }

    public Collection<ParametricType> getParametricTypes() {
        return ImmutableList.copyOf(this.parametricTypes.values());
    }

    public Optional<Type> coerceTypeBase(Type sourceType, String resultTypeBase) {
        String sourceTypeName = sourceType.getTypeSignature().getBase();
        if (sourceTypeName.equals(resultTypeBase)) {
            return Optional.of(sourceType);
        }
        switch (sourceTypeName) {
            case "unknown": {
                switch (resultTypeBase) {
                    case "boolean": 
                    case "bigint": 
                    case "integer": 
                    case "double": 
                    case "real": 
                    case "varbinary": 
                    case "date": 
                    case "time": 
                    case "time with time zone": 
                    case "timestamp": 
                    case "timestamp with time zone": 
                    case "HyperLogLog": 
                    case "SetDigest": 
                    case "P4HyperLogLog": 
                    case "json": 
                    case "interval year to month": 
                    case "interval day to second": 
                    case "JoniRegExp": 
                    case "LikePattern": 
                    case "JsonPath": 
                    case "color": 
                    case "CodePoints": {
                        return Optional.of(this.getType(new TypeSignature(resultTypeBase, new TypeSignatureParameter[0])));
                    }
                    case "varchar": {
                        return Optional.of(VarcharType.createVarcharType((int)0));
                    }
                    case "char": {
                        return Optional.of(CharType.createCharType((long)0L));
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)1, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "tinyint": {
                switch (resultTypeBase) {
                    case "smallint": {
                        return Optional.of(SmallintType.SMALLINT);
                    }
                    case "integer": {
                        return Optional.of(IntegerType.INTEGER);
                    }
                    case "bigint": {
                        return Optional.of(BigintType.BIGINT);
                    }
                    case "real": {
                        return Optional.of(RealType.REAL);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)3, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "smallint": {
                switch (resultTypeBase) {
                    case "integer": {
                        return Optional.of(IntegerType.INTEGER);
                    }
                    case "bigint": {
                        return Optional.of(BigintType.BIGINT);
                    }
                    case "real": {
                        return Optional.of(RealType.REAL);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)5, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "integer": {
                switch (resultTypeBase) {
                    case "bigint": {
                        return Optional.of(BigintType.BIGINT);
                    }
                    case "real": {
                        return Optional.of(RealType.REAL);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)10, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "bigint": {
                switch (resultTypeBase) {
                    case "real": {
                        return Optional.of(RealType.REAL);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)19, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "decimal": {
                switch (resultTypeBase) {
                    case "real": {
                        return Optional.of(RealType.REAL);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                }
                return Optional.empty();
            }
            case "real": {
                switch (resultTypeBase) {
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                }
                return Optional.empty();
            }
            case "date": {
                switch (resultTypeBase) {
                    case "timestamp": {
                        return Optional.of(TimestampType.TIMESTAMP);
                    }
                    case "timestamp with time zone": {
                        return Optional.of(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
                    }
                }
                return Optional.empty();
            }
            case "time": {
                switch (resultTypeBase) {
                    case "time with time zone": {
                        return Optional.of(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE);
                    }
                }
                return Optional.empty();
            }
            case "timestamp": {
                switch (resultTypeBase) {
                    case "timestamp with time zone": {
                        return Optional.of(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
                    }
                }
                return Optional.empty();
            }
            case "varchar": {
                switch (resultTypeBase) {
                    case "char": {
                        if (this.featuresConfig.isLegacyCharToVarcharCoercion()) {
                            return Optional.empty();
                        }
                        VarcharType varcharType = (VarcharType)sourceType;
                        if (varcharType.isUnbounded()) {
                            return Optional.of(CharType.createCharType((long)65536L));
                        }
                        return Optional.of(CharType.createCharType((long)Math.min(65536, varcharType.getLengthSafe())));
                    }
                    case "JoniRegExp": {
                        return Optional.of(JoniRegexpType.JONI_REGEXP);
                    }
                    case "Re2JRegExp": {
                        return Optional.of(Re2JRegexpType.RE2J_REGEXP);
                    }
                    case "LikePattern": {
                        return Optional.of(LikePatternType.LIKE_PATTERN);
                    }
                    case "JsonPath": {
                        return Optional.of(JsonPathType.JSON_PATH);
                    }
                    case "CodePoints": {
                        return Optional.of(CodePointsType.CODE_POINTS);
                    }
                }
                return Optional.empty();
            }
            case "char": {
                switch (resultTypeBase) {
                    case "varchar": {
                        if (!this.featuresConfig.isLegacyCharToVarcharCoercion()) {
                            return Optional.empty();
                        }
                        CharType charType = (CharType)sourceType;
                        return Optional.of(VarcharType.createVarcharType((int)charType.getLength()));
                    }
                    case "JoniRegExp": {
                        return Optional.of(JoniRegexpType.JONI_REGEXP);
                    }
                    case "Re2JRegExp": {
                        return Optional.of(Re2JRegexpType.RE2J_REGEXP);
                    }
                    case "LikePattern": {
                        return Optional.of(LikePatternType.LIKE_PATTERN);
                    }
                    case "JsonPath": {
                        return Optional.of(JsonPathType.JSON_PATH);
                    }
                    case "CodePoints": {
                        return Optional.of(CodePointsType.CODE_POINTS);
                    }
                }
                return Optional.empty();
            }
            case "P4HyperLogLog": {
                switch (resultTypeBase) {
                    case "HyperLogLog": {
                        return Optional.of(HyperLogLogType.HYPER_LOG_LOG);
                    }
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private static boolean isCovariantParametrizedType(Type type) {
        return type instanceof MapType || type instanceof ArrayType;
    }

    public static boolean isCovariantTypeBase(String typeBase) {
        return typeBase.equals("array") || typeBase.equals("map");
    }

    public MethodHandle resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) {
        Objects.requireNonNull(this.functionManager, "functionManager is null");
        return this.functionManager.getScalarFunctionImplementation(this.functionManager.resolveOperator(operatorType, TypeSignatureProvider.fromTypes(argumentTypes))).getMethodHandle();
    }

    public static class TypeCompatibility {
        private final Optional<Type> commonSuperType;
        private final boolean coercible;

        private TypeCompatibility(Optional<Type> commonSuperType, boolean coercible) {
            Preconditions.checkArgument((!coercible || commonSuperType.isPresent() ? 1 : 0) != 0);
            this.commonSuperType = commonSuperType;
            this.coercible = coercible;
        }

        private static TypeCompatibility compatible(Type commonSuperType, boolean coercible) {
            return new TypeCompatibility(Optional.of(commonSuperType), coercible);
        }

        private static TypeCompatibility incompatible() {
            return new TypeCompatibility(Optional.empty(), false);
        }

        public boolean isCompatible() {
            return this.commonSuperType.isPresent();
        }

        public Type getCommonSuperType() {
            Preconditions.checkState((boolean)this.commonSuperType.isPresent(), (Object)"Types are not compatible");
            return this.commonSuperType.get();
        }

        public boolean isCoercible() {
            return this.coercible;
        }
    }
}

