/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.IpAddressType;
import com.facebook.presto.type.IpPrefixType;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class IpPrefixOperators {
    private IpPrefixOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="ipprefix") Slice left, @SqlType(value="ipprefix") Slice right) {
        return left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="ipprefix") Slice left, @SqlType(value="ipprefix") Slice right) {
        return !left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean lessThan(@SqlType(value="ipprefix") Slice left, @SqlType(value="ipprefix") Slice right) {
        return left.compareTo(right) < 0;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean lessThanOrEqual(@SqlType(value="ipprefix") Slice left, @SqlType(value="ipprefix") Slice right) {
        return left.compareTo(right) <= 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean greaterThan(@SqlType(value="ipprefix") Slice left, @SqlType(value="ipprefix") Slice right) {
        return left.compareTo(right) > 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean greaterThanOrEqual(@SqlType(value="ipprefix") Slice left, @SqlType(value="ipprefix") Slice right) {
        return left.compareTo(right) >= 0;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean between(@SqlType(value="ipprefix") Slice value, @SqlType(value="ipprefix") Slice min, @SqlType(value="ipprefix") Slice max) {
        return min.compareTo(value) <= 0 && value.compareTo(max) <= 0;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="ipprefix") Slice value) {
        return XxHash64.hash((Slice)value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    @SqlType(value="bigint")
    public static long xxHash64(@SqlType(value="ipprefix") Slice value) {
        return XxHash64.hash((Slice)value);
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="ipprefix")
    public static Slice castFromVarcharToIpPrefix(@SqlType(value="varchar(x)") Slice slice) {
        byte[] address;
        String string = slice.toStringUtf8();
        if (!string.contains("/")) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast value to IPPREFIX: " + slice.toStringUtf8());
        }
        String[] parts = string.split("/");
        try {
            address = InetAddresses.forString((String)parts[0]).getAddress();
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast value to IPPREFIX: " + slice.toStringUtf8());
        }
        int subnetSize = Integer.parseInt(parts[1]);
        byte[] bytes = new byte[IpPrefixType.IPPREFIX.getFixedSize()];
        if (address.length == 4) {
            if (subnetSize < 0 || 32 < subnetSize) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast value to IPPREFIX: " + slice.toStringUtf8());
            }
            for (int i = 0; i < 4; ++i) {
                int n = 3 - i;
                address[n] = (byte)(address[n] & -1 << Math.min(Math.max(32 - subnetSize - 8 * i, 0), 8));
            }
            bytes[10] = -1;
            bytes[11] = -1;
            System.arraycopy(address, 0, bytes, 12, 4);
            bytes[IpPrefixType.IPPREFIX.getFixedSize() - 1] = (byte)subnetSize;
        } else if (address.length == 16) {
            if (subnetSize < 0 || 128 < subnetSize) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast value to IPPREFIX: " + slice.toStringUtf8());
            }
            for (int i = 0; i < 16; ++i) {
                int n = 15 - i;
                address[n] = (byte)(address[n] & -1 << Math.min(Math.max(128 - subnetSize - 8 * i, 0), 8));
            }
            System.arraycopy(address, 0, bytes, 0, 16);
            bytes[IpPrefixType.IPPREFIX.getFixedSize() - 1] = (byte)subnetSize;
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid InetAddress length: " + address.length);
        }
        return Slices.wrappedBuffer((byte[])bytes);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castFromIpPrefixToVarchar(@SqlType(value="ipprefix") Slice slice) {
        try {
            String addrString = InetAddresses.toAddrString((InetAddress)InetAddress.getByAddress(slice.getBytes(0, 16)));
            String prefixString = Integer.toString(slice.getByte(16) & 0xFF);
            return Slices.utf8Slice((String)(addrString + "/" + prefixString));
        }
        catch (UnknownHostException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Invalid IP address binary length: " + slice.length(), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="ipaddress")
    public static Slice castFromIpPrefixToIpAddress(@SqlType(value="ipprefix") Slice slice) {
        return Slices.wrappedBuffer((byte[])slice.getBytes(0, IpAddressType.IPADDRESS.getFixedSize()));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="ipprefix")
    public static Slice castFromIpAddressToIpPrefix(@SqlType(value="ipaddress") Slice slice) {
        byte[] address;
        try {
            address = InetAddress.getByAddress(slice.getBytes()).getAddress();
        }
        catch (UnknownHostException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Invalid IP address binary: " + slice.toStringUtf8(), (Throwable)e);
        }
        byte[] bytes = new byte[IpPrefixType.IPPREFIX.getFixedSize()];
        System.arraycopy(slice.getBytes(), 0, bytes, 0, IpPrefixType.IPPREFIX.getFixedSize() - 1);
        if (address.length == 4) {
            bytes[IpPrefixType.IPPREFIX.getFixedSize() - 1] = 32;
        } else if (address.length == 16) {
            bytes[IpPrefixType.IPPREFIX.getFixedSize() - 1] = -128;
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid InetAddress length: " + address.length);
        }
        return Slices.wrappedBuffer((byte[])bytes);
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="ipprefix") Slice value, @IsNull boolean isNull) {
        return isNull;
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static class IpPrefixDistinctFromOperator {
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="ipprefix") Slice left, @IsNull boolean leftNull, @SqlType(value="ipprefix") Slice right, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return IpPrefixOperators.notEqual(left, right);
        }

        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="ipprefix", nativeContainerType=Slice.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="ipprefix", nativeContainerType=Slice.class) Block right, @BlockIndex int rightPosition) {
            if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
                return true;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            return left.compareTo(leftPosition, 0, IpPrefixType.IPPREFIX.getFixedSize(), right, rightPosition, 0, IpPrefixType.IPPREFIX.getFixedSize()) != 0;
        }
    }
}

