/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.relation.FullyQualifiedName;
import com.facebook.presto.sqlfunction.AbstractSqlInvokedFunctionNamespaceManager;
import com.facebook.presto.sqlfunction.SqlFunctionId;
import com.facebook.presto.sqlfunction.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.sqlfunction.SqlInvokedRegularFunction;
import com.facebook.presto.sqlfunction.SqlInvokedRegularFunctionHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class InMemoryFunctionNamespaceManager
extends AbstractSqlInvokedFunctionNamespaceManager {
    private static final String NAME = "_in_memory";
    private final Map<SqlFunctionId, SqlInvokedRegularFunction> latestFunctions = new ConcurrentHashMap<SqlFunctionId, SqlInvokedRegularFunction>();

    public InMemoryFunctionNamespaceManager(SqlInvokedFunctionNamespaceManagerConfig config) {
        super(config);
    }

    public String getName() {
        return NAME;
    }

    public synchronized void createFunction(SqlInvokedRegularFunction function, boolean replace) {
        SqlFunctionId functionId = new SqlFunctionId(function.getSignature().getName(), function.getSignature().getArgumentTypes());
        if (!replace && this.latestFunctions.containsKey(functionId)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Function '%s' already exists", functionId.getName()));
        }
        SqlInvokedRegularFunction replacedFunction = this.latestFunctions.get(functionId);
        long version = 1L;
        if (replacedFunction != null) {
            Preconditions.checkArgument((boolean)replacedFunction.getVersion().isPresent(), (Object)"missing version in replaced function");
            version = (Long)replacedFunction.getVersion().get() + 1L;
        }
        function = SqlInvokedRegularFunction.versioned((SqlInvokedRegularFunction)function, (long)version);
        this.latestFunctions.put(functionId, function);
    }

    public Collection<SqlInvokedRegularFunction> listFunctions() {
        return this.latestFunctions.values();
    }

    public Collection<SqlInvokedRegularFunction> fetchFunctionsDirect(FullyQualifiedName name) {
        return (Collection)this.latestFunctions.values().stream().filter(function -> function.getSignature().getName().equals((Object)name)).map(InMemoryFunctionNamespaceManager::copyFunction).collect(ImmutableList.toImmutableList());
    }

    public FunctionMetadata fetchFunctionMetadataDirect(SqlInvokedRegularFunctionHandle functionHandle) {
        return (FunctionMetadata)this.fetchFunctionsDirect(functionHandle.getName()).stream().filter(function -> function.getRequiredFunctionHandle().equals((Object)functionHandle)).map(AbstractSqlInvokedFunctionNamespaceManager::sqlInvokedFunctionToMetadata).collect(MoreCollectors.onlyElement());
    }

    private static SqlInvokedRegularFunction copyFunction(SqlInvokedRegularFunction function) {
        return new SqlInvokedRegularFunction(function.getSignature().getName(), function.getParameters(), function.getSignature().getReturnType(), function.getComment(), function.getRoutineCharacteristics(), function.getBody(), function.getVersion());
    }
}

