/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public final class Expressions {
    private Expressions() {
    }

    public static ConstantExpression constant(Object value, Type type) {
        return new ConstantExpression(value, type);
    }

    public static ConstantExpression constantNull(Type type) {
        return new ConstantExpression(null, type);
    }

    public static boolean isNull(RowExpression expression) {
        return expression instanceof ConstantExpression && ((ConstantExpression)expression).isNull();
    }

    public static CallExpression call(String displayName, FunctionHandle functionHandle, Type returnType, RowExpression ... arguments) {
        return new CallExpression(displayName, functionHandle, returnType, Arrays.asList(arguments));
    }

    public static CallExpression call(String displayName, FunctionHandle functionHandle, Type returnType, List<RowExpression> arguments) {
        return new CallExpression(displayName, functionHandle, returnType, arguments);
    }

    public static CallExpression call(FunctionManager functionManager, String name, Type returnType, RowExpression ... arguments) {
        return Expressions.call(functionManager, name, returnType, (List<RowExpression>)ImmutableList.copyOf((Object[])arguments));
    }

    public static CallExpression call(FunctionManager functionManager, String name, Type returnType, List<RowExpression> arguments) {
        FunctionHandle functionHandle = functionManager.lookupFunction(name, TypeSignatureProvider.fromTypes((List)arguments.stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList())));
        return Expressions.call(name, functionHandle, returnType, arguments);
    }

    public static InputReferenceExpression field(int field, Type type) {
        return new InputReferenceExpression(field, type);
    }

    public static SpecialFormExpression specialForm(SpecialFormExpression.Form form, Type returnType, RowExpression ... arguments) {
        return new SpecialFormExpression(form, returnType, arguments);
    }

    public static SpecialFormExpression specialForm(SpecialFormExpression.Form form, Type returnType, List<RowExpression> arguments) {
        return new SpecialFormExpression(form, returnType, arguments);
    }

    public static Set<RowExpression> uniqueSubExpressions(RowExpression expression) {
        return ImmutableSet.copyOf(Expressions.subExpressions((Iterable<RowExpression>)ImmutableList.of((Object)expression)));
    }

    public static List<RowExpression> subExpressions(RowExpression expression) {
        return Expressions.subExpressions((Iterable<RowExpression>)ImmutableList.of((Object)expression));
    }

    public static List<RowExpression> subExpressions(Iterable<RowExpression> expressions) {
        final ImmutableList.Builder builder = ImmutableList.builder();
        for (RowExpression expression : expressions) {
            expression.accept((RowExpressionVisitor)new RowExpressionVisitor<Void, Void>(){

                public Void visitCall(CallExpression call, Void context) {
                    builder.add((Object)call);
                    for (RowExpression argument : call.getArguments()) {
                        argument.accept((RowExpressionVisitor)this, (Object)context);
                    }
                    return null;
                }

                public Void visitInputReference(InputReferenceExpression reference, Void context) {
                    builder.add((Object)reference);
                    return null;
                }

                public Void visitConstant(ConstantExpression literal, Void context) {
                    builder.add((Object)literal);
                    return null;
                }

                public Void visitLambda(LambdaDefinitionExpression lambda, Void context) {
                    builder.add((Object)lambda);
                    lambda.getBody().accept((RowExpressionVisitor)this, (Object)context);
                    return null;
                }

                public Void visitVariableReference(VariableReferenceExpression reference, Void context) {
                    builder.add((Object)reference);
                    return null;
                }

                public Void visitSpecialForm(SpecialFormExpression specialForm, Void context) {
                    builder.add((Object)specialForm);
                    for (RowExpression argument : specialForm.getArguments()) {
                        argument.accept((RowExpressionVisitor)this, (Object)context);
                    }
                    return null;
                }
            }, null);
        }
        return builder.build();
    }

    public static VariableReferenceExpression variable(String name, Type type) {
        return new VariableReferenceExpression(name, type);
    }
}

