/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StatisticAggregations {
    private final Map<VariableReferenceExpression, AggregationNode.Aggregation> aggregations;
    private final List<VariableReferenceExpression> groupingVariables;

    @JsonCreator
    public StatisticAggregations(@JsonProperty(value="aggregations") Map<VariableReferenceExpression, AggregationNode.Aggregation> aggregations, @JsonProperty(value="groupingVariables") List<VariableReferenceExpression> groupingVariables) {
        this.aggregations = ImmutableMap.copyOf(Objects.requireNonNull(aggregations, "aggregations is null"));
        this.groupingVariables = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupingVariables, "groupingVariables is null"));
    }

    @JsonProperty
    public Map<VariableReferenceExpression, AggregationNode.Aggregation> getAggregations() {
        return this.aggregations;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getGroupingVariables() {
        return this.groupingVariables;
    }

    public Parts splitIntoPartialAndFinal(PlanVariableAllocator variableAllocator, FunctionManager functionManager) {
        return this.split(variableAllocator, functionManager, false);
    }

    public Parts splitIntoPartialAndIntermediate(PlanVariableAllocator variableAllocator, FunctionManager functionManager) {
        return this.split(variableAllocator, functionManager, true);
    }

    private Parts split(PlanVariableAllocator variableAllocator, FunctionManager functionManager, boolean intermediate) {
        ImmutableMap.Builder finalOrIntermediateAggregations = ImmutableMap.builder();
        ImmutableMap.Builder partialAggregations = ImmutableMap.builder();
        for (Map.Entry<VariableReferenceExpression, AggregationNode.Aggregation> entry : this.aggregations.entrySet()) {
            AggregationNode.Aggregation originalAggregation = entry.getValue();
            FunctionHandle functionHandle = originalAggregation.getFunctionHandle();
            InternalAggregationFunction function = functionManager.getAggregateFunctionImplementation(functionHandle);
            VariableReferenceExpression partialVariable = variableAllocator.newVariable(functionManager.getFunctionMetadata(functionHandle).getName().getSuffix(), function.getIntermediateType());
            partialAggregations.put((Object)partialVariable, (Object)new AggregationNode.Aggregation(new CallExpression(originalAggregation.getCall().getDisplayName(), functionHandle, function.getIntermediateType(), originalAggregation.getArguments()), originalAggregation.getFilter(), originalAggregation.getOrderBy(), originalAggregation.isDistinct(), originalAggregation.getMask()));
            finalOrIntermediateAggregations.put((Object)entry.getKey(), (Object)new AggregationNode.Aggregation(new CallExpression(originalAggregation.getCall().getDisplayName(), functionHandle, intermediate ? function.getIntermediateType() : function.getFinalType(), (List)ImmutableList.of((Object)partialVariable)), Optional.empty(), Optional.empty(), false, Optional.empty()));
        }
        StatisticAggregations finalOrIntermediateAggregation = new StatisticAggregations((Map<VariableReferenceExpression, AggregationNode.Aggregation>)finalOrIntermediateAggregations.build(), this.groupingVariables);
        return new Parts(intermediate ? Optional.empty() : Optional.of(finalOrIntermediateAggregation), intermediate ? Optional.of(finalOrIntermediateAggregation) : Optional.empty(), new StatisticAggregations((Map<VariableReferenceExpression, AggregationNode.Aggregation>)partialAggregations.build(), this.groupingVariables));
    }

    public static class Parts {
        private final Optional<StatisticAggregations> finalAggregation;
        private final Optional<StatisticAggregations> intermediateAggregation;
        private final StatisticAggregations partialAggregation;

        public Parts(Optional<StatisticAggregations> finalAggregation, Optional<StatisticAggregations> intermediateAggregation, StatisticAggregations partialAggregation) {
            this.finalAggregation = Objects.requireNonNull(finalAggregation, "finalAggregation is null");
            this.intermediateAggregation = Objects.requireNonNull(intermediateAggregation, "intermediateAggregation is null");
            Preconditions.checkArgument((boolean)(finalAggregation.isPresent() ^ intermediateAggregation.isPresent()), (Object)"only final or only intermediate aggregation is expected to be present");
            this.partialAggregation = Objects.requireNonNull(partialAggregation, "partialAggregation is null");
        }

        public StatisticAggregations getFinalAggregation() {
            return this.finalAggregation.orElseThrow(() -> new IllegalStateException("finalAggregation is not present"));
        }

        public StatisticAggregations getIntermediateAggregation() {
            return this.intermediateAggregation.orElseThrow(() -> new IllegalStateException("intermediateAggregation is not present"));
        }

        public StatisticAggregations getPartialAggregation() {
            return this.partialAggregation;
        }
    }
}

