/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class SetOperationNode
extends InternalPlanNode {
    private final List<PlanNode> sources;
    private final ListMultimap<VariableReferenceExpression, VariableReferenceExpression> outputToInputs;
    private final List<VariableReferenceExpression> outputVariables;

    @JsonCreator
    protected SetOperationNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="sources") List<PlanNode> sources, @JsonProperty(value="outputToInputs") ListMultimap<VariableReferenceExpression, VariableReferenceExpression> outputToInputs) {
        super(id);
        Objects.requireNonNull(sources, "sources is null");
        Preconditions.checkArgument((!sources.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one source");
        Objects.requireNonNull(outputToInputs, "outputToInputs is null");
        this.sources = ImmutableList.copyOf(sources);
        this.outputToInputs = ImmutableListMultimap.copyOf(outputToInputs);
        this.outputVariables = ImmutableList.copyOf((Collection)outputToInputs.keySet());
        for (Collection inputs : this.outputToInputs.asMap().values()) {
            Preconditions.checkArgument((inputs.size() == this.sources.size() ? 1 : 0) != 0, (String)"Every source needs to map its symbols to an output %s operation symbol", (Object)((Object)((Object)this)).getClass().getSimpleName());
        }
        for (int i = 0; i < sources.size(); ++i) {
            for (Collection expectedInputs : this.outputToInputs.asMap().values()) {
                Preconditions.checkArgument((boolean)sources.get(i).getOutputVariables().contains(Iterables.get((Iterable)expectedInputs, (int)i)), (Object)"Source does not provide required symbols");
            }
        }
    }

    @JsonProperty
    public List<PlanNode> getSources() {
        return this.sources;
    }

    @JsonProperty
    public ListMultimap<VariableReferenceExpression, VariableReferenceExpression> getVariableMapping() {
        return this.outputToInputs;
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    public List<VariableReferenceExpression> sourceOutputLayout(int sourceIndex) {
        return (List)this.getOutputVariables().stream().map(variable -> (VariableReferenceExpression)this.outputToInputs.get(variable).get(sourceIndex)).collect(ImmutableList.toImmutableList());
    }

    public Map<VariableReferenceExpression, VariableReferenceExpression> sourceVariableMap(int sourceIndex) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.outputToInputs.asMap().entrySet()) {
            builder.put(entry.getKey(), Iterables.get((Iterable)((Iterable)entry.getValue()), (int)sourceIndex));
        }
        return builder.build();
    }

    public Multimap<VariableReferenceExpression, VariableReferenceExpression> outputMap(int sourceIndex) {
        return FluentIterable.from(this.getOutputVariables()).toMap(output -> (VariableReferenceExpression)this.outputToInputs.get(output).get(sourceIndex)).asMultimap().inverse();
    }
}

