/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MarkDistinctNode
extends InternalPlanNode {
    private final PlanNode source;
    private final VariableReferenceExpression markerVariable;
    private final Optional<VariableReferenceExpression> hashVariable;
    private final List<VariableReferenceExpression> distinctVariables;

    @JsonCreator
    public MarkDistinctNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="markerVariable") VariableReferenceExpression markerVariable, @JsonProperty(value="distinctVariables") List<VariableReferenceExpression> distinctVariables, @JsonProperty(value="hashVariable") Optional<VariableReferenceExpression> hashVariable) {
        super(id);
        this.source = source;
        this.markerVariable = markerVariable;
        this.hashVariable = Objects.requireNonNull(hashVariable, "hashVariable is null");
        Objects.requireNonNull(distinctVariables, "distinctVariables is null");
        Preconditions.checkArgument((!distinctVariables.isEmpty() ? 1 : 0) != 0, (Object)"distinctVariables cannot be empty");
        this.distinctVariables = ImmutableList.copyOf(distinctVariables);
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return ImmutableList.builder().addAll((Iterable)this.source.getOutputVariables()).add((Object)this.markerVariable).build();
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public VariableReferenceExpression getMarkerVariable() {
        return this.markerVariable;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getDistinctVariables() {
        return this.distinctVariables;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getHashVariable() {
        return this.hashVariable;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitMarkDistinct(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new MarkDistinctNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.markerVariable, this.distinctVariables, this.hashVariable);
    }
}

