/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.util.MoreLists;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public class GroupIdNode
extends InternalPlanNode {
    private final PlanNode source;
    private final List<List<VariableReferenceExpression>> groupingSets;
    private final Map<VariableReferenceExpression, VariableReferenceExpression> groupingColumns;
    private final List<VariableReferenceExpression> aggregationArguments;
    private final VariableReferenceExpression groupIdVariable;

    @JsonCreator
    public GroupIdNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="groupingSets") List<List<VariableReferenceExpression>> groupingSets, @JsonProperty(value="groupingColumns") Map<VariableReferenceExpression, VariableReferenceExpression> groupingColumns, @JsonProperty(value="aggregationArguments") List<VariableReferenceExpression> aggregationArguments, @JsonProperty(value="groupIdVariable") VariableReferenceExpression groupIdVariable) {
        super(id);
        this.source = Objects.requireNonNull(source);
        this.groupingSets = MoreLists.listOfListsCopy(Objects.requireNonNull(groupingSets, "groupingSets is null"));
        this.groupingColumns = ImmutableMap.copyOf(Objects.requireNonNull(groupingColumns));
        this.aggregationArguments = ImmutableList.copyOf(aggregationArguments);
        this.groupIdVariable = Objects.requireNonNull(groupIdVariable);
        Preconditions.checkArgument((boolean)Sets.intersection(groupingColumns.keySet(), (Set)ImmutableSet.copyOf(aggregationArguments)).isEmpty(), (Object)"aggregation columns and grouping set columns must be a disjoint set");
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return ImmutableList.builder().addAll((Iterable)this.groupingSets.stream().flatMap(Collection::stream).collect(Collectors.toSet())).addAll(this.aggregationArguments).add((Object)this.groupIdVariable).build();
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<List<VariableReferenceExpression>> getGroupingSets() {
        return this.groupingSets;
    }

    @JsonProperty
    public Map<VariableReferenceExpression, VariableReferenceExpression> getGroupingColumns() {
        return this.groupingColumns;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getAggregationArguments() {
        return this.aggregationArguments;
    }

    @JsonProperty
    public VariableReferenceExpression getGroupIdVariable() {
        return this.groupIdVariable;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitGroupId(this, context);
    }

    public Set<VariableReferenceExpression> getInputVariables() {
        return ImmutableSet.builder().addAll(this.aggregationArguments).addAll((Iterable)this.groupingSets.stream().map(set -> set.stream().map(this.groupingColumns::get).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet())).build();
    }

    public Set<VariableReferenceExpression> getCommonGroupingColumns() {
        HashSet intersection = new HashSet(this.groupingSets.get(0));
        for (int i = 1; i < this.groupingSets.size(); ++i) {
            intersection.retainAll((Collection)this.groupingSets.get(i));
        }
        return ImmutableSet.copyOf(intersection);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new GroupIdNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.groupingSets, this.groupingColumns, this.aggregationArguments, this.groupIdVariable);
    }
}

