/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.optimizations.AggregationNodeUtils;
import com.facebook.presto.sql.planner.optimizations.ApplyNodeUtil;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.optimizations.WindowNodeUtil;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.ExceptNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.IntersectNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SetOperationNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticAggregations;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PruneUnreferencedOutputs
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(variableAllocator), plan, ImmutableSet.of());
    }

    private static class Rewriter
    extends SimplePlanRewriter<Set<VariableReferenceExpression>> {
        private final PlanVariableAllocator variableAllocator;

        public Rewriter(PlanVariableAllocator variableAllocator) {
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            return context.defaultRewrite(node, (Set<VariableReferenceExpression>)ImmutableSet.copyOf((Collection)node.getSource().getOutputVariables()));
        }

        @Override
        public PlanNode visitExchange(ExchangeNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            HashSet expectedOutputVariables = Sets.newHashSet((Iterable)context.get());
            node.getPartitioningScheme().getHashColumn().ifPresent(expectedOutputVariables::add);
            node.getPartitioningScheme().getPartitioning().getVariableReferences().forEach(expectedOutputVariables::add);
            node.getOrderingScheme().ifPresent(orderingScheme -> expectedOutputVariables.addAll(orderingScheme.getOrderByVariables()));
            ArrayList<List<VariableReferenceExpression>> inputsBySource = new ArrayList<List<VariableReferenceExpression>>(node.getInputs().size());
            for (int i = 0; i < node.getInputs().size(); ++i) {
                inputsBySource.add(new ArrayList());
            }
            ArrayList<VariableReferenceExpression> newOutputVariables = new ArrayList<VariableReferenceExpression>(node.getOutputVariables().size());
            for (int i = 0; i < node.getOutputVariables().size(); ++i) {
                VariableReferenceExpression outputVariable = node.getOutputVariables().get(i);
                if (!expectedOutputVariables.contains(outputVariable)) continue;
                newOutputVariables.add(outputVariable);
                for (int source = 0; source < node.getInputs().size(); ++source) {
                    ((List)inputsBySource.get(source)).add(node.getInputs().get(source).get(i));
                }
            }
            PartitioningScheme partitioningScheme = new PartitioningScheme(node.getPartitioningScheme().getPartitioning(), newOutputVariables, node.getPartitioningScheme().getHashColumn(), node.getPartitioningScheme().isReplicateNullsAndAny(), node.getPartitioningScheme().getBucketToPartition());
            ImmutableList.Builder rewrittenSources = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)inputsBySource.get(i));
                rewrittenSources.add((Object)context.rewrite(node.getSources().get(i), (Set<VariableReferenceExpression>)expectedInputs.build()));
            }
            return new ExchangeNode(node.getId(), node.getType(), node.getScope(), partitioningScheme, (List<PlanNode>)rewrittenSources.build(), inputsBySource, node.getOrderingScheme());
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableSet expectedFilterInputs = new HashSet();
            if (node.getFilter().isPresent()) {
                expectedFilterInputs = OriginalExpressionUtils.isExpression(node.getFilter().get()) ? ImmutableSet.builder().addAll(VariablesExtractor.extractUnique(OriginalExpressionUtils.castToExpression(node.getFilter().get()), this.variableAllocator.getTypes())).addAll((Iterable)context.get()).build() : ImmutableSet.builder().addAll(VariablesExtractor.extractUnique(node.getFilter().get())).addAll((Iterable)context.get()).build();
            }
            ImmutableSet.Builder leftInputsBuilder = ImmutableSet.builder();
            leftInputsBuilder.addAll((Iterable)context.get()).addAll(Iterables.transform(node.getCriteria(), JoinNode.EquiJoinClause::getLeft));
            if (node.getLeftHashVariable().isPresent()) {
                leftInputsBuilder.add((Object)node.getLeftHashVariable().get());
            }
            leftInputsBuilder.addAll((Iterable)expectedFilterInputs);
            ImmutableSet leftInputs = leftInputsBuilder.build();
            ImmutableSet.Builder rightInputsBuilder = ImmutableSet.builder();
            rightInputsBuilder.addAll((Iterable)context.get()).addAll(Iterables.transform(node.getCriteria(), JoinNode.EquiJoinClause::getRight));
            if (node.getRightHashVariable().isPresent()) {
                rightInputsBuilder.add((Object)node.getRightHashVariable().get());
            }
            rightInputsBuilder.addAll((Iterable)expectedFilterInputs);
            ImmutableSet rightInputs = rightInputsBuilder.build();
            PlanNode left = context.rewrite(node.getLeft(), (Set<VariableReferenceExpression>)leftInputs);
            PlanNode right = context.rewrite(node.getRight(), (Set<VariableReferenceExpression>)rightInputs);
            Object outputVariables = node.isCrossJoin() ? ImmutableList.builder().addAll((Iterable)left.getOutputVariables()).addAll((Iterable)right.getOutputVariables()).build() : (List)node.getOutputVariables().stream().filter(variable -> ((Set)context.get()).contains(variable)).distinct().collect(ImmutableList.toImmutableList());
            return new JoinNode(node.getId(), node.getType(), left, right, node.getCriteria(), (List<VariableReferenceExpression>)outputVariables, node.getFilter(), node.getLeftHashVariable(), node.getRightHashVariable(), node.getDistributionType());
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableSet.Builder sourceInputsBuilder = ImmutableSet.builder();
            sourceInputsBuilder.addAll((Iterable)context.get()).add((Object)node.getSourceJoinVariable());
            if (node.getSourceHashVariable().isPresent()) {
                sourceInputsBuilder.add((Object)node.getSourceHashVariable().get());
            }
            ImmutableSet sourceInputs = sourceInputsBuilder.build();
            ImmutableSet.Builder filteringSourceInputBuilder = ImmutableSet.builder();
            filteringSourceInputBuilder.add((Object)node.getFilteringSourceJoinVariable());
            if (node.getFilteringSourceHashVariable().isPresent()) {
                filteringSourceInputBuilder.add((Object)node.getFilteringSourceHashVariable().get());
            }
            ImmutableSet filteringSourceInputs = filteringSourceInputBuilder.build();
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)sourceInputs);
            PlanNode filteringSource = context.rewrite(node.getFilteringSource(), (Set<VariableReferenceExpression>)filteringSourceInputs);
            return new SemiJoinNode(node.getId(), source, filteringSource, node.getSourceJoinVariable(), node.getFilteringSourceJoinVariable(), node.getSemiJoinOutput(), node.getSourceHashVariable(), node.getFilteringSourceHashVariable(), node.getDistributionType());
        }

        @Override
        public PlanNode visitSpatialJoin(SpatialJoinNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            Set<VariableReferenceExpression> filterSymbols = OriginalExpressionUtils.isExpression(node.getFilter()) ? VariablesExtractor.extractUnique(OriginalExpressionUtils.castToExpression(node.getFilter()), this.variableAllocator.getTypes()) : VariablesExtractor.extractUnique(node.getFilter());
            ImmutableSet requiredInputs = ImmutableSet.builder().addAll(filterSymbols).addAll((Iterable)context.get()).build();
            ImmutableSet.Builder leftInputs = ImmutableSet.builder();
            node.getLeftPartitionVariable().map(arg_0 -> ((ImmutableSet.Builder)leftInputs).add(arg_0));
            ImmutableSet.Builder rightInputs = ImmutableSet.builder();
            node.getRightPartitionVariable().map(arg_0 -> ((ImmutableSet.Builder)rightInputs).add(arg_0));
            PlanNode left = context.rewrite(node.getLeft(), (Set<VariableReferenceExpression>)leftInputs.addAll((Iterable)requiredInputs).build());
            PlanNode right = context.rewrite(node.getRight(), (Set<VariableReferenceExpression>)rightInputs.addAll((Iterable)requiredInputs).build());
            List outputVariables = (List)node.getOutputVariables().stream().filter(context.get()::contains).distinct().collect(ImmutableList.toImmutableList());
            return new SpatialJoinNode(node.getId(), node.getType(), left, right, outputVariables, node.getFilter(), node.getLeftPartitionVariable(), node.getRightPartitionVariable(), node.getKdbTree());
        }

        @Override
        public PlanNode visitIndexJoin(IndexJoinNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableSet.Builder probeInputsBuilder = ImmutableSet.builder();
            probeInputsBuilder.addAll((Iterable)context.get()).addAll(Iterables.transform(node.getCriteria(), IndexJoinNode.EquiJoinClause::getProbe));
            if (node.getProbeHashVariable().isPresent()) {
                probeInputsBuilder.add((Object)node.getProbeHashVariable().get());
            }
            ImmutableSet probeInputs = probeInputsBuilder.build();
            ImmutableSet.Builder indexInputBuilder = ImmutableSet.builder();
            indexInputBuilder.addAll((Iterable)context.get()).addAll(Iterables.transform(node.getCriteria(), IndexJoinNode.EquiJoinClause::getIndex));
            if (node.getIndexHashVariable().isPresent()) {
                indexInputBuilder.add((Object)node.getIndexHashVariable().get());
            }
            ImmutableSet indexInputs = indexInputBuilder.build();
            PlanNode probeSource = context.rewrite(node.getProbeSource(), (Set<VariableReferenceExpression>)probeInputs);
            PlanNode indexSource = context.rewrite(node.getIndexSource(), (Set<VariableReferenceExpression>)indexInputs);
            return new IndexJoinNode(node.getId(), node.getType(), probeSource, indexSource, node.getCriteria(), node.getProbeHashVariable(), node.getIndexHashVariable());
        }

        @Override
        public PlanNode visitIndexSource(IndexSourceNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            List newOutputVariables = (List)node.getOutputVariables().stream().filter(context.get()::contains).collect(ImmutableList.toImmutableList());
            Set newLookupVariables = (Set)node.getLookupVariables().stream().filter(context.get()::contains).collect(ImmutableSet.toImmutableSet());
            Map newAssignments = (Map)newOutputVariables.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), node.getAssignments()::get));
            return new IndexSourceNode(node.getId(), node.getIndexHandle(), node.getTableHandle(), newLookupVariables, newOutputVariables, newAssignments, node.getCurrentConstraint());
        }

        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)node.getGroupingKeys());
            if (node.getHashVariable().isPresent()) {
                expectedInputs.add(node.getHashVariable().get());
            }
            ImmutableMap.Builder aggregations = ImmutableMap.builder();
            for (Map.Entry entry : node.getAggregations().entrySet()) {
                VariableReferenceExpression variable = (VariableReferenceExpression)entry.getKey();
                if (!context.get().contains(variable)) continue;
                AggregationNode.Aggregation aggregation = (AggregationNode.Aggregation)entry.getValue();
                expectedInputs.addAll(AggregationNodeUtils.extractAggregationUniqueVariables(aggregation, this.variableAllocator.getTypes()));
                aggregation.getMask().ifPresent(arg_0 -> ((ImmutableSet.Builder)expectedInputs).add(arg_0));
                aggregations.put((Object)variable, (Object)aggregation);
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)expectedInputs.build());
            return new AggregationNode(node.getId(), source, (Map)aggregations.build(), node.getGroupingSets(), (List)ImmutableList.of(), node.getStep(), node.getHashVariable(), node.getGroupIdVariable());
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)context.get()).addAll(node.getPartitionBy());
            node.getOrderingScheme().ifPresent(orderingScheme -> orderingScheme.getOrderByVariables().forEach(arg_0 -> ((ImmutableSet.Builder)expectedInputs).add(arg_0)));
            for (WindowNode.Frame frame : node.getFrames()) {
                if (frame.getStartValue().isPresent()) {
                    expectedInputs.add((Object)frame.getStartValue().get());
                }
                if (!frame.getEndValue().isPresent()) continue;
                expectedInputs.add((Object)frame.getEndValue().get());
            }
            if (node.getHashVariable().isPresent()) {
                expectedInputs.add((Object)node.getHashVariable().get());
            }
            ImmutableMap.Builder functionsBuilder = ImmutableMap.builder();
            for (Map.Entry<VariableReferenceExpression, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
                VariableReferenceExpression variable = entry.getKey();
                WindowNode.Function function = entry.getValue();
                if (!context.get().contains(variable)) continue;
                expectedInputs.addAll(WindowNodeUtil.extractWindowFunctionUniqueVariables(function, this.variableAllocator.getTypes()));
                functionsBuilder.put((Object)variable, (Object)entry.getValue());
            }
            PlanNode planNode = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)expectedInputs.build());
            ImmutableMap immutableMap = functionsBuilder.build();
            if (immutableMap.size() == 0) {
                return planNode;
            }
            return new WindowNode(node.getId(), planNode, node.getSpecification(), (Map<VariableReferenceExpression, WindowNode.Function>)immutableMap, node.getHashVariable(), node.getPrePartitionedInputs(), node.getPreSortedOrderPrefix());
        }

        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            List newOutputs = (List)node.getOutputVariables().stream().filter(context.get()::contains).collect(ImmutableList.toImmutableList());
            Map newAssignments = newOutputs.stream().collect(Collectors.toMap(Function.identity(), node.getAssignments()::get));
            return new TableScanNode(node.getId(), node.getTable(), newOutputs, newAssignments, node.getCurrentConstraint(), node.getEnforcedConstraint());
        }

        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableSet expectedInputs = OriginalExpressionUtils.isExpression(node.getPredicate()) ? ImmutableSet.builder().addAll(VariablesExtractor.extractUnique(OriginalExpressionUtils.castToExpression(node.getPredicate()), this.variableAllocator.getTypes())).addAll((Iterable)context.get()).build() : ImmutableSet.builder().addAll(VariablesExtractor.extractUnique(node.getPredicate())).addAll((Iterable)context.get()).build();
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)expectedInputs);
            return new FilterNode(node.getId(), source, node.getPredicate());
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder();
            List<VariableReferenceExpression> newAggregationArguments = node.getAggregationArguments().stream().filter(context.get()::contains).collect(Collectors.toList());
            expectedInputs.addAll(newAggregationArguments);
            ImmutableList.Builder newGroupingSets = ImmutableList.builder();
            HashMap<VariableReferenceExpression, VariableReferenceExpression> newGroupingMapping = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
            for (List<VariableReferenceExpression> groupingSet : node.getGroupingSets()) {
                ImmutableList.Builder newGroupingSet = ImmutableList.builder();
                for (VariableReferenceExpression output : groupingSet) {
                    if (!context.get().contains(output)) continue;
                    newGroupingSet.add((Object)output);
                    newGroupingMapping.putIfAbsent(output, node.getGroupingColumns().get(output));
                    expectedInputs.add((Object)node.getGroupingColumns().get(output));
                }
                newGroupingSets.add((Object)newGroupingSet.build());
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)expectedInputs.build());
            return new GroupIdNode(node.getId(), source, (List<List<VariableReferenceExpression>>)newGroupingSets.build(), newGroupingMapping, newAggregationArguments, node.getGroupIdVariable());
        }

        @Override
        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            if (!context.get().contains(node.getMarkerVariable())) {
                return context.rewrite(node.getSource(), context.get());
            }
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll(node.getDistinctVariables()).addAll((Iterable)context.get().stream().filter(variable -> !variable.equals((Object)node.getMarkerVariable())).collect(ImmutableList.toImmutableList()));
            if (node.getHashVariable().isPresent()) {
                expectedInputs.add((Object)node.getHashVariable().get());
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)expectedInputs.build());
            return new MarkDistinctNode(node.getId(), source, node.getMarkerVariable(), node.getDistinctVariables(), node.getHashVariable());
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            List replicateVariables = (List)node.getReplicateVariables().stream().filter(context.get()::contains).collect(ImmutableList.toImmutableList());
            Optional<Object> ordinalityVariable = node.getOrdinalityVariable();
            if (ordinalityVariable.isPresent() && !context.get().contains(ordinalityVariable.get())) {
                ordinalityVariable = Optional.empty();
            }
            Map<VariableReferenceExpression, List<VariableReferenceExpression>> unnestVariables = node.getUnnestVariables();
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)replicateVariables).addAll(unnestVariables.keySet());
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)expectedInputs.build());
            return new UnnestNode(node.getId(), source, replicateVariables, unnestVariables, ordinalityVariable);
        }

        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder();
            Assignments.Builder builder = Assignments.builder();
            node.getAssignments().forEach((variable, expression) -> {
                if (((Set)context.get()).contains(variable)) {
                    if (OriginalExpressionUtils.isExpression(expression)) {
                        expectedInputs.addAll(VariablesExtractor.extractUnique(OriginalExpressionUtils.castToExpression(expression), this.variableAllocator.getTypes()));
                    } else {
                        expectedInputs.addAll(VariablesExtractor.extractUnique(expression));
                    }
                    builder.put(variable, expression);
                }
            });
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)expectedInputs.build());
            return new ProjectNode(node.getId(), source, builder.build());
        }

        @Override
        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableSet expectedInputs = ImmutableSet.copyOf(node.getOutputVariables());
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)expectedInputs);
            return new OutputNode(node.getId(), source, node.getColumnNames(), node.getOutputVariables());
        }

        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)context.get());
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)expectedInputs.build());
            return new LimitNode(node.getId(), source, node.getCount(), node.getStep());
        }

        @Override
        public PlanNode visitDistinctLimit(DistinctLimitNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableSet expectedInputs = node.getHashVariable().isPresent() ? ImmutableSet.copyOf((Iterable)Iterables.concat(node.getDistinctVariables(), (Iterable)ImmutableList.of((Object)node.getHashVariable().get()))) : ImmutableSet.copyOf(node.getDistinctVariables());
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)expectedInputs);
            return new DistinctLimitNode(node.getId(), source, node.getLimit(), node.isPartial(), node.getDistinctVariables(), node.getHashVariable());
        }

        public PlanNode visitTopN(TopNNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)context.get()).addAll((Iterable)node.getOrderingScheme().getOrderByVariables());
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)expectedInputs.build());
            return new TopNNode(node.getId(), source, node.getCount(), node.getOrderingScheme(), node.getStep());
        }

        @Override
        public PlanNode visitRowNumber(RowNumberNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableSet.Builder inputsBuilder = ImmutableSet.builder();
            ImmutableSet.Builder expectedInputs = inputsBuilder.addAll((Iterable)context.get()).addAll(node.getPartitionBy());
            if (node.getHashVariable().isPresent()) {
                inputsBuilder.add((Object)node.getHashVariable().get());
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)expectedInputs.build());
            return new RowNumberNode(node.getId(), source, node.getPartitionBy(), node.getRowNumberVariable(), node.getMaxRowCountPerPartition(), node.getHashVariable());
        }

        @Override
        public PlanNode visitTopNRowNumber(TopNRowNumberNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)context.get()).addAll(node.getPartitionBy()).addAll((Iterable)node.getOrderingScheme().getOrderByVariables());
            if (node.getHashVariable().isPresent()) {
                expectedInputs.add((Object)node.getHashVariable().get());
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)expectedInputs.build());
            return new TopNRowNumberNode(node.getId(), source, node.getSpecification(), node.getRowNumberVariable(), node.getMaxRowCountPerPartition(), node.isPartial(), node.getHashVariable());
        }

        @Override
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableSet expectedInputs = ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)context.get(), (Iterable)node.getOrderingScheme().getOrderByVariables()));
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)expectedInputs);
            return new SortNode(node.getId(), source, node.getOrderingScheme(), node.isPartial());
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll(node.getColumns());
            if (node.getPartitioningScheme().isPresent()) {
                PartitioningScheme partitioningScheme = node.getPartitioningScheme().get();
                partitioningScheme.getPartitioning().getVariableReferences().forEach(arg_0 -> ((ImmutableSet.Builder)expectedInputs).add(arg_0));
                partitioningScheme.getHashColumn().ifPresent(arg_0 -> ((ImmutableSet.Builder)expectedInputs).add(arg_0));
            }
            if (node.getStatisticsAggregation().isPresent()) {
                StatisticAggregations aggregations = node.getStatisticsAggregation().get();
                expectedInputs.addAll(aggregations.getGroupingVariables());
                aggregations.getAggregations().values().forEach(aggregation -> expectedInputs.addAll(AggregationNodeUtils.extractAggregationUniqueVariables(aggregation, this.variableAllocator.getTypes())));
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)expectedInputs.build());
            return new TableWriterNode(node.getId(), source, node.getTarget(), node.getRowCountVariable(), node.getFragmentVariable(), node.getTableCommitContextVariable(), node.getColumns(), node.getColumnNames(), node.getPartitioningScheme(), node.getStatisticsAggregation());
        }

        @Override
        public PlanNode visitTableWriteMerge(TableWriterMergeNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)ImmutableSet.copyOf((Collection)node.getSource().getOutputVariables()));
            return new TableWriterMergeNode(node.getId(), source, node.getRowCountVariable(), node.getFragmentVariable(), node.getTableCommitContextVariable(), node.getStatisticsAggregation());
        }

        @Override
        public PlanNode visitStatisticsWriterNode(StatisticsWriterNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)ImmutableSet.copyOf((Collection)node.getSource().getOutputVariables()));
            return new StatisticsWriterNode(node.getId(), source, node.getTarget(), node.getRowCountVariable(), node.isRowCountEnabled(), node.getDescriptor());
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)ImmutableSet.copyOf((Collection)node.getSource().getOutputVariables()));
            return new TableFinishNode(node.getId(), source, node.getTarget(), node.getRowCountVariable(), node.getStatisticsAggregation(), node.getStatisticsAggregationDescriptor());
        }

        @Override
        public PlanNode visitDelete(DeleteNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            PlanNode source = context.rewrite(node.getSource(), (Set<VariableReferenceExpression>)ImmutableSet.of((Object)node.getRowId()));
            return new DeleteNode(node.getId(), source, node.getTarget(), node.getRowId(), node.getOutputVariables());
        }

        @Override
        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ListMultimap<VariableReferenceExpression, VariableReferenceExpression> rewrittenVariableMapping = this.rewriteSetOperationVariableMapping(node, context);
            ImmutableList<PlanNode> rewrittenSubPlans = this.rewriteSetOperationSubPlans(node, context, rewrittenVariableMapping);
            return new UnionNode(node.getId(), (List<PlanNode>)rewrittenSubPlans, rewrittenVariableMapping);
        }

        @Override
        public PlanNode visitIntersect(IntersectNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ListMultimap<VariableReferenceExpression, VariableReferenceExpression> rewrittenVariableMapping = this.rewriteSetOperationVariableMapping(node, context);
            ImmutableList<PlanNode> rewrittenSubPlans = this.rewriteSetOperationSubPlans(node, context, rewrittenVariableMapping);
            return new IntersectNode(node.getId(), (List<PlanNode>)rewrittenSubPlans, rewrittenVariableMapping);
        }

        @Override
        public PlanNode visitExcept(ExceptNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ListMultimap<VariableReferenceExpression, VariableReferenceExpression> rewrittenVariableMapping = this.rewriteSetOperationVariableMapping(node, context);
            ImmutableList<PlanNode> rewrittenSubPlans = this.rewriteSetOperationSubPlans(node, context, rewrittenVariableMapping);
            return new ExceptNode(node.getId(), (List<PlanNode>)rewrittenSubPlans, rewrittenVariableMapping);
        }

        private ListMultimap<VariableReferenceExpression, VariableReferenceExpression> rewriteSetOperationVariableMapping(SetOperationNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableListMultimap.Builder rewrittenVariableMappingBuilder = ImmutableListMultimap.builder();
            for (VariableReferenceExpression variable : node.getOutputVariables()) {
                if (!context.get().contains(variable)) continue;
                rewrittenVariableMappingBuilder.putAll((Object)variable, (Iterable)node.getVariableMapping().get((Object)variable));
            }
            return rewrittenVariableMappingBuilder.build();
        }

        private ImmutableList<PlanNode> rewriteSetOperationSubPlans(SetOperationNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context, ListMultimap<VariableReferenceExpression, VariableReferenceExpression> rewrittenVariableMapping) {
            ImmutableList.Builder rewrittenSubPlans = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                ImmutableSet.Builder expectedInputSymbols = ImmutableSet.builder();
                for (Collection variables : rewrittenVariableMapping.asMap().values()) {
                    expectedInputSymbols.add(Iterables.get((Iterable)variables, (int)i));
                }
                rewrittenSubPlans.add((Object)context.rewrite(node.getSources().get(i), (Set<VariableReferenceExpression>)expectedInputSymbols.build()));
            }
            return rewrittenSubPlans.build();
        }

        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            ImmutableList.Builder rewrittenOutputVariablesBuilder = ImmutableList.builder();
            ImmutableList.Builder rowBuildersBuilder = ImmutableList.builder();
            for (int i = 0; i < node.getRows().size(); ++i) {
                rowBuildersBuilder.add((Object)ImmutableList.builder());
            }
            ImmutableList rowBuilders = rowBuildersBuilder.build();
            for (int i = 0; i < node.getOutputVariables().size(); ++i) {
                VariableReferenceExpression outputVariable = (VariableReferenceExpression)node.getOutputVariables().get(i);
                if (!context.get().contains(outputVariable)) continue;
                rewrittenOutputVariablesBuilder.add((Object)outputVariable);
                for (int j = 0; j < node.getRows().size(); ++j) {
                    ((ImmutableList.Builder)rowBuilders.get(j)).add(((List)node.getRows().get(j)).get(i));
                }
            }
            List rewrittenRows = (List)rowBuilders.stream().map(ImmutableList.Builder::build).collect(ImmutableList.toImmutableList());
            return new ValuesNode(node.getId(), (List)rewrittenOutputVariablesBuilder.build(), rewrittenRows);
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            if (Sets.intersection((Set)node.getSubqueryAssignments().getVariables(), context.get()).isEmpty()) {
                return context.rewrite(node.getInput(), context.get());
            }
            ImmutableSet.Builder subqueryAssignmentsVariablesBuilder = ImmutableSet.builder();
            Assignments.Builder subqueryAssignments = Assignments.builder();
            for (Map.Entry entry : node.getSubqueryAssignments().getMap().entrySet()) {
                VariableReferenceExpression output = (VariableReferenceExpression)entry.getKey();
                RowExpression expression = (RowExpression)entry.getValue();
                if (!context.get().contains(output)) continue;
                if (OriginalExpressionUtils.isExpression(expression)) {
                    subqueryAssignmentsVariablesBuilder.addAll(VariablesExtractor.extractUnique(OriginalExpressionUtils.castToExpression(expression), this.variableAllocator.getTypes()));
                } else {
                    subqueryAssignmentsVariablesBuilder.addAll(VariablesExtractor.extractUnique(expression));
                }
                subqueryAssignments.put(output, expression);
            }
            ImmutableSet subqueryAssignmentsVariables = subqueryAssignmentsVariablesBuilder.build();
            PlanNode subquery = context.rewrite(node.getSubquery(), (Set<VariableReferenceExpression>)subqueryAssignmentsVariables);
            Set<VariableReferenceExpression> subquerySymbols = VariablesExtractor.extractUnique(subquery, this.variableAllocator.getTypes());
            List newCorrelation = (List)node.getCorrelation().stream().filter(subquerySymbols::contains).collect(ImmutableList.toImmutableList());
            ImmutableSet inputContext = ImmutableSet.builder().addAll((Iterable)context.get()).addAll((Iterable)newCorrelation).addAll((Iterable)subqueryAssignmentsVariables).build();
            PlanNode input = context.rewrite(node.getInput(), (Set<VariableReferenceExpression>)inputContext);
            Assignments assignments = subqueryAssignments.build();
            ApplyNodeUtil.verifySubquerySupported(assignments);
            return new ApplyNode(node.getId(), input, subquery, assignments, newCorrelation, node.getOriginSubqueryError());
        }

        @Override
        public PlanNode visitAssignUniqueId(AssignUniqueId node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            if (!context.get().contains(node.getIdVariable())) {
                return context.rewrite(node.getSource(), context.get());
            }
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitLateralJoin(LateralJoinNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            PlanNode subquery = context.rewrite(node.getSubquery(), context.get());
            if (Sets.intersection((Set)ImmutableSet.copyOf((Collection)subquery.getOutputVariables()), context.get()).isEmpty() && QueryCardinalityUtil.isScalar(subquery)) {
                return context.rewrite(node.getInput(), context.get());
            }
            Set<VariableReferenceExpression> subqueryVariables = VariablesExtractor.extractUnique(subquery, this.variableAllocator.getTypes());
            List newCorrelation = (List)node.getCorrelation().stream().filter(subqueryVariables::contains).collect(ImmutableList.toImmutableList());
            ImmutableSet inputContext = ImmutableSet.builder().addAll((Iterable)context.get()).addAll((Iterable)newCorrelation).build();
            PlanNode input = context.rewrite(node.getInput(), (Set<VariableReferenceExpression>)inputContext);
            if (Sets.intersection((Set)ImmutableSet.copyOf((Collection)input.getOutputVariables()), (Set)inputContext).isEmpty() && QueryCardinalityUtil.isScalar(input)) {
                return subquery;
            }
            return new LateralJoinNode(node.getId(), input, subquery, newCorrelation, node.getType(), node.getOriginSubqueryError());
        }
    }
}

