/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.DiscretePredicates;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.relation.FullyQualifiedName;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.ExpressionDeterminismEvaluator;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class MetadataQueryOptimizer
implements PlanOptimizer {
    private static final Set<FullyQualifiedName> ALLOWED_FUNCTIONS = ImmutableSet.of((Object)FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"max"), (Object)FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"min"), (Object)FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"approx_distinct"));
    private final Metadata metadata;
    private final LiteralEncoder literalEncoder;

    public MetadataQueryOptimizer(Metadata metadata) {
        Objects.requireNonNull(metadata, "metadata is null");
        this.metadata = metadata;
        this.literalEncoder = new LiteralEncoder(metadata.getBlockEncodingSerde());
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        if (!SystemSessionProperties.isOptimizeMetadataQueries(session)) {
            return plan;
        }
        return SimplePlanRewriter.rewriteWith(new Optimizer(session, this.metadata, this.literalEncoder, idAllocator), plan, null);
    }

    private static class Replacer
    extends SimplePlanRewriter<Void> {
        private final ValuesNode replacement;

        private Replacer(ValuesNode replacement) {
            this.replacement = replacement;
        }

        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.replacement;
        }
    }

    private static class Optimizer
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Session session;
        private final Metadata metadata;
        private final LiteralEncoder literalEncoder;

        private Optimizer(Session session, Metadata metadata, LiteralEncoder literalEncoder, PlanNodeIdAllocator idAllocator) {
            this.session = session;
            this.metadata = metadata;
            this.literalEncoder = literalEncoder;
            this.idAllocator = idAllocator;
        }

        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            for (AggregationNode.Aggregation aggregation : node.getAggregations().values()) {
                FullyQualifiedName functionName = this.metadata.getFunctionManager().getFunctionMetadata(aggregation.getFunctionHandle()).getName();
                if (ALLOWED_FUNCTIONS.contains(functionName) || aggregation.isDistinct()) continue;
                return context.defaultRewrite((PlanNode)node);
            }
            Optional<TableScanNode> result = Optimizer.findTableScan(node.getSource());
            if (!result.isPresent()) {
                return context.defaultRewrite((PlanNode)node);
            }
            TableScanNode tableScan = result.get();
            ImmutableMap.Builder columnBuilder = ImmutableMap.builder();
            List inputs = tableScan.getOutputVariables();
            for (VariableReferenceExpression variable : inputs) {
                ColumnHandle column = (ColumnHandle)tableScan.getAssignments().get(variable);
                columnBuilder.put((Object)variable, (Object)column);
            }
            ImmutableMap columns = columnBuilder.build();
            TableLayout layout = !tableScan.getTable().getLayout().isPresent() ? this.metadata.getLayout(this.session, tableScan.getTable(), (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.empty()).getLayout() : this.metadata.getLayout(this.session, tableScan.getTable());
            if (!layout.getDiscretePredicates().isPresent()) {
                return context.defaultRewrite((PlanNode)node);
            }
            DiscretePredicates predicates = layout.getDiscretePredicates().get();
            if (!predicates.getColumns().containsAll(columns.values())) {
                return context.defaultRewrite((PlanNode)node);
            }
            ImmutableList.Builder rowsBuilder = ImmutableList.builder();
            for (TupleDomain domain : predicates.getPredicates()) {
                if (domain.isNone()) continue;
                Map entries = (Map)TupleDomain.extractFixedValues((TupleDomain)domain).get();
                ImmutableList.Builder rowBuilder = ImmutableList.builder();
                for (VariableReferenceExpression input : inputs) {
                    ColumnHandle column = (ColumnHandle)columns.get(input);
                    NullableValue value = (NullableValue)entries.get(column);
                    if (value == null) {
                        return context.defaultRewrite((PlanNode)node);
                    }
                    rowBuilder.add((Object)Expressions.constant(value.getValue(), input.getType()));
                }
                rowsBuilder.add((Object)rowBuilder.build());
            }
            ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), inputs, (List)rowsBuilder.build());
            return SimplePlanRewriter.rewriteWith(new Replacer(valuesNode), (PlanNode)node);
        }

        private static Optional<TableScanNode> findTableScan(PlanNode source) {
            while (true) {
                if (source instanceof MarkDistinctNode || source instanceof FilterNode || source instanceof LimitNode || source instanceof TopNNode || source instanceof SortNode) {
                    source = (PlanNode)source.getSources().get(0);
                    continue;
                }
                if (!(source instanceof ProjectNode)) break;
                ProjectNode project = (ProjectNode)source;
                if (!Iterables.all((Iterable)project.getAssignments().getExpressions().stream().map(OriginalExpressionUtils::castToExpression).collect(Collectors.toList()), ExpressionDeterminismEvaluator::isDeterministic)) {
                    return Optional.empty();
                }
                source = project.getSource();
            }
            if (source instanceof TableScanNode) {
                return Optional.of((TableScanNode)source);
            }
            return Optional.empty();
        }
    }
}

