/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.SymbolReference;

public final class JoinNodeUtils {
    private JoinNodeUtils() {
    }

    public static ComparisonExpression toExpression(JoinNode.EquiJoinClause clause) {
        return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference(clause.getLeft().getName()), (Expression)new SymbolReference(clause.getRight().getName()));
    }

    public static JoinNode.Type typeConvert(Join.Type joinType) {
        switch (joinType) {
            case CROSS: 
            case IMPLICIT: 
            case INNER: {
                return JoinNode.Type.INNER;
            }
            case LEFT: {
                return JoinNode.Type.LEFT;
            }
            case RIGHT: {
                return JoinNode.Type.RIGHT;
            }
            case FULL: {
                return JoinNode.Type.FULL;
            }
        }
        throw new UnsupportedOperationException("Unsupported join type: " + joinType);
    }
}

