/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.SymbolMapper;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class PushTopNThroughUnion
implements Rule<TopNNode> {
    private static final Capture<UnionNode> CHILD = Capture.newCapture();
    private static final Pattern<TopNNode> PATTERN = Patterns.topN().with(Patterns.TopN.step().equalTo((Object)TopNNode.Step.PARTIAL)).with(Patterns.source().matching(Patterns.union().capturedAs(CHILD)));

    @Override
    public Pattern<TopNNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TopNNode topNNode, Captures captures, Rule.Context context) {
        UnionNode unionNode = (UnionNode)((Object)captures.get(CHILD));
        ImmutableList.Builder sources = ImmutableList.builder();
        for (PlanNode source : unionNode.getSources()) {
            SymbolMapper.Builder symbolMapper = SymbolMapper.builder();
            ImmutableSet sourceOutputVariables = ImmutableSet.copyOf((Collection)source.getOutputVariables());
            for (VariableReferenceExpression unionOutput : unionNode.getOutputVariables()) {
                ImmutableSet inputVariables = ImmutableSet.copyOf((Collection)unionNode.getVariableMapping().get((Object)unionOutput));
                VariableReferenceExpression unionInput = (VariableReferenceExpression)Iterables.getLast((Iterable)Sets.intersection((Set)inputVariables, (Set)sourceOutputVariables));
                symbolMapper.put(unionOutput, unionInput);
            }
            sources.add((Object)symbolMapper.build().map(topNNode, source, context.getIdAllocator().getNextId()));
        }
        return Rule.Result.ofPlanNode(new UnionNode(unionNode.getId(), (List<PlanNode>)sources.build(), unionNode.getVariableMapping()));
    }
}

