/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.expressions.RowExpressionNodeInliner;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.PushdownFilterResult;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.operator.scalar.TryFunction;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionDomainTranslator;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.LookupSymbolResolver;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PreconditionRules;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NullLiteral;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PickTableLayout {
    private final Metadata metadata;
    private final SqlParser parser;
    private final ExpressionDomainTranslator domainTranslator;

    public PickTableLayout(Metadata metadata, SqlParser parser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.parser = Objects.requireNonNull(parser, "parser is null");
        this.domainTranslator = new ExpressionDomainTranslator(new LiteralEncoder(metadata.getBlockEncodingSerde()));
    }

    public Set<Rule<?>> rules() {
        return ImmutableSet.of(PreconditionRules.checkRulesAreFiredBeforeAddExchangesRule(), (Object)this.pickTableLayoutForPredicate(), (Object)this.pickTableLayoutWithoutPredicate());
    }

    public PickTableLayoutForPredicate pickTableLayoutForPredicate() {
        return new PickTableLayoutForPredicate(this.metadata, this.parser, this.domainTranslator);
    }

    public PickTableLayoutWithoutPredicate pickTableLayoutWithoutPredicate() {
        return new PickTableLayoutWithoutPredicate(this.metadata);
    }

    public static PlanNode pushPredicateIntoTableScan(TableScanNode node, Expression predicate, boolean pruneWithPredicateExpression, Session session, TypeProvider types, PlanNodeIdAllocator idAllocator, Metadata metadata, SqlParser parser, ExpressionDomainTranslator domainTranslator) {
        Constraint constraint;
        if (metadata.isPushdownFilterSupported(session, node.getTable())) {
            Map<NodeRef<Expression>, Type> predicateTypes = ExpressionAnalyzer.getExpressionTypes(session, metadata, parser, types, predicate, Collections.emptyList(), WarningCollector.NOOP, false);
            BiMap symbolToColumnMapping = (BiMap)node.getAssignments().entrySet().stream().collect(ImmutableBiMap.toImmutableBiMap(Map.Entry::getKey, entry -> new VariableReferenceExpression(PickTableLayout.getColumnName(session, metadata, node.getTable(), (ColumnHandle)entry.getValue()), ((VariableReferenceExpression)entry.getKey()).getType())));
            RowExpression translatedPredicate = RowExpressionNodeInliner.replaceExpression((RowExpression)SqlToRowExpressionTranslator.translate(predicate, predicateTypes, (Map<VariableReferenceExpression, Integer>)ImmutableMap.of(), metadata.getFunctionManager(), metadata.getTypeManager(), session), (Map)symbolToColumnMapping);
            PushdownFilterResult pushdownFilterResult = metadata.pushdownFilter(session, node.getTable(), translatedPredicate);
            TableLayout layout = pushdownFilterResult.getLayout();
            if (layout.getPredicate().isNone()) {
                return new ValuesNode(idAllocator.getNextId(), node.getOutputVariables(), (List)ImmutableList.of());
            }
            TableScanNode tableScan = new TableScanNode(node.getId(), layout.getNewTableHandle(), node.getOutputVariables(), node.getAssignments(), layout.getPredicate(), TupleDomain.all());
            RowExpression unenforcedFilter = pushdownFilterResult.getUnenforcedFilter();
            if (!LogicalRowExpressions.TRUE_CONSTANT.equals((Object)unenforcedFilter)) {
                return new FilterNode(idAllocator.getNextId(), (PlanNode)tableScan, RowExpressionNodeInliner.replaceExpression((RowExpression)unenforcedFilter, (Map)symbolToColumnMapping.inverse()));
            }
            return tableScan;
        }
        Expression deterministicPredicate = ExpressionUtils.filterDeterministicConjuncts(predicate);
        ExpressionDomainTranslator.ExtractionResult decomposedPredicate = ExpressionDomainTranslator.fromPredicate(metadata, session, deterministicPredicate, types);
        TupleDomain newDomain = decomposedPredicate.getTupleDomain().transform(variableName -> (ColumnHandle)((ImmutableMap)node.getAssignments().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((VariableReferenceExpression)entry.getKey()).getName(), Map.Entry::getValue))).get(variableName)).intersect(node.getEnforcedConstraint());
        ImmutableBiMap assignments = ImmutableBiMap.copyOf((Map)node.getAssignments()).inverse();
        if (pruneWithPredicateExpression) {
            LayoutConstraintEvaluator evaluator = new LayoutConstraintEvaluator(metadata, parser, session, types, node.getAssignments(), ExpressionUtils.combineConjuncts(deterministicPredicate, domainTranslator.toPredicate((TupleDomain<String>)newDomain.simplify().transform(arg_0 -> PickTableLayout.lambda$pushPredicateIntoTableScan$3((Map)assignments, arg_0)))));
            constraint = new Constraint(newDomain, x$0 -> evaluator.isCandidate(x$0));
        } else {
            constraint = new Constraint(newDomain);
        }
        if (constraint.getSummary().isNone()) {
            return new ValuesNode(idAllocator.getNextId(), node.getOutputVariables(), (List)ImmutableList.of());
        }
        TableLayoutResult layout = metadata.getLayout(session, node.getTable(), (Constraint<ColumnHandle>)constraint, Optional.of(node.getOutputVariables().stream().map(variable -> (ColumnHandle)node.getAssignments().get(variable)).collect(ImmutableSet.toImmutableSet())));
        if (layout.getLayout().getPredicate().isNone()) {
            return new ValuesNode(idAllocator.getNextId(), node.getOutputVariables(), (List)ImmutableList.of());
        }
        TableScanNode tableScan = new TableScanNode(node.getId(), layout.getLayout().getNewTableHandle(), node.getOutputVariables(), node.getAssignments(), layout.getLayout().getPredicate(), TableLayoutResult.computeEnforced((TupleDomain<ColumnHandle>)newDomain, layout.getUnenforcedConstraint()));
        Expression resultingPredicate = ExpressionUtils.combineConjuncts(domainTranslator.toPredicate((TupleDomain<String>)layout.getUnenforcedConstraint().transform(arg_0 -> PickTableLayout.lambda$pushPredicateIntoTableScan$6((Map)assignments, arg_0))), ExpressionUtils.filterNonDeterministicConjuncts(predicate), decomposedPredicate.getRemainingExpression());
        if (!BooleanLiteral.TRUE_LITERAL.equals((Object)resultingPredicate)) {
            return new FilterNode(idAllocator.getNextId(), (PlanNode)tableScan, OriginalExpressionUtils.castToRowExpression(resultingPredicate));
        }
        return tableScan;
    }

    private static String getColumnName(Session session, Metadata metadata, TableHandle tableHandle, ColumnHandle columnHandle) {
        return metadata.getColumnMetadata(session, tableHandle, columnHandle).getName();
    }

    private static /* synthetic */ String lambda$pushPredicateIntoTableScan$6(Map assignments, ColumnHandle column) {
        return ((VariableReferenceExpression)assignments.get(column)).getName();
    }

    private static /* synthetic */ String lambda$pushPredicateIntoTableScan$3(Map assignments, ColumnHandle column) {
        return assignments.containsKey(column) ? ((VariableReferenceExpression)assignments.get(column)).getName() : null;
    }

    private static class LayoutConstraintEvaluator {
        private final Map<VariableReferenceExpression, ColumnHandle> assignments;
        private final ExpressionInterpreter evaluator;
        private final Set<ColumnHandle> arguments;

        public LayoutConstraintEvaluator(Metadata metadata, SqlParser parser, Session session, TypeProvider types, Map<VariableReferenceExpression, ColumnHandle> assignments, Expression expression) {
            this.assignments = assignments;
            Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(session, metadata, parser, types, expression, Collections.emptyList(), WarningCollector.NOOP);
            this.evaluator = ExpressionInterpreter.expressionOptimizer(expression, metadata, session, expressionTypes);
            this.arguments = (Set)VariablesExtractor.extractUnique(expression, types).stream().map(assignments::get).collect(ImmutableSet.toImmutableSet());
        }

        private boolean isCandidate(Map<ColumnHandle, NullableValue> bindings) {
            if (Sets.intersection(bindings.keySet(), this.arguments).isEmpty()) {
                return true;
            }
            LookupSymbolResolver inputs = new LookupSymbolResolver(this.assignments, bindings);
            Boolean optimized = TryFunction.evaluate(() -> this.evaluator.optimize(inputs), true);
            return !Boolean.FALSE.equals(optimized) && optimized != null && !(optimized instanceof NullLiteral);
        }
    }

    private static final class PickTableLayoutWithoutPredicate
    implements Rule<TableScanNode> {
        private final Metadata metadata;
        private static final Pattern<TableScanNode> PATTERN = Patterns.tableScan();

        private PickTableLayoutWithoutPredicate(Metadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        @Override
        public Pattern<TableScanNode> getPattern() {
            return PATTERN;
        }

        @Override
        public boolean isEnabled(Session session) {
            return SystemSessionProperties.isNewOptimizerEnabled(session);
        }

        @Override
        public Rule.Result apply(TableScanNode tableScanNode, Captures captures, Rule.Context context) {
            TableHandle tableHandle = tableScanNode.getTable();
            if (tableHandle.getLayout().isPresent()) {
                return Rule.Result.empty();
            }
            Session session = context.getSession();
            if (this.metadata.isPushdownFilterSupported(session, tableHandle)) {
                PushdownFilterResult pushdownFilterResult = this.metadata.pushdownFilter(session, tableHandle, (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
                if (pushdownFilterResult.getLayout().getPredicate().isNone()) {
                    return Rule.Result.ofPlanNode((PlanNode)new ValuesNode(context.getIdAllocator().getNextId(), tableScanNode.getOutputVariables(), (List)ImmutableList.of()));
                }
                return Rule.Result.ofPlanNode((PlanNode)new TableScanNode(tableScanNode.getId(), pushdownFilterResult.getLayout().getNewTableHandle(), tableScanNode.getOutputVariables(), tableScanNode.getAssignments(), pushdownFilterResult.getLayout().getPredicate(), TupleDomain.all()));
            }
            TableLayoutResult layout = this.metadata.getLayout(session, tableHandle, (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.of(tableScanNode.getOutputVariables().stream().map(variable -> (ColumnHandle)tableScanNode.getAssignments().get(variable)).collect(ImmutableSet.toImmutableSet())));
            if (layout.getLayout().getPredicate().isNone()) {
                return Rule.Result.ofPlanNode((PlanNode)new ValuesNode(context.getIdAllocator().getNextId(), tableScanNode.getOutputVariables(), (List)ImmutableList.of()));
            }
            return Rule.Result.ofPlanNode((PlanNode)new TableScanNode(tableScanNode.getId(), layout.getLayout().getNewTableHandle(), tableScanNode.getOutputVariables(), tableScanNode.getAssignments(), layout.getLayout().getPredicate(), TupleDomain.all()));
        }
    }

    private static final class PickTableLayoutForPredicate
    implements Rule<FilterNode> {
        private final Metadata metadata;
        private final SqlParser parser;
        private final ExpressionDomainTranslator domainTranslator;
        private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
        private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));

        private PickTableLayoutForPredicate(Metadata metadata, SqlParser parser, ExpressionDomainTranslator domainTranslator) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.parser = Objects.requireNonNull(parser, "parser is null");
            this.domainTranslator = Objects.requireNonNull(domainTranslator, "domainTranslator is null");
        }

        @Override
        public Pattern<FilterNode> getPattern() {
            return PATTERN;
        }

        @Override
        public boolean isEnabled(Session session) {
            return SystemSessionProperties.isNewOptimizerEnabled(session);
        }

        @Override
        public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
            PlanNode rewritten;
            TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
            if (this.arePlansSame(filterNode, tableScan, rewritten = PickTableLayout.pushPredicateIntoTableScan(tableScan, OriginalExpressionUtils.castToExpression(filterNode.getPredicate()), false, context.getSession(), context.getVariableAllocator().getTypes(), context.getIdAllocator(), this.metadata, this.parser, this.domainTranslator))) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(rewritten);
        }

        private boolean arePlansSame(FilterNode filter, TableScanNode tableScan, PlanNode rewritten) {
            if (!(rewritten instanceof FilterNode)) {
                return false;
            }
            FilterNode rewrittenFilter = (FilterNode)rewritten;
            if (!Objects.equals(filter.getPredicate(), rewrittenFilter.getPredicate())) {
                return false;
            }
            if (!(rewrittenFilter.getSource() instanceof TableScanNode)) {
                return false;
            }
            TableScanNode rewrittenTableScan = (TableScanNode)rewrittenFilter.getSource();
            if (!tableScan.getTable().equals((Object)rewrittenTableScan.getTable())) {
                return false;
            }
            return Objects.equals(tableScan.getCurrentConstraint(), rewrittenTableScan.getCurrentConstraint()) && Objects.equals(tableScan.getEnforcedConstraint(), rewrittenTableScan.getEnforcedConstraint());
        }
    }
}

