/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.split.SampledSplitSource;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.split.SplitSourceProvider;
import com.facebook.presto.sql.planner.LazySplitSource;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.log.Logger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class SplitSourceFactory {
    private static final Logger log = Logger.get(SplitSourceFactory.class);
    private final SplitSourceProvider splitSourceProvider;

    public SplitSourceFactory(SplitSourceProvider splitSourceProvider) {
        this.splitSourceProvider = Objects.requireNonNull(splitSourceProvider, "splitSourceProvider is null");
    }

    public Map<PlanNodeId, SplitSource> createSplitSources(PlanFragment fragment, Session session) {
        ImmutableList.Builder splitSources = ImmutableList.builder();
        try {
            return (Map)fragment.getRoot().accept((PlanVisitor)new Visitor(session, fragment.getStageExecutionDescriptor(), splitSources), null);
        }
        catch (Throwable t) {
            splitSources.build().forEach(SplitSourceFactory::closeSplitSource);
            throw t;
        }
    }

    private static void closeSplitSource(SplitSource source) {
        try {
            source.close();
        }
        catch (Throwable t) {
            log.warn(t, "Error closing split source");
        }
    }

    private static ConnectorSplitManager.SplitSchedulingStrategy getSplitSchedulingStrategy(StageExecutionDescriptor stageExecutionDescriptor, PlanNodeId scanNodeId) {
        if (stageExecutionDescriptor.isRecoverableGroupedExecution()) {
            return ConnectorSplitManager.SplitSchedulingStrategy.REWINDABLE_GROUPED_SCHEDULING;
        }
        if (stageExecutionDescriptor.isScanGroupedExecution(scanNodeId)) {
            return ConnectorSplitManager.SplitSchedulingStrategy.GROUPED_SCHEDULING;
        }
        return ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING;
    }

    private final class Visitor
    extends InternalPlanVisitor<Map<PlanNodeId, SplitSource>, Void> {
        private final Session session;
        private final StageExecutionDescriptor stageExecutionDescriptor;
        private final ImmutableList.Builder<SplitSource> splitSources;

        private Visitor(Session session, StageExecutionDescriptor stageExecutionDescriptor, ImmutableList.Builder<SplitSource> allSplitSources) {
            this.session = session;
            this.stageExecutionDescriptor = stageExecutionDescriptor;
            this.splitSources = allSplitSources;
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitExplainAnalyze(ExplainAnalyzeNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitTableScan(TableScanNode node, Void context) {
            Supplier<SplitSource> splitSourceSupplier = () -> SplitSourceFactory.this.splitSourceProvider.getSplits(this.session, node.getTable(), SplitSourceFactory.getSplitSchedulingStrategy(this.stageExecutionDescriptor, node.getId()));
            LazySplitSource splitSource = new LazySplitSource(splitSourceSupplier);
            this.splitSources.add((Object)splitSource);
            return ImmutableMap.of((Object)node.getId(), (Object)splitSource);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitJoin(JoinNode node, Void context) {
            Map leftSplits = (Map)node.getLeft().accept((PlanVisitor)this, (Object)context);
            Map rightSplits = (Map)node.getRight().accept((PlanVisitor)this, (Object)context);
            return ImmutableMap.builder().putAll(leftSplits).putAll(rightSplits).build();
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitSemiJoin(SemiJoinNode node, Void context) {
            Map sourceSplits = (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
            Map filteringSourceSplits = (Map)node.getFilteringSource().accept((PlanVisitor)this, (Object)context);
            return ImmutableMap.builder().putAll(sourceSplits).putAll(filteringSourceSplits).build();
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitSpatialJoin(SpatialJoinNode node, Void context) {
            Map leftSplits = (Map)node.getLeft().accept((PlanVisitor)this, (Object)context);
            Map rightSplits = (Map)node.getRight().accept((PlanVisitor)this, (Object)context);
            return ImmutableMap.builder().putAll(leftSplits).putAll(rightSplits).build();
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitIndexJoin(IndexJoinNode node, Void context) {
            return (Map)node.getProbeSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitRemoteSource(RemoteSourceNode node, Void context) {
            return ImmutableMap.of();
        }

        public Map<PlanNodeId, SplitSource> visitValues(ValuesNode node, Void context) {
            return ImmutableMap.of();
        }

        public Map<PlanNodeId, SplitSource> visitFilter(FilterNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitSample(SampleNode node, Void context) {
            switch (node.getSampleType()) {
                case BERNOULLI: {
                    return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
                }
                case SYSTEM: {
                    Map nodeSplits = (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
                    if (nodeSplits.size() == 1) {
                        PlanNodeId planNodeId = (PlanNodeId)Iterables.getOnlyElement(nodeSplits.keySet());
                        SampledSplitSource sampledSplitSource = new SampledSplitSource((SplitSource)nodeSplits.get(planNodeId), node.getSampleRatio());
                        return ImmutableMap.of((Object)planNodeId, (Object)sampledSplitSource);
                    }
                    return nodeSplits;
                }
            }
            throw new UnsupportedOperationException("Sampling is not supported for type " + (Object)((Object)node.getSampleType()));
        }

        public Map<PlanNodeId, SplitSource> visitAggregation(AggregationNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitGroupId(GroupIdNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitMarkDistinct(MarkDistinctNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitWindow(WindowNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitRowNumber(RowNumberNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitTopNRowNumber(TopNRowNumberNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitProject(ProjectNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitUnnest(UnnestNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitTopN(TopNNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitOutput(OutputNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitEnforceSingleRow(EnforceSingleRowNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitAssignUniqueId(AssignUniqueId node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitLimit(LimitNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitDistinctLimit(DistinctLimitNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitSort(SortNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitTableWriter(TableWriterNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitTableWriteMerge(TableWriterMergeNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitTableFinish(TableFinishNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitStatisticsWriterNode(StatisticsWriterNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitDelete(DeleteNode node, Void context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitMetadataDelete(MetadataDeleteNode node, Void context) {
            return ImmutableMap.of();
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitUnion(UnionNode node, Void context) {
            return this.processSources(node.getSources(), context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitExchange(ExchangeNode node, Void context) {
            return this.processSources(node.getSources(), context);
        }

        private Map<PlanNodeId, SplitSource> processSources(List<PlanNode> sources, Void context) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (PlanNode child : sources) {
                result.putAll((Map)child.accept((PlanVisitor)this, (Object)context));
            }
            return result.build();
        }

        public Map<PlanNodeId, SplitSource> visitPlan(PlanNode node, Void context) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }
    }
}

