/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.execution.Output;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.google.common.base.Preconditions;
import java.util.Optional;

public class OutputExtractor {
    public Optional<Output> extractOutput(PlanNode root) {
        Visitor visitor = new Visitor();
        root.accept((PlanVisitor)visitor, null);
        if (visitor.getConnectorId() == null) {
            return Optional.empty();
        }
        return Optional.of(new Output(visitor.getConnectorId(), visitor.getSchemaTableName().getSchemaName(), visitor.getSchemaTableName().getTableName()));
    }

    private class Visitor
    extends InternalPlanVisitor<Void, Void> {
        private ConnectorId connectorId;
        private SchemaTableName schemaTableName;

        private Visitor() {
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Void context) {
            TableWriterNode.WriterTarget writerTarget = node.getTarget();
            if (writerTarget instanceof TableWriterNode.CreateHandle) {
                this.connectorId = ((TableWriterNode.CreateHandle)writerTarget).getHandle().getConnectorId();
                Preconditions.checkState((this.schemaTableName == null || this.schemaTableName.equals((Object)((TableWriterNode.CreateHandle)writerTarget).getSchemaTableName()) ? 1 : 0) != 0, (Object)"cannot have more than a single create, insert or delete in a query");
                this.schemaTableName = ((TableWriterNode.CreateHandle)writerTarget).getSchemaTableName();
            }
            if (writerTarget instanceof TableWriterNode.InsertHandle) {
                this.connectorId = ((TableWriterNode.InsertHandle)writerTarget).getHandle().getConnectorId();
                Preconditions.checkState((this.schemaTableName == null || this.schemaTableName.equals((Object)((TableWriterNode.InsertHandle)writerTarget).getSchemaTableName()) ? 1 : 0) != 0, (Object)"cannot have more than a single create, insert or delete in a query");
                this.schemaTableName = ((TableWriterNode.InsertHandle)writerTarget).getSchemaTableName();
            }
            if (writerTarget instanceof TableWriterNode.DeleteHandle) {
                this.connectorId = ((TableWriterNode.DeleteHandle)writerTarget).getHandle().getConnectorId();
                Preconditions.checkState((this.schemaTableName == null || this.schemaTableName.equals((Object)((TableWriterNode.DeleteHandle)writerTarget).getSchemaTableName()) ? 1 : 0) != 0, (Object)"cannot have more than a single create, insert or delete in a query");
                this.schemaTableName = ((TableWriterNode.DeleteHandle)writerTarget).getSchemaTableName();
            }
            return null;
        }

        public Void visitPlan(PlanNode node, Void context) {
            for (PlanNode child : node.getSources()) {
                child.accept((PlanVisitor)this, (Object)context);
            }
            return null;
        }

        public ConnectorId getConnectorId() {
            return this.connectorId;
        }

        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }
    }
}

