/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.scheduler.FixedBucketNodeMap;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.group.DynamicBucketNodeMap;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.BucketPartitionFunction;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.spi.BucketFunction;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.connector.ConnectorBucketNodeMap;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.EmptySplit;
import com.facebook.presto.sql.planner.NodePartitionMap;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningProviderManager;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Inject;

public class NodePartitioningManager {
    private final NodeScheduler nodeScheduler;
    private final PartitioningProviderManager partitioningProviderManager;

    @Inject
    public NodePartitioningManager(NodeScheduler nodeScheduler, PartitioningProviderManager partitioningProviderManager) {
        this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
        this.partitioningProviderManager = Objects.requireNonNull(partitioningProviderManager, "partitioningProviderManager is null");
    }

    public PartitionFunction getPartitionFunction(Session session, PartitioningScheme partitioningScheme, List<Type> partitionChannelTypes) {
        Optional<int[]> bucketToPartition = partitioningScheme.getBucketToPartition();
        Preconditions.checkArgument((boolean)bucketToPartition.isPresent(), (Object)"Bucket to partition must be set before a partition function can be created");
        PartitioningHandle partitioningHandle = partitioningScheme.getPartitioning().getHandle();
        if (partitioningHandle.getConnectorHandle() instanceof SystemPartitioningHandle) {
            Preconditions.checkArgument((boolean)partitioningScheme.getBucketToPartition().isPresent(), (Object)"Bucket to partition must be set before a partition function can be created");
            return ((SystemPartitioningHandle)partitioningHandle.getConnectorHandle()).getPartitionFunction(partitionChannelTypes, partitioningScheme.getHashColumn().isPresent(), partitioningScheme.getBucketToPartition().get());
        }
        ConnectorNodePartitioningProvider partitioningProvider = this.partitioningProviderManager.getPartitioningProvider(partitioningHandle.getConnectorId().get());
        BucketFunction bucketFunction = partitioningProvider.getBucketFunction((ConnectorTransactionHandle)partitioningHandle.getTransactionHandle().orElse(null), session.toConnectorSession(), partitioningHandle.getConnectorHandle(), partitionChannelTypes, bucketToPartition.get().length);
        Preconditions.checkArgument((bucketFunction != null ? 1 : 0) != 0, (String)"No function %s", (Object)partitioningHandle);
        return new BucketPartitionFunction(bucketFunction, partitioningScheme.getBucketToPartition().get());
    }

    public List<ConnectorPartitionHandle> listPartitionHandles(Session session, PartitioningHandle partitioningHandle) {
        ConnectorNodePartitioningProvider partitioningProvider = this.partitioningProviderManager.getPartitioningProvider(partitioningHandle.getConnectorId().get());
        return partitioningProvider.listPartitionHandles((ConnectorTransactionHandle)partitioningHandle.getTransactionHandle().orElse(null), session.toConnectorSession(), partitioningHandle.getConnectorHandle());
    }

    public NodePartitionMap getNodePartitioningMap(Session session, PartitioningHandle partitioningHandle) {
        List<InternalNode> bucketToNode;
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(partitioningHandle, "partitioningHandle is null");
        if (partitioningHandle.getConnectorHandle() instanceof SystemPartitioningHandle) {
            return ((SystemPartitioningHandle)partitioningHandle.getConnectorHandle()).getNodePartitionMap(session, this.nodeScheduler);
        }
        ConnectorBucketNodeMap connectorBucketNodeMap = this.getConnectorBucketNodeMap(session, partitioningHandle);
        Preconditions.checkArgument((connectorBucketNodeMap.getBucketCount() < 1000000 ? 1 : 0) != 0, (String)"Too many buckets in partitioning: %s", (int)connectorBucketNodeMap.getBucketCount());
        if (connectorBucketNodeMap.hasFixedMapping()) {
            bucketToNode = NodePartitioningManager.getFixedMapping(connectorBucketNodeMap);
        } else {
            ConnectorId connectorId = partitioningHandle.getConnectorId().orElseThrow(() -> new IllegalArgumentException("No connector ID for partitioning handle: " + partitioningHandle));
            bucketToNode = NodePartitioningManager.createArbitraryBucketToNode(this.nodeScheduler.createNodeSelector(connectorId).selectRandomNodes(SystemSessionProperties.getMaxTasksPerStage(session)), connectorBucketNodeMap.getBucketCount());
        }
        int[] bucketToPartition = new int[connectorBucketNodeMap.getBucketCount()];
        HashBiMap nodeToPartition = HashBiMap.create();
        int nextPartitionId = 0;
        for (int bucket = 0; bucket < bucketToNode.size(); ++bucket) {
            InternalNode node = bucketToNode.get(bucket);
            Integer partitionId = (Integer)nodeToPartition.get((Object)node);
            if (partitionId == null) {
                partitionId = nextPartitionId++;
                nodeToPartition.put((Object)node, (Object)partitionId);
            }
            bucketToPartition[bucket] = partitionId;
        }
        List partitionToNode = (List)IntStream.range(0, nodeToPartition.size()).mapToObj(arg_0 -> NodePartitioningManager.lambda$getNodePartitioningMap$1((BiMap)nodeToPartition, arg_0)).collect(ImmutableList.toImmutableList());
        return new NodePartitionMap(partitionToNode, bucketToPartition, this.getSplitToBucket(session, partitioningHandle));
    }

    public BucketNodeMap getBucketNodeMap(Session session, PartitioningHandle partitioningHandle, boolean preferDynamic) {
        ConnectorBucketNodeMap connectorBucketNodeMap = this.getConnectorBucketNodeMap(session, partitioningHandle);
        if (connectorBucketNodeMap.hasFixedMapping()) {
            return new FixedBucketNodeMap(this.getSplitToBucket(session, partitioningHandle), NodePartitioningManager.getFixedMapping(connectorBucketNodeMap));
        }
        if (preferDynamic) {
            return new DynamicBucketNodeMap(this.getSplitToBucket(session, partitioningHandle), connectorBucketNodeMap.getBucketCount());
        }
        return new FixedBucketNodeMap(this.getSplitToBucket(session, partitioningHandle), NodePartitioningManager.createArbitraryBucketToNode(new ArrayList<InternalNode>(this.nodeScheduler.createNodeSelector(partitioningHandle.getConnectorId().get()).selectRandomNodes(SystemSessionProperties.getMaxTasksPerStage(session))), connectorBucketNodeMap.getBucketCount()));
    }

    private static List<InternalNode> getFixedMapping(ConnectorBucketNodeMap connectorBucketNodeMap) {
        return (List)connectorBucketNodeMap.getFixedMapping().stream().map(InternalNode.class::cast).collect(ImmutableList.toImmutableList());
    }

    private ConnectorBucketNodeMap getConnectorBucketNodeMap(Session session, PartitioningHandle partitioningHandle) {
        Preconditions.checkArgument((!(partitioningHandle.getConnectorHandle() instanceof SystemPartitioningHandle) ? 1 : 0) != 0);
        ConnectorNodePartitioningProvider partitioningProvider = this.partitioningProviderManager.getPartitioningProvider(partitioningHandle.getConnectorId().get());
        ConnectorBucketNodeMap connectorBucketNodeMap = partitioningProvider.getBucketNodeMap((ConnectorTransactionHandle)partitioningHandle.getTransactionHandle().orElse(null), session.toConnectorSession(), partitioningHandle.getConnectorHandle());
        Preconditions.checkArgument((connectorBucketNodeMap != null ? 1 : 0) != 0, (String)"No partition map %s", (Object)partitioningHandle);
        return connectorBucketNodeMap;
    }

    private ToIntFunction<Split> getSplitToBucket(Session session, PartitioningHandle partitioningHandle) {
        ConnectorNodePartitioningProvider partitioningProvider = this.partitioningProviderManager.getPartitioningProvider(partitioningHandle.getConnectorId().get());
        ToIntFunction splitBucketFunction = partitioningProvider.getSplitBucketFunction((ConnectorTransactionHandle)partitioningHandle.getTransactionHandle().orElse(null), session.toConnectorSession(), partitioningHandle.getConnectorHandle());
        Preconditions.checkArgument((splitBucketFunction != null ? 1 : 0) != 0, (String)"No partitioning %s", (Object)partitioningHandle);
        return split -> {
            int bucket = split.getConnectorSplit() instanceof EmptySplit ? (split.getLifespan().isTaskWide() ? 0 : split.getLifespan().getId()) : splitBucketFunction.applyAsInt(split.getConnectorSplit());
            if (!split.getLifespan().isTaskWide()) {
                Preconditions.checkArgument((split.getLifespan().getId() == bucket ? 1 : 0) != 0);
            }
            return bucket;
        };
    }

    private static List<InternalNode> createArbitraryBucketToNode(List<InternalNode> nodes, int bucketCount) {
        return (List)NodePartitioningManager.cyclingShuffledStream(nodes).limit(bucketCount).collect(ImmutableList.toImmutableList());
    }

    private static <T> Stream<T> cyclingShuffledStream(Collection<T> collection) {
        ArrayList list = new ArrayList(collection);
        Collections.shuffle(list);
        return Stream.generate(() -> list).flatMap(Collection::stream);
    }

    private static /* synthetic */ InternalNode lambda$getNodePartitioningMap$1(BiMap nodeToPartition, int partitionId) {
        return (InternalNode)nodeToPartition.inverse().get((Object)partitionId);
    }
}

