/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.AnalyzedExpressionRewriter;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DesugarRowSubscriptRewriter {
    private DesugarRowSubscriptRewriter() {
    }

    public static Expression rewrite(Expression expression, Map<NodeRef<Expression>, Type> expressionTypes) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(expressionTypes), (Expression)expression, null);
    }

    public static Expression rewrite(Expression expression, Session session, Metadata metadata, SqlParser sqlParser, PlanVariableAllocator variableAllocator) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(sqlParser, "sqlParser is null");
        return new AnalyzedExpressionRewriter(session, metadata, sqlParser, variableAllocator.getTypes()).rewriteWith(Visitor::new, expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Map<NodeRef<Expression>, Type> expressionTypes;

        public Visitor(Map<NodeRef<Expression>, Type> expressionTypes) {
            this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
        }

        public Expression rewriteSubscriptExpression(SubscriptExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression base = node.getBase();
            Expression index = node.getIndex();
            SubscriptExpression result = node;
            Type type = this.getType(base);
            if (type instanceof RowType) {
                RowType rowType = (RowType)type;
                int position = Math.toIntExact(((LongLiteral)index).getValue() - 1L);
                Optional fieldName = ((RowType.Field)rowType.getFields().get(position)).getName();
                if (fieldName.isPresent()) {
                    result = new DereferenceExpression(base, new Identifier((String)fieldName.get()));
                } else {
                    ImmutableList.Builder namedFields = new ImmutableList.Builder();
                    for (int i = 0; i < rowType.getFields().size(); ++i) {
                        namedFields.add((Object)new RowType.Field(Optional.of("f" + i), (Type)rowType.getTypeParameters().get(i)));
                    }
                    RowType namedRowType = RowType.from((List)namedFields.build());
                    Cast cast = new Cast(base, namedRowType.getTypeSignature().toString());
                    result = new DereferenceExpression((Expression)cast, new Identifier("f" + position));
                }
            }
            return treeRewriter.defaultRewrite((Expression)result, (Object)context);
        }

        private Type getType(Expression expression) {
            return this.expressionTypes.get(NodeRef.of((Node)expression));
        }
    }
}

