/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.SpecialFormBytecodeGenerator;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;

public class OrCodeGenerator
implements SpecialFormBytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generator, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        Variable wasNull = generator.wasNull();
        BytecodeBlock block = new BytecodeBlock().comment("OR").setDescription("OR");
        BytecodeNode left = generator.generate(arguments.get(0), Optional.empty());
        BytecodeNode right = generator.generate(arguments.get(1), Optional.empty());
        block.append(left);
        IfStatement ifLeftIsNull = new IfStatement("if left wasNull...", new Object[0]).condition((BytecodeNode)wasNull);
        LabelNode end = new LabelNode("end");
        ifLeftIsNull.ifTrue((BytecodeNode)new BytecodeBlock().comment("clear the null flag, pop left value off stack, and push left null flag on the stack (true)").append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse())).pop(arguments.get(0).getType().getJavaType()).push(true));
        LabelNode leftIsFalse = new LabelNode("leftIsFalse");
        ifLeftIsNull.ifFalse((BytecodeNode)new BytecodeBlock().comment("if left is true, push true, and goto end").ifFalseGoto(leftIsFalse).push(true).gotoLabel(end).comment("left was false; push left null flag on the stack (false)").visitLabel(leftIsFalse).push(false));
        block.append((BytecodeNode)ifLeftIsNull);
        block.append(right);
        IfStatement ifRightIsNull = new IfStatement("if right wasNull...", new Object[0]).condition((BytecodeNode)wasNull);
        ifRightIsNull.ifTrue().comment("right was null, pop the right value off the stack; wasNull flag remains set to TRUE").pop(arguments.get(1).getType().getJavaType());
        LabelNode rightIsTrue = new LabelNode("rightIsTrue");
        ifRightIsNull.ifFalse().comment("if right is true, pop left null flag off stack, push true and goto end").ifFalseGoto(rightIsTrue).pop(Boolean.TYPE).push(true).gotoLabel(end).comment("right was false; store left null flag (on stack) in wasNull variable, and push false").visitLabel(rightIsTrue).putVariable(wasNull).push(false);
        block.append((BytecodeNode)ifRightIsNull).visitLabel(end);
        outputBlockVariable.ifPresent(output -> block.append(SpecialFormBytecodeGenerator.generateWrite(generator, returnType, output)));
        return block;
    }
}

