/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.SpecialFormBytecodeGenerator;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;

public class DereferenceCodeGenerator
implements SpecialFormBytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generator, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        CallSiteBinder callSiteBinder = generator.getCallSiteBinder();
        BytecodeBlock block = new BytecodeBlock().comment("DEREFERENCE").setDescription("DEREFERENCE");
        Variable wasNull = generator.wasNull();
        Variable rowBlock = generator.getScope().createTempVariable(Block.class);
        int index = ((Number)((ConstantExpression)arguments.get(1)).getValue()).intValue();
        block.putVariable(wasNull, false);
        block.append(generator.generate(arguments.get(0), Optional.empty())).putVariable(rowBlock);
        IfStatement ifRowBlockIsNull = new IfStatement("if row block is null...", new Object[0]).condition((BytecodeNode)wasNull);
        Class javaType = returnType.getJavaType();
        LabelNode end = new LabelNode("end");
        ifRowBlockIsNull.ifTrue().comment("if row block is null, push null to the stack and goto 'end' label (return)").putVariable(wasNull, true).pushJavaDefault(javaType).gotoLabel(end);
        block.append((BytecodeNode)ifRowBlockIsNull);
        IfStatement ifFieldIsNull = new IfStatement("if row field is null...", new Object[0]);
        ifFieldIsNull.condition().comment("call rowBlock.isNull(index)").append((BytecodeNode)rowBlock).push(index).invokeInterface(Block.class, "isNull", Boolean.TYPE, new Class[]{Integer.TYPE});
        ifFieldIsNull.ifTrue().comment("if the field is null, push null to stack").putVariable(wasNull, true).pushJavaDefault(javaType);
        BytecodeExpression value = SqlTypeBytecodeExpression.constantType(callSiteBinder, returnType).getValue((BytecodeExpression)rowBlock, BytecodeExpressions.constantInt((int)index));
        ifFieldIsNull.ifFalse().comment("otherwise call type.getTYPE(rowBlock, index)").append((BytecodeNode)value).putVariable(wasNull, false);
        block.append((BytecodeNode)ifFieldIsNull).visitLabel(end);
        outputBlockVariable.ifPresent(output -> block.append(SpecialFormBytecodeGenerator.generateWrite(generator, returnType, output)));
        return block;
    }
}

