/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Node;
import java.util.Objects;

class WindowFunctionValidator
extends DefaultExpressionTraversalVisitor<Void, Analysis> {
    private final FunctionManager functionManager;

    public WindowFunctionValidator(FunctionManager functionManager) {
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
    }

    protected Void visitFunctionCall(FunctionCall functionCall, Analysis analysis) {
        Objects.requireNonNull(analysis, "analysis is null");
        FunctionMetadata functionMetadata = this.functionManager.getFunctionMetadata(analysis.getFunctionHandle(functionCall));
        if (functionMetadata != null && functionMetadata.getFunctionKind() == FunctionKind.WINDOW && !functionCall.getWindow().isPresent()) {
            throw new SemanticException(SemanticErrorCode.WINDOW_REQUIRES_OVER, (Node)functionCall, "Window function %s requires an OVER clause", functionMetadata.getName());
        }
        return (Void)super.visitFunctionCall(functionCall, (Object)analysis);
    }
}

