/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.Session;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.split.SplitSourceProvider;
import com.google.common.base.Preconditions;
import io.airlift.log.Logger;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;

public class CloseableSplitSourceProvider
implements SplitSourceProvider,
Closeable {
    private static final Logger log = Logger.get(CloseableSplitSourceProvider.class);
    private final SplitSourceProvider delegate;
    @GuardedBy(value="this")
    private List<SplitSource> splitSources = new ArrayList<SplitSource>();
    @GuardedBy(value="this")
    private boolean closed;

    public CloseableSplitSourceProvider(SplitSourceProvider delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public synchronized SplitSource getSplits(Session session, TableHandle tableHandle, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"split source provider is closed");
        SplitSource splitSource = this.delegate.getSplits(session, tableHandle, splitSchedulingStrategy);
        this.splitSources.add(splitSource);
        return splitSource;
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            for (SplitSource source : this.splitSources) {
                try {
                    source.close();
                }
                catch (Throwable t) {
                    log.warn(t, "Error closing split source");
                }
            }
            this.splitSources = null;
        }
    }
}

