/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.smile;

import com.facebook.presto.server.smile.BaseResponse;
import com.facebook.presto.server.smile.JsonResponseWrapper;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.json.JsonCodec;
import java.util.Objects;

public class AdaptingJsonResponseHandler<T>
implements ResponseHandler<BaseResponse<T>, RuntimeException> {
    private final FullJsonResponseHandler<T> jsonResponseHandler;

    private AdaptingJsonResponseHandler(FullJsonResponseHandler<T> jsonResponseHandler) {
        this.jsonResponseHandler = Objects.requireNonNull(jsonResponseHandler, "jsonResponseHandler is null");
    }

    public static <T> AdaptingJsonResponseHandler<T> createAdaptingJsonResponseHandler(JsonCodec<T> jsonCodec) {
        return new AdaptingJsonResponseHandler<T>(FullJsonResponseHandler.createFullJsonResponseHandler(jsonCodec));
    }

    public BaseResponse<T> handleException(Request request, Exception exception) throws RuntimeException {
        return JsonResponseWrapper.wrapJsonResponse(this.jsonResponseHandler.handleException(request, exception));
    }

    public BaseResponse<T> handle(Request request, Response response) throws RuntimeException {
        return JsonResponseWrapper.wrapJsonResponse(this.jsonResponseHandler.handle(request, response));
    }
}

