/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.client.Column;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StageStats;
import com.facebook.presto.client.StatementStats;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageExecutionInfo;
import com.facebook.presto.execution.StageExecutionStats;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.buffer.PagesSerde;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.execution.buffer.SerializedPage;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.server.SessionContext;
import com.facebook.presto.server.protocol.RowIterable;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.util.Failures;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@ThreadSafe
class Query {
    private static final Logger log = Logger.get(Query.class);
    private final QueryManager queryManager;
    private final QueryId queryId;
    private final String slug = "x" + UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", "");
    @GuardedBy(value="this")
    private final ExchangeClient exchangeClient;
    private final Executor resultsProcessorExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    @GuardedBy(value="this")
    private PagesSerde serde;
    private final AtomicLong resultId = new AtomicLong();
    private final QuerySubmissionFuture submissionFuture;
    private final SessionPropertyManager sessionPropertyManager;
    private final BlockEncodingSerde blockEncodingSerde;
    @GuardedBy(value="this")
    private Session session;
    @GuardedBy(value="this")
    private QueryResults lastResult;
    @GuardedBy(value="this")
    private String lastResultPath;
    @GuardedBy(value="this")
    private List<Column> columns;
    @GuardedBy(value="this")
    private List<Type> types;
    @GuardedBy(value="this")
    private Optional<String> setCatalog = Optional.empty();
    @GuardedBy(value="this")
    private Optional<String> setSchema = Optional.empty();
    @GuardedBy(value="this")
    private Map<String, String> setSessionProperties = ImmutableMap.of();
    @GuardedBy(value="this")
    private Set<String> resetSessionProperties = ImmutableSet.of();
    @GuardedBy(value="this")
    private Map<String, SelectedRole> setRoles = ImmutableMap.of();
    @GuardedBy(value="this")
    private Map<String, String> addedPreparedStatements = ImmutableMap.of();
    @GuardedBy(value="this")
    private Set<String> deallocatedPreparedStatements = ImmutableSet.of();
    @GuardedBy(value="this")
    private Optional<TransactionId> startedTransactionId = Optional.empty();
    @GuardedBy(value="this")
    private boolean clearTransactionId;
    @GuardedBy(value="this")
    private Long updateCount;

    public static Query create(SessionContext sessionContext, String query, QueryManager queryManager, SessionPropertyManager sessionPropertyManager, ExchangeClient exchangeClient, Executor dataProcessorExecutor, ScheduledExecutorService timeoutExecutor, BlockEncodingSerde blockEncodingSerde) {
        Query result = new Query(sessionContext, query, queryManager, sessionPropertyManager, exchangeClient, dataProcessorExecutor, timeoutExecutor, blockEncodingSerde);
        MoreFutures.addSuccessCallback((ListenableFuture)result.submissionFuture, () -> {
            result.queryManager.addOutputInfoListener(result.getQueryId(), result::setQueryOutputInfo);
            result.queryManager.addStateChangeListener(result.getQueryId(), state -> {
                if (state.isDone()) {
                    QueryInfo queryInfo = queryManager.getFullQueryInfo(result.getQueryId());
                    result.closeExchangeClientIfNecessary(queryInfo);
                }
            });
        });
        return result;
    }

    private Query(SessionContext sessionContext, String query, QueryManager queryManager, SessionPropertyManager sessionPropertyManager, ExchangeClient exchangeClient, Executor resultsProcessorExecutor, ScheduledExecutorService timeoutExecutor, BlockEncodingSerde blockEncodingSerde) {
        Objects.requireNonNull(sessionContext, "sessionContext is null");
        Objects.requireNonNull(query, "query is null");
        Objects.requireNonNull(queryManager, "queryManager is null");
        Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        Objects.requireNonNull(exchangeClient, "exchangeClient is null");
        Objects.requireNonNull(resultsProcessorExecutor, "resultsProcessorExecutor is null");
        Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
        Objects.requireNonNull(blockEncodingSerde, "serde is null");
        this.queryManager = queryManager;
        this.sessionPropertyManager = sessionPropertyManager;
        this.queryId = queryManager.createQueryId();
        this.submissionFuture = new QuerySubmissionFuture(this.queryId, query, sessionContext, queryManager);
        this.exchangeClient = exchangeClient;
        this.resultsProcessorExecutor = resultsProcessorExecutor;
        this.timeoutExecutor = timeoutExecutor;
        this.blockEncodingSerde = blockEncodingSerde;
    }

    public boolean isSubmissionFinished() {
        return this.submissionFuture.isDone();
    }

    public void cancel() {
        if (this.submissionFuture.isDone()) {
            this.submissionFuture.addListener(() -> this.queryManager.cancelQuery(this.queryId), this.resultsProcessorExecutor);
        } else {
            this.queryManager.cancelQuery(this.queryId);
        }
        this.dispose();
    }

    public synchronized void dispose() {
        this.exchangeClient.close();
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public boolean isSlugValid(String slug) {
        return this.slug.equals(slug);
    }

    public synchronized Optional<String> getSetCatalog() {
        return this.setCatalog;
    }

    public synchronized Optional<String> getSetSchema() {
        return this.setSchema;
    }

    public synchronized Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    public synchronized Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    public synchronized Map<String, SelectedRole> getSetRoles() {
        return this.setRoles;
    }

    public synchronized Map<String, String> getAddedPreparedStatements() {
        return this.addedPreparedStatements;
    }

    public synchronized Set<String> getDeallocatedPreparedStatements() {
        return this.deallocatedPreparedStatements;
    }

    public synchronized Optional<TransactionId> getStartedTransactionId() {
        return this.startedTransactionId;
    }

    public synchronized boolean isClearTransactionId() {
        return this.clearTransactionId;
    }

    public synchronized ListenableFuture<QueryResults> waitForResults(OptionalLong token, UriInfo uriInfo, String scheme, Duration wait, DataSize targetResultSize) {
        Optional<QueryResults> cachedResult;
        if (token.isPresent() && (cachedResult = this.getCachedResult(token.getAsLong(), uriInfo)).isPresent()) {
            return Futures.immediateFuture((Object)cachedResult.get());
        }
        ListenableFuture futureStateChange = MoreFutures.addTimeout(this.getFutureStateChange(), () -> null, (Duration)wait, (ScheduledExecutorService)this.timeoutExecutor);
        return Futures.transform((ListenableFuture)futureStateChange, ignored -> this.getNextResult(token, uriInfo, scheme, targetResultSize), (Executor)this.resultsProcessorExecutor);
    }

    private synchronized ListenableFuture<?> getFutureStateChange() {
        this.submissionFuture.submitQuery();
        if (!this.submissionFuture.isDone()) {
            return this.submissionFuture;
        }
        if (!this.exchangeClient.isClosed()) {
            return this.exchangeClient.isBlocked();
        }
        this.queryManager.recordHeartbeat(this.queryId);
        try {
            return this.queryDoneFuture(this.queryManager.getQueryState(this.queryId));
        }
        catch (NoSuchElementException e) {
            return Futures.immediateFuture(null);
        }
    }

    private synchronized Optional<QueryResults> getCachedResult(long token, UriInfo uriInfo) {
        String requestedPath = uriInfo.getAbsolutePath().getPath();
        if (requestedPath.equals(this.lastResultPath)) {
            if (this.submissionFuture.isDone()) {
                this.queryManager.recordHeartbeat(this.queryId);
            }
            return Optional.of(this.lastResult);
        }
        if (token < this.resultId.get()) {
            throw new WebApplicationException(Response.Status.GONE);
        }
        if (this.lastResult.getNextUri() == null || !requestedPath.equals(this.lastResult.getNextUri().getPath())) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return Optional.empty();
    }

    public synchronized QueryResults getNextResult(OptionalLong token, UriInfo uriInfo, String scheme, DataSize targetResultSize) {
        Number number;
        Iterator iterator;
        Optional<QueryResults> cachedResult;
        if (token.isPresent() && (cachedResult = this.getCachedResult(token.getAsLong(), uriInfo)).isPresent()) {
            return cachedResult.get();
        }
        URI queryHtmlUri = uriInfo.getRequestUriBuilder().scheme(scheme).replacePath("ui/query.html").replaceQuery(this.queryId.toString()).build(new Object[0]);
        if (!this.submissionFuture.isDone()) {
            QueryResults queryResults = new QueryResults(this.queryId.toString(), queryHtmlUri, null, this.createNextResultsUri(scheme, uriInfo), null, null, StatementStats.builder().setState(QueryState.QUEUED.toString()).setQueued(true).setScheduled(false).build(), null, (List)ImmutableList.of(), null, null);
            this.cacheLastResults(queryResults);
            return queryResults;
        }
        if (this.session == null) {
            this.session = this.queryManager.getFullQueryInfo(this.queryId).getSession().toSession(this.sessionPropertyManager);
            this.serde = new PagesSerdeFactory(this.blockEncodingSerde, SystemSessionProperties.isExchangeCompressionEnabled(this.session)).createPagesSerde();
        }
        Iterable data = null;
        try {
            SerializedPage serializedPage;
            ImmutableList.Builder pages = ImmutableList.builder();
            long bytes = 0L;
            long rows = 0L;
            long targetResultBytes = targetResultSize.toBytes();
            while (bytes < targetResultBytes && (serializedPage = this.exchangeClient.pollPage()) != null) {
                Page page = this.serde.deserialize(serializedPage);
                bytes += page.getLogicalSizeInBytes();
                rows += (long)page.getPositionCount();
                pages.add((Object)new RowIterable(this.session.toConnectorSession(), this.types, page));
            }
            if (rows > 0L) {
                data = Iterables.concat((Iterable)pages.build());
            }
        }
        catch (Throwable cause) {
            this.queryManager.failQuery(this.queryId, cause);
        }
        QueryInfo queryInfo = this.queryManager.getFullQueryInfo(this.queryId);
        this.queryManager.recordHeartbeat(this.queryId);
        if (data != null && queryInfo.getUpdateType() != null && this.updateCount == null && this.columns.size() == 1 && this.columns.get(0).getType().equals("bigint") && (iterator = data.iterator()).hasNext() && (number = (Number)((List)iterator.next()).get(0)) != null) {
            this.updateCount = number.longValue();
        }
        this.closeExchangeClientIfNecessary(queryInfo);
        if (queryInfo.getState() == QueryState.FINISHED && !queryInfo.getOutputStage().isPresent()) {
            this.columns = ImmutableList.of((Object)new Column("result", (Type)BooleanType.BOOLEAN));
            data = ImmutableSet.of((Object)ImmutableList.of((Object)true));
        }
        URI nextResultsUri = null;
        if (!queryInfo.isFinalQueryInfo() && !queryInfo.getState().equals((Object)QueryState.FAILED) || !this.exchangeClient.isClosed()) {
            nextResultsUri = this.createNextResultsUri(scheme, uriInfo);
        }
        this.setCatalog = queryInfo.getSetCatalog();
        this.setSchema = queryInfo.getSetSchema();
        this.setSessionProperties = queryInfo.getSetSessionProperties();
        this.resetSessionProperties = queryInfo.getResetSessionProperties();
        this.setRoles = queryInfo.getSetRoles();
        this.addedPreparedStatements = queryInfo.getAddedPreparedStatements();
        this.deallocatedPreparedStatements = queryInfo.getDeallocatedPreparedStatements();
        this.startedTransactionId = queryInfo.getStartedTransactionId();
        this.clearTransactionId = queryInfo.isClearTransactionId();
        QueryResults queryResults = new QueryResults(this.queryId.toString(), queryHtmlUri, Query.findCancelableLeafStage(queryInfo), nextResultsUri, this.columns, data, Query.toStatementStats(queryInfo), Query.toQueryError(queryInfo), queryInfo.getWarnings(), queryInfo.getUpdateType(), this.updateCount);
        this.cacheLastResults(queryResults);
        return queryResults;
    }

    private synchronized void cacheLastResults(QueryResults queryResults) {
        this.lastResultPath = this.lastResult != null && this.lastResult.getNextUri() != null ? this.lastResult.getNextUri().getPath() : null;
        this.lastResult = queryResults;
    }

    private synchronized void closeExchangeClientIfNecessary(QueryInfo queryInfo) {
        if (queryInfo.getState() == QueryState.FAILED || queryInfo.getState().isDone() && !queryInfo.getOutputStage().isPresent()) {
            this.exchangeClient.close();
        }
    }

    private synchronized void setQueryOutputInfo(QueryExecution.QueryOutputInfo outputInfo) {
        if (this.columns == null) {
            List<String> columnNames = outputInfo.getColumnNames();
            List<Type> columnTypes = outputInfo.getColumnTypes();
            Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"Column names and types size mismatch");
            ImmutableList.Builder list = ImmutableList.builder();
            for (int i = 0; i < columnNames.size(); ++i) {
                list.add((Object)new Column(columnNames.get(i), columnTypes.get(i)));
            }
            this.columns = list.build();
            this.types = outputInfo.getColumnTypes();
        }
        outputInfo.getBufferLocations().forEach(this.exchangeClient::addLocation);
        if (outputInfo.isNoMoreBufferLocations()) {
            this.exchangeClient.noMoreLocations();
        }
    }

    private ListenableFuture<?> queryDoneFuture(QueryState currentState) {
        if (currentState.isDone()) {
            return Futures.immediateFuture(null);
        }
        return Futures.transformAsync(this.queryManager.getStateChange(this.queryId, currentState), this::queryDoneFuture, (Executor)MoreExecutors.directExecutor());
    }

    private synchronized URI createNextResultsUri(String scheme, UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().scheme(scheme).replacePath("/v1/statement").path(this.queryId.toString()).path(String.valueOf(this.resultId.incrementAndGet())).replaceQuery("").queryParam("slug", new Object[]{this.slug}).build(new Object[0]);
    }

    private static StatementStats toStatementStats(QueryInfo queryInfo) {
        QueryStats queryStats = queryInfo.getQueryStats();
        StageInfo outputStage = queryInfo.getOutputStage().orElse(null);
        return StatementStats.builder().setState(queryInfo.getState().toString()).setQueued(queryInfo.getState() == QueryState.QUEUED).setScheduled(queryInfo.isScheduled()).setNodes(Query.globalUniqueNodes(outputStage).size()).setTotalSplits(queryStats.getTotalDrivers()).setQueuedSplits(queryStats.getQueuedDrivers()).setRunningSplits(queryStats.getRunningDrivers() + queryStats.getBlockedDrivers()).setCompletedSplits(queryStats.getCompletedDrivers()).setCpuTimeMillis(queryStats.getTotalCpuTime().toMillis()).setWallTimeMillis(queryStats.getTotalScheduledTime().toMillis()).setQueuedTimeMillis(queryStats.getQueuedTime().toMillis()).setElapsedTimeMillis(queryStats.getElapsedTime().toMillis()).setProcessedRows(queryStats.getRawInputPositions()).setProcessedBytes(queryStats.getRawInputDataSize().toBytes()).setPeakMemoryBytes(queryStats.getPeakUserMemoryReservation().toBytes()).setSpilledBytes(queryStats.getSpilledDataSize().toBytes()).setRootStage(Query.toStageStats(outputStage)).build();
    }

    private static StageStats toStageStats(StageInfo stageInfo) {
        if (stageInfo == null) {
            return null;
        }
        StageExecutionInfo currentStageExecutionInfo = stageInfo.getLatestAttemptExecutionInfo();
        StageExecutionStats stageExecutionStats = currentStageExecutionInfo.getStats();
        ImmutableList.Builder subStages = ImmutableList.builder();
        for (StageInfo subStage : stageInfo.getSubStages()) {
            subStages.add((Object)Query.toStageStats(subStage));
        }
        HashSet<String> uniqueNodes = new HashSet<String>();
        for (TaskInfo task : currentStageExecutionInfo.getTasks()) {
            URI uri = task.getTaskStatus().getSelf();
            uniqueNodes.add(uri.getHost() + ":" + uri.getPort());
        }
        return StageStats.builder().setStageId(String.valueOf(stageInfo.getStageId().getId())).setState(currentStageExecutionInfo.getState().toString()).setDone(currentStageExecutionInfo.getState().isDone()).setNodes(uniqueNodes.size()).setTotalSplits(stageExecutionStats.getTotalDrivers()).setQueuedSplits(stageExecutionStats.getQueuedDrivers()).setRunningSplits(stageExecutionStats.getRunningDrivers() + stageExecutionStats.getBlockedDrivers()).setCompletedSplits(stageExecutionStats.getCompletedDrivers()).setCpuTimeMillis(stageExecutionStats.getTotalCpuTime().toMillis()).setWallTimeMillis(stageExecutionStats.getTotalScheduledTime().toMillis()).setProcessedRows(stageExecutionStats.getRawInputPositions()).setProcessedBytes(stageExecutionStats.getRawInputDataSize().toBytes()).setSubStages((List)subStages.build()).build();
    }

    private static Set<String> globalUniqueNodes(StageInfo stageInfo) {
        if (stageInfo == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder nodes = ImmutableSet.builder();
        for (TaskInfo task : stageInfo.getLatestAttemptExecutionInfo().getTasks()) {
            URI uri = task.getTaskStatus().getSelf();
            nodes.add((Object)(uri.getHost() + ":" + uri.getPort()));
        }
        for (StageInfo subStage : stageInfo.getSubStages()) {
            nodes.addAll(Query.globalUniqueNodes(subStage));
        }
        return nodes.build();
    }

    private static URI findCancelableLeafStage(QueryInfo queryInfo) {
        return queryInfo.getOutputStage().map(Query::findCancelableLeafStage).orElse(null);
    }

    private static URI findCancelableLeafStage(StageInfo stage) {
        if (stage.getLatestAttemptExecutionInfo().getState().isDone()) {
            return null;
        }
        for (StageInfo subStage : Lists.reverse(stage.getSubStages())) {
            URI leafStage = Query.findCancelableLeafStage(subStage);
            if (leafStage == null) continue;
            return leafStage;
        }
        return stage.getSelf();
    }

    private static QueryError toQueryError(QueryInfo queryInfo) {
        ErrorCode errorCode;
        FailureInfo failure;
        QueryState state = queryInfo.getState();
        if (state != QueryState.FAILED) {
            return null;
        }
        if (queryInfo.getFailureInfo() != null) {
            failure = queryInfo.getFailureInfo().toFailureInfo();
        } else {
            log.warn("Query %s in state %s has no failure info", new Object[]{queryInfo.getQueryId(), state});
            failure = Failures.toFailure(new RuntimeException(String.format("Query is %s (reason unknown)", new Object[]{state}))).toFailureInfo();
        }
        if (queryInfo.getErrorCode() != null) {
            errorCode = queryInfo.getErrorCode();
        } else {
            errorCode = StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode();
            log.warn("Failed query %s has no error code", new Object[]{queryInfo.getQueryId()});
        }
        return new QueryError((String)MoreObjects.firstNonNull((Object)failure.getMessage(), (Object)"Internal error"), null, errorCode.getCode(), errorCode.getName(), errorCode.getType().toString(), failure.getErrorLocation(), failure);
    }

    private static class QuerySubmissionFuture
    extends AbstractFuture<QueryInfo> {
        private final QueryId queryId;
        private final String query;
        private final SessionContext sessionContext;
        private final QueryManager queryManager;
        @GuardedBy(value="this")
        private ListenableFuture<?> querySubmissionFuture;

        public QuerySubmissionFuture(QueryId queryId, String query, SessionContext sessionContext, QueryManager queryManager) {
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.query = Objects.requireNonNull(query, "query is null");
            this.sessionContext = Objects.requireNonNull(sessionContext, "sessionContext is null");
            this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        }

        private synchronized void submitQuery() {
            if (this.querySubmissionFuture != null) {
                return;
            }
            this.querySubmissionFuture = this.queryManager.createQuery(this.queryId, this.sessionContext, this.query);
            Futures.addCallback(this.querySubmissionFuture, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    this.set(null);
                }

                public void onFailure(Throwable t) {
                    this.setException(t);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }
    }
}

