/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.operator.window.ReflectionWindowFunctionSupplier;
import com.facebook.presto.operator.window.SqlWindowFunction;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.WindowFunction;
import com.facebook.presto.spi.function.WindowFunctionSignature;
import com.facebook.presto.spi.relation.FullyQualifiedName;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Stream;

public final class WindowAnnotationsParser {
    private WindowAnnotationsParser() {
    }

    public static List<SqlWindowFunction> parseFunctionDefinition(Class<? extends WindowFunction> clazz) {
        WindowFunctionSignature[] signatures = (WindowFunctionSignature[])clazz.getAnnotationsByType(WindowFunctionSignature.class);
        Preconditions.checkArgument((signatures.length > 0 ? 1 : 0) != 0, (String)"Class is not annotated with @WindowFunctionSignature: %s", (Object)clazz.getName());
        return (List)Stream.of(signatures).map(signature -> WindowAnnotationsParser.parse(clazz, signature)).collect(ImmutableList.toImmutableList());
    }

    private static SqlWindowFunction parse(Class<? extends WindowFunction> clazz, WindowFunctionSignature window) {
        ImmutableList typeVariables = ImmutableList.of();
        if (!window.typeVariable().isEmpty()) {
            typeVariables = ImmutableList.of((Object)Signature.typeVariable((String)window.typeVariable()));
        }
        List argumentTypes = (List)Stream.of(window.argumentTypes()).map(TypeSignature::parseTypeSignature).collect(ImmutableList.toImmutableList());
        Signature signature = new Signature(FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)window.name()), FunctionKind.WINDOW, (List)typeVariables, (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)window.returnType()), argumentTypes, false);
        return new SqlWindowFunction(new ReflectionWindowFunctionSupplier<WindowFunction>(signature, clazz));
    }
}

