/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.unnest;

import com.facebook.presto.operator.unnest.UnnestBlockBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.PageBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import java.util.Objects;

abstract class Unnester {
    private final UnnestBlockBuilder[] unnestBlockBuilders;
    private int currentPosition;

    protected Unnester(Type ... types) {
        Objects.requireNonNull(types, "types is null");
        this.unnestBlockBuilders = new UnnestBlockBuilder[types.length];
        this.currentPosition = 0;
        for (int i = 0; i < types.length; ++i) {
            Objects.requireNonNull(types[i], "type is null");
            this.unnestBlockBuilders[i] = new UnnestBlockBuilder(types[i]);
        }
    }

    public final void resetInput(Block block) {
        Objects.requireNonNull(block, "block is null");
        this.resetColumnarStructure(block);
        for (int i = 0; i < this.getChannelCount(); ++i) {
            this.unnestBlockBuilders[i].resetInputBlock(this.getElementsBlock(i));
        }
        this.currentPosition = 0;
    }

    public final int getCurrentUnnestedLength() {
        return this.getElementsLength(this.currentPosition);
    }

    public final void startNewOutput(PageBuilderStatus status, int expectedEntries) {
        for (int i = 0; i < this.getChannelCount(); ++i) {
            this.unnestBlockBuilders[i].startNewOutput(status, expectedEntries);
        }
    }

    public final void processCurrentAndAdvance(int requiredOutputCount) {
        Preconditions.checkState((this.currentPosition >= 0 && this.currentPosition < this.getInputEntryCount() ? 1 : 0) != 0, (Object)"position out of bounds");
        this.processCurrentPosition(requiredOutputCount);
        ++this.currentPosition;
    }

    public final Block[] buildOutputBlocksAndFlush() {
        Block[] outputBlocks = new Block[this.getChannelCount()];
        for (int i = 0; i < this.getChannelCount(); ++i) {
            outputBlocks[i] = this.unnestBlockBuilders[i].buildOutputAndFlush();
        }
        return outputBlocks;
    }

    protected final int getCurrentPosition() {
        return this.currentPosition;
    }

    protected final UnnestBlockBuilder getBlockBuilder(int index) {
        return this.unnestBlockBuilders[index];
    }

    public abstract int getChannelCount();

    abstract int getInputEntryCount();

    protected abstract void processCurrentPosition(int var1);

    protected abstract void resetColumnarStructure(Block var1);

    protected abstract Block getElementsBlock(int var1);

    protected abstract int getElementsLength(int var1);
}

