/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.IpAddressOperators;
import com.facebook.presto.type.IpPrefixOperators;
import com.facebook.presto.util.Failures;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class IpPrefixFunctions {
    private IpPrefixFunctions() {
    }

    @Description(value="IP prefix for a given IP address and subnet size")
    @ScalarFunction(value="ip_prefix")
    @SqlType(value="ipprefix")
    public static Slice ipPrefix(@SqlType(value="ipaddress") Slice value, @SqlType(value="bigint") long subnetSize) {
        InetAddress address;
        try {
            address = InetAddress.getByAddress(value.getBytes());
        }
        catch (UnknownHostException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid IP address binary: " + value.toStringUtf8(), (Throwable)e);
        }
        int addressLength = address.getAddress().length;
        if (addressLength == 4) {
            Failures.checkCondition(0L <= subnetSize && subnetSize <= 32L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "IPv4 subnet size must be in range [0, 32]", new Object[0]);
        } else if (addressLength == 16) {
            Failures.checkCondition(0L <= subnetSize && subnetSize <= 128L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "IPv6 subnet size must be in range [0, 128]", new Object[0]);
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid InetAddress length: " + addressLength);
        }
        return IpPrefixOperators.castFromVarcharToIpPrefix(Slices.utf8Slice((String)(InetAddresses.toAddrString((InetAddress)address) + "/" + subnetSize)));
    }

    @Description(value="IP prefix for a given IP address and subnet size")
    @ScalarFunction(value="ip_prefix")
    @LiteralParameters(value={"x"})
    @SqlType(value="ipprefix")
    public static Slice stringIpPrefix(@SqlType(value="varchar(x)") Slice slice, @SqlType(value="bigint") long subnetSize) {
        return IpPrefixFunctions.ipPrefix(IpAddressOperators.castFromVarcharToIpAddress(slice), subnetSize);
    }
}

