/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;

public final class BitwiseFunctions {
    private static final int MAX_BITS = 64;

    private BitwiseFunctions() {
    }

    @Description(value="count number of set bits in 2's complement representation")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitCount(@SqlType(value="bigint") long num, @SqlType(value="bigint") long bits) {
        if (bits == 64L) {
            return Long.bitCount(num);
        }
        if (bits <= 1L || bits > 64L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Bits specified in bit_count must be between 2 and 64, got " + bits);
        }
        long lowBitsMask = (1L << (int)(bits - 1L)) - 1L;
        if (num > lowBitsMask || num < (lowBitsMask ^ 0xFFFFFFFFFFFFFFFFL)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Number must be representable with the bits specified. " + num + " can not be represented with " + bits + " bits");
        }
        long mask = (1L << (int)bits) - 1L;
        return Long.bitCount(num & mask);
    }

    @Description(value="bitwise NOT in 2's complement arithmetic")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseNot(@SqlType(value="bigint") long num) {
        return num ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Description(value="bitwise AND in 2's complement arithmetic")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseAnd(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left & right;
    }

    @Description(value="bitwise OR in 2's complement arithmetic")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseOr(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left | right;
    }

    @Description(value="bitwise XOR in 2's complement arithmetic")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseXor(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left ^ right;
    }

    @Description(value="shift left operation with specified bits")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseShiftLeft(@SqlType(value="bigint") long number, @SqlType(value="bigint") long shift, @SqlType(value="bigint") long bits) {
        if (bits == 64L) {
            return number << (int)shift;
        }
        if (bits <= 1L || bits > 64L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Bits specified must be between 2 and 64, got " + bits);
        }
        if (shift < 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Specified shift must be positive");
        }
        return number << (int)shift & (long)(Math.pow(2.0, bits) - 1.0);
    }

    @Description(value="logical shift right operation with specified bits")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseLogicalShiftRight(@SqlType(value="bigint") long number, @SqlType(value="bigint") long shift, @SqlType(value="bigint") long bits) {
        if (bits == 64L) {
            return number >>> (int)shift;
        }
        if (bits <= 1L || bits > 64L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Bits specified in must be between 2 and 64, got " + bits);
        }
        if (shift < 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Specified shift must be positive");
        }
        return (number & (long)(Math.pow(2.0, bits) - 1.0)) >>> (int)shift;
    }

    @Description(value="arithmetic shift right operation")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseArithmeticShiftRight(@SqlType(value="bigint") long number, @SqlType(value="bigint") long shift) {
        if (shift < 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Specified shift must be positive");
        }
        return number >> (int)shift;
    }
}

