/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.INDETERMINATE)
public final class ArrayIndeterminateOperator {
    private ArrayIndeterminateOperator() {
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    public static boolean indeterminate(@OperatorDependency(operator=OperatorType.INDETERMINATE, argumentTypes={"T"}) MethodHandle elementIndeterminateFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block, @IsNull boolean isNull) {
        if (isNull) {
            return true;
        }
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                return true;
            }
            try {
                if (!elementIndeterminateFunction.invoke(TypeUtils.readNativeValue((Type)type, (Block)block, (int)i), false)) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return false;
    }
}

