/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.operator.MoreByteArrays;
import com.facebook.presto.operator.UncheckedByteArrays;
import com.facebook.presto.operator.repartition.AbstractBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.BlockEncodingBuffer;
import com.facebook.presto.operator.repartition.DecodedBlockNode;
import com.facebook.presto.spi.block.ColumnarMap;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSerde;
import com.google.common.annotations.VisibleForTesting;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceOutput;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;
import sun.misc.Unsafe;

public class MapBlockEncodingBuffer
extends AbstractBlockEncodingBuffer {
    @VisibleForTesting
    static final int POSITION_SIZE = 5;
    private static final String NAME = "MAP";
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapBlockEncodingBuffer.class).instanceSize();
    private static final int HASH_MULTIPLIER = 2;
    private byte[] hashTablesBuffer;
    private int hashTableBufferIndex;
    private boolean noHashTables;
    private byte[] offsetsBuffer;
    private int offsetsBufferIndex;
    private int[] offsets;
    private int lastOffset;
    private int[] offsetsCopy;
    private ColumnarMap columnarMap;
    private final BlockEncodingBuffer keyBuffers;
    private final BlockEncodingBuffer valueBuffers;

    public MapBlockEncodingBuffer(DecodedBlockNode decodedBlockNode) {
        this.keyBuffers = MapBlockEncodingBuffer.createBlockEncodingBuffers(decodedBlockNode.getChildren().get(0));
        this.valueBuffers = MapBlockEncodingBuffer.createBlockEncodingBuffers(decodedBlockNode.getChildren().get(1));
    }

    @Override
    public void accumulateSerializedRowSizes(int[] serializedRowSizes) {
        int i = 0;
        while (i < this.positionCount) {
            int n = i++;
            serializedRowSizes[n] = serializedRowSizes[n] + 5;
        }
        this.offsetsCopy = Arrays.ensureCapacity((int[])this.offsetsCopy, (int)(this.positionCount + 1));
        System.arraycopy(this.offsets, 0, this.offsetsCopy, 0, this.positionCount + 1);
        ((AbstractBlockEncodingBuffer)this.keyBuffers).accumulateSerializedRowSizes(this.offsetsCopy, this.positionCount, serializedRowSizes);
        System.arraycopy(this.offsets, 0, this.offsetsCopy, 0, this.positionCount + 1);
        ((AbstractBlockEncodingBuffer)this.valueBuffers).accumulateSerializedRowSizes(this.offsetsCopy, this.positionCount, serializedRowSizes);
    }

    @Override
    public void setNextBatch(int positionsOffset, int batchSize) {
        this.positionsOffset = positionsOffset;
        this.batchSize = batchSize;
        if (this.positionCount == 0) {
            return;
        }
        int beginOffset = this.offsets[positionsOffset];
        int endOffset = this.offsets[positionsOffset + batchSize];
        this.keyBuffers.setNextBatch(beginOffset, endOffset - beginOffset);
        this.valueBuffers.setNextBatch(beginOffset, endOffset - beginOffset);
    }

    @Override
    public void appendDataInBatch() {
        if (this.batchSize == 0) {
            return;
        }
        this.appendNulls();
        this.appendOffsets();
        this.appendHashTables();
        this.keyBuffers.appendDataInBatch();
        this.valueBuffers.appendDataInBatch();
        this.bufferedPositionCount += this.batchSize;
    }

    @Override
    public void serializeTo(SliceOutput output) {
        MapBlockEncodingBuffer.writeLengthPrefixedString(output, NAME);
        TypeSerde.writeType((SliceOutput)output, (Type)this.columnarMap.getKeyType());
        this.keyBuffers.serializeTo(output);
        this.valueBuffers.serializeTo(output);
        if (this.hashTableBufferIndex == 0) {
            output.appendInt(-1);
        } else {
            output.appendInt(this.lastOffset * 2);
            output.appendBytes(this.hashTablesBuffer, 0, this.hashTableBufferIndex);
        }
        output.writeInt(this.bufferedPositionCount);
        output.appendInt(0);
        if (this.offsetsBufferIndex > 0) {
            output.appendBytes(this.offsetsBuffer, 0, this.offsetsBufferIndex);
        }
        this.serializeNullsTo(output);
    }

    @Override
    public void resetBuffers() {
        this.bufferedPositionCount = 0;
        this.offsetsBufferIndex = 0;
        this.lastOffset = 0;
        this.hashTableBufferIndex = 0;
        this.noHashTables = false;
        this.resetNullsBuffer();
        this.keyBuffers.resetBuffers();
        this.valueBuffers.resetBuffers();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.getPositionsRetainedSizeInBytes() + SizeOf.sizeOf((int[])this.offsets) + SizeOf.sizeOf((byte[])this.offsetsBuffer) + SizeOf.sizeOf((int[])this.offsetsCopy) + this.getNullsBufferRetainedSizeInBytes() + this.keyBuffers.getRetainedSizeInBytes() + this.valueBuffers.getRetainedSizeInBytes() + SizeOf.sizeOf((byte[])this.hashTablesBuffer);
    }

    @Override
    public long getSerializedSizeInBytes() {
        return (long)(NAME.length() + 4 + this.columnarMap.getKeyType().getTypeSignature().toString().length() + 4) + this.keyBuffers.getSerializedSizeInBytes() + this.valueBuffers.getSerializedSizeInBytes() + 4L + (long)this.hashTableBufferIndex + 4L + (long)this.offsetsBufferIndex + 4L + this.getNullsBufferSerializedSizeInBytes();
    }

    @Override
    protected void setupDecodedBlockAndMapPositions(DecodedBlockNode decodedBlockNode) {
        Objects.requireNonNull(decodedBlockNode, "decodedBlockNode is null");
        decodedBlockNode = this.mapPositionsToNestedBlock(decodedBlockNode);
        this.columnarMap = (ColumnarMap)decodedBlockNode.getDecodedBlock();
        this.decodedBlock = this.columnarMap.getNullCheckBlock();
        this.populateNestedPositions();
        ((AbstractBlockEncodingBuffer)this.keyBuffers).setupDecodedBlockAndMapPositions(decodedBlockNode.getChildren().get(0));
        ((AbstractBlockEncodingBuffer)this.valueBuffers).setupDecodedBlockAndMapPositions(decodedBlockNode.getChildren().get(1));
    }

    @Override
    protected void accumulateSerializedRowSizes(int[] positionOffsets, int positionCount, int[] serializedRowSizes) {
        if (this.positionCount == 0) {
            return;
        }
        int lastOffset = positionOffsets[0];
        for (int i = 0; i < positionCount; ++i) {
            int offset = positionOffsets[i + 1];
            int n = i;
            serializedRowSizes[n] = serializedRowSizes[n] + 5 * (offset - lastOffset);
            lastOffset = offset;
            positionOffsets[i + 1] = this.offsets[offset];
        }
        this.offsetsCopy = Arrays.ensureCapacity((int[])this.offsetsCopy, (int)(positionCount + 1));
        System.arraycopy(positionOffsets, 0, this.offsetsCopy, 0, positionCount + 1);
        ((AbstractBlockEncodingBuffer)this.keyBuffers).accumulateSerializedRowSizes(positionOffsets, positionCount, serializedRowSizes);
        ((AbstractBlockEncodingBuffer)this.valueBuffers).accumulateSerializedRowSizes(this.offsetsCopy, positionCount, serializedRowSizes);
    }

    private void populateNestedPositions() {
        ((AbstractBlockEncodingBuffer)this.keyBuffers).resetPositions();
        ((AbstractBlockEncodingBuffer)this.valueBuffers).resetPositions();
        if (this.positionCount == 0) {
            return;
        }
        this.offsets = Arrays.ensureCapacity((int[])this.offsets, (int)(this.positionCount + 1));
        int[] positions = this.getPositions();
        for (int i = 0; i < this.positionCount; ++i) {
            int position = positions[i];
            int beginOffset = this.columnarMap.getOffset(position);
            int endOffset = this.columnarMap.getOffset(position + 1);
            int currentRowSize = endOffset - beginOffset;
            this.offsets[i + 1] = this.offsets[i] + currentRowSize;
            if (currentRowSize <= 0) continue;
            ((AbstractBlockEncodingBuffer)this.keyBuffers).appendPositionRange(beginOffset, currentRowSize);
            ((AbstractBlockEncodingBuffer)this.valueBuffers).appendPositionRange(beginOffset, currentRowSize);
        }
    }

    private void appendOffsets() {
        this.offsetsBuffer = Arrays.ensureCapacity((byte[])this.offsetsBuffer, (int)(this.offsetsBufferIndex + this.batchSize * Unsafe.ARRAY_INT_INDEX_SCALE), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.LARGE, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE);
        int baseOffset = this.lastOffset - this.offsets[this.positionsOffset];
        for (int i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
            this.offsetsBufferIndex = UncheckedByteArrays.setIntUnchecked(this.offsetsBuffer, this.offsetsBufferIndex, this.offsets[i + 1] + baseOffset);
        }
        this.lastOffset = this.offsets[this.positionsOffset + this.batchSize] + baseOffset;
    }

    private void appendHashTables() {
        if (this.noHashTables) {
            return;
        }
        Optional hashTables = this.columnarMap.getHashTables();
        if (!hashTables.isPresent()) {
            this.noHashTables = true;
            this.hashTableBufferIndex = 0;
            return;
        }
        int hashTablesSize = (this.offsets[this.positionsOffset + this.batchSize] - this.offsets[this.positionsOffset]) * 2;
        this.hashTablesBuffer = Arrays.ensureCapacity((byte[])this.hashTablesBuffer, (int)(this.hashTableBufferIndex + hashTablesSize * Unsafe.ARRAY_INT_INDEX_SCALE), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.LARGE, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE);
        int[] positions = this.getPositions();
        for (int i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
            int position = positions[i];
            int beginOffset = this.columnarMap.getAbsoluteOffset(position);
            int endOffset = this.columnarMap.getAbsoluteOffset(position + 1);
            this.hashTableBufferIndex = MoreByteArrays.setInts(this.hashTablesBuffer, this.hashTableBufferIndex, (int[])hashTables.get(), beginOffset * 2, (endOffset - beginOffset) * 2);
        }
    }
}

