/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.ColumnarArray;
import com.facebook.presto.spi.block.ColumnarMap;
import com.facebook.presto.spi.block.ColumnarRow;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

class DecodedBlockNode {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DecodedBlockNode.class).instanceSize();
    private final Object decodedBlock;
    private final List<DecodedBlockNode> children;

    public DecodedBlockNode(Object decodedBlock, List<DecodedBlockNode> children) {
        this.decodedBlock = Objects.requireNonNull(decodedBlock, "decodedBlock is null");
        this.children = Objects.requireNonNull(children, "children is null");
    }

    public Object getDecodedBlock() {
        return this.decodedBlock;
    }

    public List<DecodedBlockNode> getChildren() {
        return this.children;
    }

    public long getRetainedSizeInBytes() {
        int size = INSTANCE_SIZE;
        if (this.decodedBlock instanceof Block) {
            size = (int)((long)size + ((Block)this.decodedBlock).getRetainedSizeInBytes());
        } else if (this.decodedBlock instanceof ColumnarArray) {
            size = (int)((long)size + ((ColumnarArray)this.decodedBlock).getRetainedSizeInBytes());
        } else if (this.decodedBlock instanceof ColumnarMap) {
            size = (int)((long)size + ((ColumnarMap)this.decodedBlock).getRetainedSizeInBytes());
        } else if (this.decodedBlock instanceof ColumnarRow) {
            size = (int)((long)size + ((ColumnarRow)this.decodedBlock).getRetainedSizeInBytes());
        }
        for (DecodedBlockNode child : this.children) {
            size = (int)((long)size + child.getRetainedSizeInBytes());
        }
        return size;
    }
}

