/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.PageFilter;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.google.common.base.Verify;
import java.util.Objects;
import java.util.Optional;

public class DictionaryAwarePageFilter
implements PageFilter {
    private final PageFilter filter;
    private Block lastInputDictionary;
    private Optional<boolean[]> lastOutputDictionary;
    private long lastDictionaryUsageCount;

    public DictionaryAwarePageFilter(PageFilter filter) {
        this.filter = Objects.requireNonNull(filter, "filter is null");
        Verify.verify((boolean)filter.isDeterministic(), (String)"filter must be deterministic", (Object[])new Object[0]);
        Verify.verify((filter.getInputChannels().size() == 1 ? 1 : 0) != 0, (String)"filter must have only one input", (Object[])new Object[0]);
    }

    @Override
    public boolean isDeterministic() {
        return this.filter.isDeterministic();
    }

    @Override
    public InputChannels getInputChannels() {
        return this.filter.getInputChannels();
    }

    @Override
    public SelectedPositions filter(ConnectorSession session, Page page) {
        Block value;
        Optional<boolean[]> selectedPosition;
        Block block = page.getBlock(0).getLoadedBlock();
        if (block instanceof RunLengthEncodedBlock && (selectedPosition = this.processDictionary(session, value = ((RunLengthEncodedBlock)block).getValue())).isPresent()) {
            return SelectedPositions.positionsRange(0, selectedPosition.get()[0] ? page.getPositionCount() : 0);
        }
        if (block instanceof DictionaryBlock) {
            DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
            Optional<boolean[]> selectedDictionaryPositions = this.processDictionary(session, dictionaryBlock.getDictionary());
            this.lastDictionaryUsageCount += (long)page.getPositionCount();
            if (selectedDictionaryPositions.isPresent()) {
                return DictionaryAwarePageFilter.selectDictionaryPositions(dictionaryBlock, selectedDictionaryPositions.get());
            }
        }
        return this.filter.filter(session, new Page(new Block[]{block}));
    }

    private Optional<boolean[]> processDictionary(ConnectorSession session, Block dictionary) {
        if (this.lastInputDictionary == dictionary) {
            return this.lastOutputDictionary;
        }
        boolean shouldProcessDictionary = this.lastInputDictionary == null || dictionary.getPositionCount() == 1 || this.lastDictionaryUsageCount >= (long)this.lastInputDictionary.getPositionCount();
        this.lastDictionaryUsageCount = 0L;
        this.lastInputDictionary = dictionary;
        if (shouldProcessDictionary) {
            try {
                SelectedPositions selectedDictionaryPositions = this.filter.filter(session, new Page(new Block[]{dictionary}));
                this.lastOutputDictionary = Optional.of(DictionaryAwarePageFilter.toPositionsMask(selectedDictionaryPositions, dictionary.getPositionCount()));
            }
            catch (Exception ignored) {
                this.lastOutputDictionary = Optional.empty();
            }
        } else {
            this.lastOutputDictionary = Optional.empty();
        }
        return this.lastOutputDictionary;
    }

    private static SelectedPositions selectDictionaryPositions(DictionaryBlock dictionaryBlock, boolean[] selectedDictionaryPositions) {
        int selectedCount = 0;
        for (int position = 0; position < dictionaryBlock.getPositionCount(); ++position) {
            if (!selectedDictionaryPositions[dictionaryBlock.getId(position)]) continue;
            ++selectedCount;
        }
        if (selectedCount == 0 || selectedCount == dictionaryBlock.getPositionCount()) {
            return SelectedPositions.positionsRange(0, selectedCount);
        }
        int[] positions = new int[selectedCount];
        int index = 0;
        for (int position = 0; position < dictionaryBlock.getPositionCount(); ++position) {
            if (!selectedDictionaryPositions[dictionaryBlock.getId(position)]) continue;
            positions[index] = position;
            ++index;
        }
        return SelectedPositions.positionsList(positions, 0, selectedCount);
    }

    private static boolean[] toPositionsMask(SelectedPositions selectedPositions, int positionCount) {
        boolean[] positionsMask = new boolean[positionCount];
        if (selectedPositions.isList()) {
            int offset = selectedPositions.getOffset();
            int[] positions = selectedPositions.getPositions();
            for (int index = offset; index < offset + selectedPositions.size(); ++index) {
                positionsMask[positions[index]] = true;
            }
        } else {
            int offset;
            for (int position = offset = selectedPositions.getOffset(); position < offset + selectedPositions.size(); ++position) {
                positionsMask[position] = true;
            }
        }
        return positionsMask;
    }
}

