/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.fixedhistogram;

import com.facebook.presto.operator.aggregation.fixedhistogram.FixedHistogramUtils;
import com.google.common.base.Preconditions;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class FixedDoubleHistogram
implements Iterable<Bucket> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(FixedDoubleHistogram.class).instanceSize();
    private final double[] weights;
    private int bucketCount;
    private double min;
    private double max;

    public FixedDoubleHistogram(int bucketCount, double min, double max) {
        FixedHistogramUtils.validateParameters(bucketCount, min, max);
        this.bucketCount = bucketCount;
        this.min = min;
        this.max = max;
        this.weights = new double[bucketCount];
    }

    private FixedDoubleHistogram(int bucketCount, double min, double max, double[] weights) {
        FixedHistogramUtils.validateParameters(bucketCount, min, max);
        this.bucketCount = bucketCount;
        this.min = min;
        this.max = max;
        this.weights = Objects.requireNonNull(weights, "weights is null");
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getWidth() {
        return (this.max - this.min) / (double)this.bucketCount;
    }

    private FixedDoubleHistogram(FixedDoubleHistogram other) {
        this.bucketCount = other.bucketCount;
        this.min = other.min;
        this.max = other.max;
        this.weights = new double[this.bucketCount];
        System.arraycopy(other.weights, 0, this.weights, 0, this.bucketCount);
    }

    public int getRequiredBytesForSerialization() {
        return 21 + 8 * this.bucketCount;
    }

    public static FixedDoubleHistogram deserialize(SliceInput input) {
        int bucketCount = input.readInt();
        double min = input.readDouble();
        double max = input.readDouble();
        FixedHistogramUtils.validateParameters(bucketCount, min, max);
        double[] weights = new double[bucketCount];
        input.readBytes(Slices.wrappedDoubleArray((double[])weights), bucketCount * 8);
        return new FixedDoubleHistogram(bucketCount, min, max, weights);
    }

    public void serialize(SliceOutput out) {
        out.appendInt(this.bucketCount).appendDouble(this.min).appendDouble(this.max).appendBytes(Slices.wrappedDoubleArray((double[])this.weights, (int)0, (int)this.bucketCount));
    }

    public long estimatedInMemorySize() {
        return INSTANCE_SIZE + 8 * this.bucketCount;
    }

    public void set(double value, double weight) {
        this.weights[FixedHistogramUtils.getIndexForValue((int)this.bucketCount, (double)this.min, (double)this.max, (double)value)] = weight;
    }

    public void add(double value) {
        this.add(value, 1.0);
    }

    public void add(double value, double weight) {
        int n = FixedHistogramUtils.getIndexForValue(this.bucketCount, this.min, this.max, value);
        this.weights[n] = this.weights[n] + weight;
    }

    public void mergeWith(FixedDoubleHistogram other) {
        Preconditions.checkArgument((this.min == other.min ? 1 : 0) != 0, (String)"min %s must be equal to other min %s", (Object)this.min, (Object)other.min);
        Preconditions.checkArgument((this.max == other.max ? 1 : 0) != 0, (String)"max %s must be equal to other max %s", (Object)this.max, (Object)other.max);
        Preconditions.checkArgument((this.bucketCount == other.bucketCount ? 1 : 0) != 0, (String)"bucketCount %s must be equal to other bucketCount %s", (int)this.bucketCount, (int)other.bucketCount);
        for (int i = 0; i < this.bucketCount; ++i) {
            int n = i;
            this.weights[n] = this.weights[n] + other.weights[i];
        }
    }

    @Override
    public Iterator<Bucket> iterator() {
        final int bucketCount = this.getBucketCount();
        final double min = this.getMin();
        final double max = this.getMax();
        return new Iterator<Bucket>(){
            private int currentIndex;

            @Override
            public boolean hasNext() {
                return this.currentIndex < bucketCount;
            }

            @Override
            public Bucket next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Bucket value = new Bucket(FixedHistogramUtils.getLeftValueForIndex(bucketCount, min, max, this.currentIndex), FixedHistogramUtils.getRightValueForIndex(bucketCount, min, max, this.currentIndex), FixedDoubleHistogram.this.weights[this.currentIndex]);
                ++this.currentIndex;
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public FixedDoubleHistogram clone() {
        return new FixedDoubleHistogram(this);
    }

    public static class Bucket {
        private final double left;
        private final double right;
        private final double weight;

        public double getLeft() {
            return this.left;
        }

        public double getRight() {
            return this.right;
        }

        public double getWeight() {
            return this.weight;
        }

        public Bucket(double left, double right, double weight) {
            this.left = left;
            this.right = right;
            this.weight = weight;
        }
    }
}

