/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.operator.aggregation.differentialentropy.DifferentialEntropyState;
import com.facebook.presto.operator.aggregation.differentialentropy.DifferentialEntropyStateStrategy;
import com.facebook.presto.operator.aggregation.differentialentropy.FixedHistogramJacknifeStateStrategy;
import com.facebook.presto.operator.aggregation.differentialentropy.FixedHistogramMleStateStrategy;
import com.facebook.presto.operator.aggregation.differentialentropy.UnweightedReservoirSampleStateStrategy;
import com.facebook.presto.operator.aggregation.differentialentropy.WeightedReservoirSampleStateStrategy;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.google.common.base.Verify;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;

public class DifferentialEntropyStateSerializer
implements AccumulatorStateSerializer<DifferentialEntropyState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(DifferentialEntropyState state, BlockBuilder output) {
        DifferentialEntropyStateStrategy strategy = state.getStrategy();
        if (strategy == null) {
            SliceOutput sliceOut = Slices.allocate((int)4).getOutput();
            sliceOut.appendInt(0);
            VarbinaryType.VARBINARY.writeSlice(output, sliceOut.getUnderlyingSlice());
            return;
        }
        int requiredBytes = 4 + strategy.getRequiredBytesForSerialization();
        SliceOutput sliceOut = Slices.allocate((int)requiredBytes).getOutput();
        if (strategy instanceof UnweightedReservoirSampleStateStrategy) {
            sliceOut.appendInt(1);
        } else if (strategy instanceof WeightedReservoirSampleStateStrategy) {
            sliceOut.appendInt(2);
        } else if (strategy instanceof FixedHistogramMleStateStrategy) {
            sliceOut.appendInt(3);
        } else if (strategy instanceof FixedHistogramJacknifeStateStrategy) {
            sliceOut.appendInt(4);
        } else {
            Verify.verify((boolean)false, (String)String.format("Strategy cannot be serialized: %s", strategy.getClass().getSimpleName()), (Object[])new Object[0]);
        }
        strategy.serialize(sliceOut);
        VarbinaryType.VARBINARY.writeSlice(output, sliceOut.getUnderlyingSlice());
    }

    public void deserialize(Block block, int index, DifferentialEntropyState state) {
        BasicSliceInput input = VarbinaryType.VARBINARY.getSlice(block, index).getInput();
        int method = input.readInt();
        switch (method) {
            case 0: {
                Verify.verify((state.getStrategy() == null ? 1 : 0) != 0, (String)"strategy is not null for null method", (Object[])new Object[0]);
                return;
            }
            case 1: {
                state.setStrategy(UnweightedReservoirSampleStateStrategy.deserialize((SliceInput)input));
                return;
            }
            case 2: {
                state.setStrategy(WeightedReservoirSampleStateStrategy.deserialize((SliceInput)input));
                return;
            }
            case 3: {
                state.setStrategy(FixedHistogramMleStateStrategy.deserialize((SliceInput)input));
                return;
            }
            case 4: {
                state.setStrategy(FixedHistogramJacknifeStateStrategy.deserialize((SliceInput)input));
                return;
            }
        }
        Verify.verify((boolean)false, (String)String.format("Unknown method code when deserializing: %s", method), (Object[])new Object[0]);
    }
}

