/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.state.EntropyState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.DoubleType;

@AggregationFunction(value="entropy")
@Description(value="Takes non-negative count inputs, and computes the log-2 entropy of their fractions when normalized to sum to 1.")
public final class EntropyAggregation {
    private EntropyAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState EntropyState state, @SqlType(value="bigint") long count) {
        if (count < 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Entropy count argument must be non-negative");
        }
        if (count == 0L) {
            return;
        }
        state.setSumC(state.getSumC() + (double)count);
        state.setSumCLogC(state.getSumCLogC() + (double)count * Math.log(count));
    }

    @CombineFunction
    public static void combine(@AggregationState EntropyState state, @AggregationState EntropyState otherState) {
        state.setSumC(state.getSumC() + otherState.getSumC());
        state.setSumCLogC(state.getSumCLogC() + otherState.getSumCLogC());
    }

    @OutputFunction(value="double")
    public static void output(@AggregationState EntropyState state, BlockBuilder out) {
        Double entropy = 0.0;
        if (state.getSumC() > 0.0) {
            entropy = Math.max((Math.log(state.getSumC()) - state.getSumCLogC() / state.getSumC()) / Math.log(2.0), 0.0);
        }
        DoubleType.DOUBLE.writeDouble(out, entropy.doubleValue());
    }
}

