/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupedTopNBuilder;
import com.facebook.presto.operator.NoChannelGroupByHash;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.SimplePageWithPositionComparator;
import com.facebook.presto.operator.Work;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TopNRowNumberOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalMemoryContext localUserMemoryContext;
    private final List<Integer> outputChannels;
    private final GroupByHash groupByHash;
    private final GroupedTopNBuilder groupedTopNBuilder;
    private boolean finishing;
    private Work<?> unfinishedWork;
    private Iterator<Page> outputIterator;

    public TopNRowNumberOperator(OperatorContext operatorContext, List<? extends Type> sourceTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<Type> partitionTypes, List<Integer> sortChannels, List<SortOrder> sortOrders, int maxRowCountPerPartition, boolean generateRowNumber, Optional<Integer> hashChannel, int expectedPositions, JoinCompiler joinCompiler) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
        ImmutableList.Builder outputChannelsBuilder = ImmutableList.builder();
        for (int channel : Objects.requireNonNull(outputChannels, "outputChannels is null")) {
            outputChannelsBuilder.add((Object)channel);
        }
        if (generateRowNumber) {
            outputChannelsBuilder.add((Object)outputChannels.size());
        }
        this.outputChannels = outputChannelsBuilder.build();
        Preconditions.checkArgument((maxRowCountPerPartition > 0 ? 1 : 0) != 0, (Object)"maxRowCountPerPartition must be > 0");
        if (!partitionChannels.isEmpty()) {
            Preconditions.checkArgument((expectedPositions > 0 ? 1 : 0) != 0, (Object)"expectedPositions must be > 0");
            this.groupByHash = GroupByHash.createGroupByHash(partitionTypes, Ints.toArray(partitionChannels), hashChannel, expectedPositions, SystemSessionProperties.isDictionaryAggregationEnabled(operatorContext.getSession()), joinCompiler, this::updateMemoryReservation);
        } else {
            this.groupByHash = new NoChannelGroupByHash();
        }
        List<Type> types = TopNRowNumberOperator.toTypes(sourceTypes, outputChannels, generateRowNumber);
        this.groupedTopNBuilder = new GroupedTopNBuilder((List<Type>)ImmutableList.copyOf(sourceTypes), new SimplePageWithPositionComparator(types, sortChannels, sortOrders), maxRowCountPerPartition, generateRowNumber, this.groupByHash);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.outputIterator != null && !this.outputIterator.hasNext() && this.unfinishedWork == null;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.outputIterator == null && this.unfinishedWork == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkState((this.unfinishedWork == null ? 1 : 0) != 0, (Object)"Cannot add input with the operator when unfinished work is not empty");
        Preconditions.checkState((this.outputIterator == null ? 1 : 0) != 0, (Object)"Cannot add input with the operator when flushing");
        Objects.requireNonNull(page, "page is null");
        this.unfinishedWork = this.groupedTopNBuilder.processPage(page);
        if (this.unfinishedWork.process()) {
            this.unfinishedWork = null;
        }
        this.updateMemoryReservation();
    }

    @Override
    public Page getOutput() {
        if (this.unfinishedWork != null) {
            boolean finished = this.unfinishedWork.process();
            this.updateMemoryReservation();
            if (!finished) {
                return null;
            }
            this.unfinishedWork = null;
        }
        if (!this.finishing) {
            return null;
        }
        if (this.outputIterator == null) {
            this.outputIterator = this.groupedTopNBuilder.buildResult();
        }
        Page output = null;
        if (this.outputIterator.hasNext()) {
            Page page = this.outputIterator.next();
            Block[] blocks = new Block[page.getChannelCount()];
            for (int i = 0; i < this.outputChannels.size(); ++i) {
                blocks[i] = page.getBlock(this.outputChannels.get(i).intValue());
            }
            output = new Page(blocks);
        }
        this.updateMemoryReservation();
        return output;
    }

    @VisibleForTesting
    public int getCapacity() {
        Preconditions.checkState((this.groupByHash != null ? 1 : 0) != 0);
        return this.groupByHash.getCapacity();
    }

    private boolean updateMemoryReservation() {
        this.localUserMemoryContext.setBytes(this.groupedTopNBuilder.getEstimatedSizeInBytes());
        return this.operatorContext.isWaitingForMemory().isDone();
    }

    private static List<Type> toTypes(List<? extends Type> sourceTypes, List<Integer> outputChannels, boolean generateRowNumber) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (int channel : outputChannels) {
            types.add((Object)sourceTypes.get(channel));
        }
        if (generateRowNumber) {
            types.add((Object)BigintType.BIGINT);
        }
        return types.build();
    }

    public static class TopNRowNumberOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final List<Integer> outputChannels;
        private final List<Integer> partitionChannels;
        private final List<Type> partitionTypes;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrder;
        private final int maxRowCountPerPartition;
        private final boolean partial;
        private final Optional<Integer> hashChannel;
        private final int expectedPositions;
        private final boolean generateRowNumber;
        private boolean closed;
        private final JoinCompiler joinCompiler;

        public TopNRowNumberOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> sourceTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<? extends Type> partitionTypes, List<Integer> sortChannels, List<SortOrder> sortOrder, int maxRowCountPerPartition, boolean partial, Optional<Integer> hashChannel, int expectedPositions, JoinCompiler joinCompiler) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = ImmutableList.copyOf(sourceTypes);
            this.outputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
            this.partitionChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionChannels, "partitionChannels is null"));
            this.partitionTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionTypes, "partitionTypes is null"));
            this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels));
            this.sortOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrder));
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.partial = partial;
            Preconditions.checkArgument((maxRowCountPerPartition > 0 ? 1 : 0) != 0, (Object)"maxRowCountPerPartition must be > 0");
            this.maxRowCountPerPartition = maxRowCountPerPartition;
            Preconditions.checkArgument((expectedPositions > 0 ? 1 : 0) != 0, (Object)"expectedPositions must be > 0");
            this.generateRowNumber = !partial;
            this.expectedPositions = expectedPositions;
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TopNRowNumberOperator.class.getSimpleName());
            return new TopNRowNumberOperator(operatorContext, this.sourceTypes, this.outputChannels, this.partitionChannels, this.partitionTypes, this.sortChannels, this.sortOrder, this.maxRowCountPerPartition, this.generateRowNumber, this.hashChannel, this.expectedPositions, this.joinCompiler);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new TopNRowNumberOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.outputChannels, this.partitionChannels, this.partitionTypes, this.sortChannels, this.sortOrder, this.maxRowCountPerPartition, this.partial, this.hashChannel, this.expectedPositions, this.joinCompiler);
        }
    }
}

