/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DevNullOperator;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperationTimer;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.TableCommitContext;
import com.facebook.presto.operator.TableWriterMergeInfo;
import com.facebook.presto.operator.TableWriterUtils;
import com.facebook.presto.operator.aggregation.builder.InMemoryHashAggregationBuilder;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;

public class TableWriterMergeOperator
implements Operator {
    private final OperatorContext context;
    private final Operator statisticsAggregationOperator;
    private final JsonCodec<TableCommitContext> tableCommitContextCodec;
    private final LocalMemoryContext systemMemoryContext;
    private final List<Type> types;
    private final OperationTimer.OperationTiming statisticsTiming = new OperationTimer.OperationTiming();
    private final boolean statisticsCpuTimerEnabled;
    private TableCommitContext lastTableCommitContext;
    private long rowCount;
    private final Queue<Block> fragmentsBlocks = new LinkedList<Block>();
    private State state = State.RUNNING;

    public TableWriterMergeOperator(OperatorContext context, Operator statisticsAggregationOperator, JsonCodec<TableCommitContext> tableCommitContextCodec, boolean statisticsCpuTimerEnabled, List<Type> types) {
        this.context = Objects.requireNonNull(context, "context is null");
        this.statisticsAggregationOperator = Objects.requireNonNull(statisticsAggregationOperator, "statisticAggregationOperator is null");
        this.systemMemoryContext = context.newLocalSystemMemoryContext(InMemoryHashAggregationBuilder.class.getSimpleName());
        this.tableCommitContextCodec = Objects.requireNonNull(tableCommitContextCodec, "tableCommitContextCodec is null");
        this.statisticsCpuTimerEnabled = statisticsCpuTimerEnabled;
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.context.setInfoSupplier(this::getInfo);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.context;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.statisticsAggregationOperator.isBlocked();
    }

    @Override
    public boolean needsInput() {
        if (this.state != State.RUNNING) {
            return false;
        }
        return this.statisticsAggregationOperator.needsInput();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.state == State.RUNNING ? 1 : 0) != 0, (String)"Operator is %s", (Object)((Object)this.state));
        TableCommitContext tableCommitContext = TableWriterUtils.getTableCommitContext(page, this.tableCommitContextCodec);
        if (this.lastTableCommitContext != null) {
            Preconditions.checkArgument((boolean)TableWriterMergeOperator.isSameTaskAndLifespan(this.lastTableCommitContext, tableCommitContext), (String)"incompatible table commit context: %s is not compatible with %s", (Object)this.lastTableCommitContext, (Object)tableCommitContext);
        }
        this.lastTableCommitContext = tableCommitContext;
        this.rowCount += TableWriterMergeOperator.getRowCount(page);
        Block fragmentsBlock = page.getBlock(1);
        if (TableWriterMergeOperator.containsNonNullRows(fragmentsBlock)) {
            this.fragmentsBlocks.add(fragmentsBlock);
        }
        TableWriterUtils.extractStatisticsRows(page).ifPresent(statisticsPage -> {
            OperationTimer timer = new OperationTimer(this.statisticsCpuTimerEnabled);
            this.statisticsAggregationOperator.addInput((Page)statisticsPage);
            timer.end(this.statisticsTiming);
        });
        this.systemMemoryContext.setBytes(this.getRetainedMemoryBytes());
    }

    private static long getRowCount(Page page) {
        long rowCount = 0L;
        Block rowCountBlock = page.getBlock(0);
        for (int position = 0; position < page.getPositionCount(); ++position) {
            if (rowCountBlock.isNull(position)) continue;
            rowCount += BigintType.BIGINT.getLong(rowCountBlock, position);
        }
        return rowCount;
    }

    private static boolean containsNonNullRows(Block block) {
        if (block instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock runLengthEncodedBlock = (RunLengthEncodedBlock)block;
            return !runLengthEncodedBlock.getValue().isNull(0);
        }
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSameTaskAndLifespan(TableCommitContext first, TableCommitContext second) {
        return first.getLifespan().equals(second.getLifespan()) && first.getTaskId().equals(second.getTaskId()) && first.isLifespanCommitRequired() == second.isLifespanCommitRequired();
    }

    private long getRetainedMemoryBytes() {
        return this.fragmentsBlocks.stream().mapToLong(Block::getRetainedSizeInBytes).sum();
    }

    @Override
    public Page getOutput() {
        if (!this.fragmentsBlocks.isEmpty()) {
            Block fragmentsBlock = this.fragmentsBlocks.poll();
            this.systemMemoryContext.setBytes(this.getRetainedMemoryBytes());
            return this.createFragmentsPage(fragmentsBlock);
        }
        if (!this.isBlocked().isDone()) {
            return null;
        }
        if (!this.statisticsAggregationOperator.isFinished()) {
            Verify.verify((boolean)this.statisticsAggregationOperator.isBlocked().isDone(), (String)"aggregation operator should not be blocked", (Object[])new Object[0]);
            OperationTimer timer = new OperationTimer(this.statisticsCpuTimerEnabled);
            Page page = this.statisticsAggregationOperator.getOutput();
            timer.end(this.statisticsTiming);
            if (page == null) {
                return null;
            }
            return TableWriterUtils.createStatisticsPage(this.types, page, this.createTableCommitContext(false));
        }
        if (this.state != State.FINISHING) {
            return null;
        }
        this.state = State.FINISHED;
        Page finalPage = this.createFinalPage();
        this.systemMemoryContext.setBytes(this.getRetainedMemoryBytes());
        return finalPage;
    }

    private Page createFragmentsPage(Block fragmentsBlock) {
        int positionCount = fragmentsBlock.getPositionCount();
        Block[] outputBlocks = new Block[this.types.size()];
        for (int channel = 0; channel < this.types.size(); ++channel) {
            outputBlocks[channel] = channel == 1 ? fragmentsBlock : (channel == 2 ? RunLengthEncodedBlock.create((Type)this.types.get(channel), (Object)this.createTableCommitContext(false), (int)positionCount) : RunLengthEncodedBlock.create((Type)this.types.get(channel), null, (int)positionCount));
        }
        return new Page(outputBlocks);
    }

    private Page createFinalPage() {
        Preconditions.checkState((boolean)this.lastTableCommitContext.isLastPage(), (String)"unexpected last table commit context: %s", (Object)this.lastTableCommitContext);
        PageBuilder pageBuilder = new PageBuilder(1, this.types);
        pageBuilder.declarePosition();
        for (int channel = 0; channel < this.types.size(); ++channel) {
            if (channel == 0) {
                this.types.get(channel).writeLong(pageBuilder.getBlockBuilder(channel), this.rowCount);
                continue;
            }
            if (channel == 2) {
                this.types.get(channel).writeSlice(pageBuilder.getBlockBuilder(channel), this.createTableCommitContext(true));
                continue;
            }
            pageBuilder.getBlockBuilder(channel).appendNull();
        }
        return pageBuilder.build();
    }

    private Slice createTableCommitContext(boolean lastPage) {
        Preconditions.checkState((this.tableCommitContextCodec != null ? 1 : 0) != 0, (Object)"tableCommitContextCodec is null");
        return Slices.wrappedBuffer((byte[])this.tableCommitContextCodec.toJsonBytes((Object)new TableCommitContext(this.lastTableCommitContext.getLifespan(), this.lastTableCommitContext.getTaskId(), this.lastTableCommitContext.isLifespanCommitRequired(), lastPage)));
    }

    @Override
    public void finish() {
        OperationTimer timer = new OperationTimer(this.statisticsCpuTimerEnabled);
        this.statisticsAggregationOperator.finish();
        timer.end(this.statisticsTiming);
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
        }
    }

    @Override
    public boolean isFinished() {
        if (this.state == State.FINISHED) {
            Verify.verify((boolean)this.statisticsAggregationOperator.isFinished());
            return true;
        }
        return false;
    }

    @Override
    public void close() throws Exception {
        this.statisticsAggregationOperator.close();
        this.systemMemoryContext.setBytes(0L);
    }

    public TableWriterMergeInfo getInfo() {
        return new TableWriterMergeInfo(Duration.succinctNanos((long)this.statisticsTiming.getWallNanos()), Duration.succinctNanos((long)this.statisticsTiming.getCpuNanos()));
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class TableWriterMergeOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final OperatorFactory statisticsAggregationOperatorFactory;
        private final JsonCodec<TableCommitContext> tableCommitContextCodec;
        private final Session session;
        private final List<Type> types;
        private boolean closed;

        public TableWriterMergeOperatorFactory(int operatorId, PlanNodeId planNodeId, OperatorFactory statisticsAggregationOperatorFactory, JsonCodec<TableCommitContext> tableCommitContextCodec, Session session, List<Type> types) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.statisticsAggregationOperatorFactory = Objects.requireNonNull(statisticsAggregationOperatorFactory, "statisticsAggregationOperatorFactory is null");
            this.tableCommitContextCodec = Objects.requireNonNull(tableCommitContextCodec, "tableCommitContextCodec is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TableWriterMergeOperator.class.getSimpleName());
            Operator statisticsAggregationOperator = this.statisticsAggregationOperatorFactory.createOperator(driverContext);
            boolean statisticsCpuTimerEnabled = !(statisticsAggregationOperator instanceof DevNullOperator) && SystemSessionProperties.isStatisticsCpuTimerEnabled(this.session);
            return new TableWriterMergeOperator(context, statisticsAggregationOperator, this.tableCommitContextCodec, statisticsCpuTimerEnabled, this.types);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new TableWriterMergeOperatorFactory(this.operatorId, this.planNodeId, this.statisticsAggregationOperatorFactory, this.tableCommitContextCodec, this.session, this.types);
        }
    }
}

